<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/reservation/v1/reservation.proto

namespace Google\Cloud\BigQuery\Reservation\V1\Reservation;

use UnexpectedValueException;

/**
 * The scaling mode for the reservation. This enum determines how the
 * reservation scales up and down.
 *
 * Protobuf type <code>google.cloud.bigquery.reservation.v1.Reservation.ScalingMode</code>
 */
class ScalingMode
{
    /**
     * Default value of ScalingMode.
     *
     * Generated from protobuf enum <code>SCALING_MODE_UNSPECIFIED = 0;</code>
     */
    const SCALING_MODE_UNSPECIFIED = 0;
    /**
     * The reservation will scale up only using slots from autoscaling. It will
     * not use any idle slots even if there may be some available. The upper
     * limit that autoscaling can scale up to will be max_slots - baseline.
     * For example, if max_slots is 1000, baseline is 200 and customer sets
     * ScalingMode to AUTOSCALE_ONLY, then autoscalerg will scale up to 800
     * slots and no idle slots will be used.
     * Please note, in this mode, the ignore_idle_slots field must be set to
     * true. Otherwise the request will be rejected with error code
     * `google.rpc.Code.INVALID_ARGUMENT`.
     *
     * Generated from protobuf enum <code>AUTOSCALE_ONLY = 1;</code>
     */
    const AUTOSCALE_ONLY = 1;
    /**
     * The reservation will scale up using only idle slots contributed by
     * other reservations or from unassigned commitments. If no idle slots are
     * available it will not scale up further. If the idle slots which it is
     * using are reclaimed by the contributing reservation(s) it may be forced
     * to scale down. The max idle slots the reservation can be max_slots -
     * baseline capacity. For example, if max_slots is 1000, baseline is 200 and
     * customer sets ScalingMode to IDLE_SLOTS_ONLY,
     * 1. if there are 1000 idle slots available in other reservations, the
     * reservation will scale up to 1000 slots with 200 baseline and 800 idle
     * slots.
     * 2. if there are 500 idle slots available in other reservations, the
     * reservation will scale up to 700 slots with 200 baseline and 300 idle
     * slots.
     * Please note, in this mode, the reservation might not be able to scale up
     * to max_slots.
     * Please note, in this mode, the ignore_idle_slots field must be set to
     * false. Otherwise the request will be rejected with error code
     * `google.rpc.Code.INVALID_ARGUMENT`.
     *
     * Generated from protobuf enum <code>IDLE_SLOTS_ONLY = 2;</code>
     */
    const IDLE_SLOTS_ONLY = 2;
    /**
     * The reservation will scale up using all slots available to it. It will
     * use idle slots contributed by other reservations or from unassigned
     * commitments first. If no idle slots are available it will scale up using
     * autoscaling. For example, if max_slots is 1000, baseline is 200 and
     * customer sets ScalingMode to ALL_SLOTS,
     * 1. if there are 800 idle slots available in other reservations, the
     * reservation will scale up to 1000 slots with 200 baseline and 800 idle
     * slots.
     * 2. if there are 500 idle slots available in other reservations, the
     * reservation will scale up to 1000 slots with 200 baseline, 500 idle
     * slots and 300 autoscaling slots.
     * 3. if there are no idle slots available in other reservations, it will
     * scale up to 1000 slots with 200 baseline and 800 autoscaling slots.
     * Please note, in this mode, the ignore_idle_slots field must be set to
     * false. Otherwise the request will be rejected with error code
     * `google.rpc.Code.INVALID_ARGUMENT`.
     *
     * Generated from protobuf enum <code>ALL_SLOTS = 3;</code>
     */
    const ALL_SLOTS = 3;

    private static $valueToName = [
        self::SCALING_MODE_UNSPECIFIED => 'SCALING_MODE_UNSPECIFIED',
        self::AUTOSCALE_ONLY => 'AUTOSCALE_ONLY',
        self::IDLE_SLOTS_ONLY => 'IDLE_SLOTS_ONLY',
        self::ALL_SLOTS => 'ALL_SLOTS',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


