<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/membership.proto

namespace Google\Apps\Chat\V1\Membership;

use UnexpectedValueException;

/**
 * Represents a user's permitted actions in a Chat space. More enum values
 * might be added in the future.
 *
 * Protobuf type <code>google.chat.v1.Membership.MembershipRole</code>
 */
class MembershipRole
{
    /**
     * Default value. For [users][google.chat.v1.Membership.member]: they
     * aren't a member of the space, but can be invited. For
     * [Google Groups][google.chat.v1.Membership.group_member]: they're always
     *  assigned this role (other enum values might be used in the future).
     *
     * Generated from protobuf enum <code>MEMBERSHIP_ROLE_UNSPECIFIED = 0;</code>
     */
    const MEMBERSHIP_ROLE_UNSPECIFIED = 0;
    /**
     * A member of the space. In the Chat UI, this role is called Member.
     * The user has basic permissions, like sending
     * messages to the space.
     * Managers and owners can grant members additional permissions in a space,
     * including:
     * - Add or remove members.
     * - Modify space details.
     * - Turn history on or off.
     * - Mention everyone in the space with `&#64;all`.
     * - Manage Chat apps and webhooks installed in the space.
     * In direct messages and unnamed group conversations, everyone
     * has this role.
     *
     * Generated from protobuf enum <code>ROLE_MEMBER = 1;</code>
     */
    const ROLE_MEMBER = 1;
    /**
     * A space owner. In the Chat UI, this role is called Owner.
     * The user has the complete set of space permissions to manage the space,
     * including:
     * - Change the role of other members in the space to member, manager, or
     * owner.
     * - Delete the space.
     * Only supported in
     * [SpaceType.SPACE][google.chat.v1.Space.SpaceType] (named spaces).
     * To learn more, see
     * [Learn more about your role as a space
     * owner or manager](https://support.google.com/chat/answer/11833441).
     *
     * Generated from protobuf enum <code>ROLE_MANAGER = 2;</code>
     */
    const ROLE_MANAGER = 2;
    /**
     * A space manager. In the Chat UI, this role is called Manager.
     * The user has all basic permissions of `ROLE_MEMBER`,
     * and can be granted a subset of administrative permissions by an owner.
     * By default, managers have all the permissions of an owner except for the
     * ability to:
     * - Delete the space.
     * - Make another space member an owner.
     * - Change an owner's role.
     * By default, managers permissions include but aren't limited to:
     * - Make another member a manager.
     * - Delete messages in the space.
     * - Manage space permissions.
     * - Receive notifications for requests to join the space if the manager
     *   has the "manage members" permission in the space settings.
     * - Make a space discoverable.
     * Only supported in
     * [SpaceType.SPACE][google.chat.v1.Space.SpaceType] (named spaces).
     * To learn more, see
     * [Manage space settings](https://support.google.com/chat/answer/13340792).
     *
     * Generated from protobuf enum <code>ROLE_ASSISTANT_MANAGER = 4;</code>
     */
    const ROLE_ASSISTANT_MANAGER = 4;

    private static $valueToName = [
        self::MEMBERSHIP_ROLE_UNSPECIFIED => 'MEMBERSHIP_ROLE_UNSPECIFIED',
        self::ROLE_MEMBER => 'ROLE_MEMBER',
        self::ROLE_MANAGER => 'ROLE_MANAGER',
        self::ROLE_ASSISTANT_MANAGER => 'ROLE_ASSISTANT_MANAGER',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


