<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/apps/card/v1/card.proto

namespace Google\Apps\Card\V1\Card;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A persistent (sticky) footer that that appears at the bottom of the card.
 * Setting `fixedFooter` without specifying a `primaryButton` or a
 * `secondaryButton` causes an error.
 * For Chat apps, you can use fixed footers in
 * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
 * [card
 * messages](https://developers.google.com/workspace/chat/create-messages#create).
 * For an example in Google Chat apps, see [Add a persistent
 * footer](https://developers.google.com/workspace/chat/design-components-card-dialog#add_a_persistent_footer).
 * [Google Workspace add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 *
 * Generated from protobuf message <code>google.apps.card.v1.Card.CardFixedFooter</code>
 */
class CardFixedFooter extends \Google\Protobuf\Internal\Message
{
    /**
     * The primary button of the fixed footer. The button must be a text button
     * with text and color set.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Button primary_button = 1;</code>
     */
    protected $primary_button = null;
    /**
     * The secondary button of the fixed footer.  The button must be a text
     * button with text and color set.
     * If `secondaryButton` is set, you must also set `primaryButton`.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Button secondary_button = 2;</code>
     */
    protected $secondary_button = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Apps\Card\V1\Button $primary_button
     *           The primary button of the fixed footer. The button must be a text button
     *           with text and color set.
     *     @type \Google\Apps\Card\V1\Button $secondary_button
     *           The secondary button of the fixed footer.  The button must be a text
     *           button with text and color set.
     *           If `secondaryButton` is set, you must also set `primaryButton`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Apps\Card\V1\Card::initOnce();
        parent::__construct($data);
    }

    /**
     * The primary button of the fixed footer. The button must be a text button
     * with text and color set.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Button primary_button = 1;</code>
     * @return \Google\Apps\Card\V1\Button|null
     */
    public function getPrimaryButton()
    {
        return $this->primary_button;
    }

    public function hasPrimaryButton()
    {
        return isset($this->primary_button);
    }

    public function clearPrimaryButton()
    {
        unset($this->primary_button);
    }

    /**
     * The primary button of the fixed footer. The button must be a text button
     * with text and color set.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Button primary_button = 1;</code>
     * @param \Google\Apps\Card\V1\Button $var
     * @return $this
     */
    public function setPrimaryButton($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Button::class);
        $this->primary_button = $var;

        return $this;
    }

    /**
     * The secondary button of the fixed footer.  The button must be a text
     * button with text and color set.
     * If `secondaryButton` is set, you must also set `primaryButton`.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Button secondary_button = 2;</code>
     * @return \Google\Apps\Card\V1\Button|null
     */
    public function getSecondaryButton()
    {
        return $this->secondary_button;
    }

    public function hasSecondaryButton()
    {
        return isset($this->secondary_button);
    }

    public function clearSecondaryButton()
    {
        unset($this->secondary_button);
    }

    /**
     * The secondary button of the fixed footer.  The button must be a text
     * button with text and color set.
     * If `secondaryButton` is set, you must also set `primaryButton`.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Button secondary_button = 2;</code>
     * @param \Google\Apps\Card\V1\Button $var
     * @return $this
     */
    public function setSecondaryButton($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Button::class);
        $this->secondary_button = $var;

        return $this;
    }

}


