<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/apps/card/v1/card.proto

namespace Google\Apps\Card\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A text, icon, or text and icon button that users can click. For an example in
 * Google Chat apps, see
 * [Add a
 * button](https://developers.google.com/workspace/chat/design-interactive-card-dialog#add_a_button).
 * To make an image a clickable button, specify an
 * [`Image`][google.apps.card.v1.Image] (not an
 * [`ImageComponent`][google.apps.card.v1.ImageComponent]) and set an
 * `onClick` action.
 * [Google Workspace
 * add-ons and Chat apps](https://developers.google.com/workspace/extend):
 *
 * Generated from protobuf message <code>google.apps.card.v1.Button</code>
 */
class Button extends \Google\Protobuf\Internal\Message
{
    /**
     * The text displayed inside the button.
     *
     * Generated from protobuf field <code>string text = 1;</code>
     */
    protected $text = '';
    /**
     * An icon displayed inside the button. If both `icon` and `text` are set,
     * then the icon appears before the text.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Icon icon = 2;</code>
     */
    protected $icon = null;
    /**
     * Optional. The color of the button. If set, the button `type` is set to
     * `FILLED` and the color of `text` and `icon` fields are set to a
     * contrasting color for readability. For example, if the button color is
     * set to blue, any text or icons in the button are set to white.
     * To set the button color, specify a value for the `red`, `green`, and `blue`
     * fields.
     * The value must be a float number between 0 and 1 based on the RGB color
     * value, where `0` (0/255) represents the absence of color  and `1` (255/255)
     * represents the maximum intensity of the color.
     * For example, the following sets the color to red at its maximum intensity:
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     * }
     * ```
     * The `alpha` field is unavailable for button color. If specified, this field
     * is ignored.
     *
     * Generated from protobuf field <code>.google.type.Color color = 3;</code>
     */
    protected $color = null;
    /**
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     */
    protected $on_click = null;
    /**
     * If `true`, the button is displayed in an inactive state and doesn't respond
     * to user actions.
     *
     * Generated from protobuf field <code>bool disabled = 5;</code>
     */
    protected $disabled = false;
    /**
     * The alternative text that's used for accessibility.
     * Set descriptive text that lets users know what the button does. For
     * example, if a button opens a hyperlink, you might write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/workspace/chat".
     *
     * Generated from protobuf field <code>string alt_text = 6;</code>
     */
    protected $alt_text = '';
    /**
     * Optional. The type of a button. If unset, button type defaults to
     * `OUTLINED`. If the `color` field is set, the button type is forced to
     * `FILLED` and any value set for this field is ignored.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Button.Type type = 7;</code>
     */
    protected $type = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $text
     *           The text displayed inside the button.
     *     @type \Google\Apps\Card\V1\Icon $icon
     *           An icon displayed inside the button. If both `icon` and `text` are set,
     *           then the icon appears before the text.
     *     @type \Google\Type\Color $color
     *           Optional. The color of the button. If set, the button `type` is set to
     *           `FILLED` and the color of `text` and `icon` fields are set to a
     *           contrasting color for readability. For example, if the button color is
     *           set to blue, any text or icons in the button are set to white.
     *           To set the button color, specify a value for the `red`, `green`, and `blue`
     *           fields.
     *           The value must be a float number between 0 and 1 based on the RGB color
     *           value, where `0` (0/255) represents the absence of color  and `1` (255/255)
     *           represents the maximum intensity of the color.
     *           For example, the following sets the color to red at its maximum intensity:
     *           ```
     *           "color": {
     *              "red": 1,
     *              "green": 0,
     *              "blue": 0,
     *           }
     *           ```
     *           The `alpha` field is unavailable for button color. If specified, this field
     *           is ignored.
     *     @type \Google\Apps\Card\V1\OnClick $on_click
     *           Required. The action to perform when a user clicks the button, such as
     *           opening a hyperlink or running a custom function.
     *     @type bool $disabled
     *           If `true`, the button is displayed in an inactive state and doesn't respond
     *           to user actions.
     *     @type string $alt_text
     *           The alternative text that's used for accessibility.
     *           Set descriptive text that lets users know what the button does. For
     *           example, if a button opens a hyperlink, you might write: "Opens a new
     *           browser tab and navigates to the Google Chat developer documentation at
     *           https://developers.google.com/workspace/chat".
     *     @type int $type
     *           Optional. The type of a button. If unset, button type defaults to
     *           `OUTLINED`. If the `color` field is set, the button type is forced to
     *           `FILLED` and any value set for this field is ignored.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Apps\Card\V1\Card::initOnce();
        parent::__construct($data);
    }

    /**
     * The text displayed inside the button.
     *
     * Generated from protobuf field <code>string text = 1;</code>
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }

    /**
     * The text displayed inside the button.
     *
     * Generated from protobuf field <code>string text = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setText($var)
    {
        GPBUtil::checkString($var, True);
        $this->text = $var;

        return $this;
    }

    /**
     * An icon displayed inside the button. If both `icon` and `text` are set,
     * then the icon appears before the text.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Icon icon = 2;</code>
     * @return \Google\Apps\Card\V1\Icon|null
     */
    public function getIcon()
    {
        return $this->icon;
    }

    public function hasIcon()
    {
        return isset($this->icon);
    }

    public function clearIcon()
    {
        unset($this->icon);
    }

    /**
     * An icon displayed inside the button. If both `icon` and `text` are set,
     * then the icon appears before the text.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Icon icon = 2;</code>
     * @param \Google\Apps\Card\V1\Icon $var
     * @return $this
     */
    public function setIcon($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Icon::class);
        $this->icon = $var;

        return $this;
    }

    /**
     * Optional. The color of the button. If set, the button `type` is set to
     * `FILLED` and the color of `text` and `icon` fields are set to a
     * contrasting color for readability. For example, if the button color is
     * set to blue, any text or icons in the button are set to white.
     * To set the button color, specify a value for the `red`, `green`, and `blue`
     * fields.
     * The value must be a float number between 0 and 1 based on the RGB color
     * value, where `0` (0/255) represents the absence of color  and `1` (255/255)
     * represents the maximum intensity of the color.
     * For example, the following sets the color to red at its maximum intensity:
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     * }
     * ```
     * The `alpha` field is unavailable for button color. If specified, this field
     * is ignored.
     *
     * Generated from protobuf field <code>.google.type.Color color = 3;</code>
     * @return \Google\Type\Color|null
     */
    public function getColor()
    {
        return $this->color;
    }

    public function hasColor()
    {
        return isset($this->color);
    }

    public function clearColor()
    {
        unset($this->color);
    }

    /**
     * Optional. The color of the button. If set, the button `type` is set to
     * `FILLED` and the color of `text` and `icon` fields are set to a
     * contrasting color for readability. For example, if the button color is
     * set to blue, any text or icons in the button are set to white.
     * To set the button color, specify a value for the `red`, `green`, and `blue`
     * fields.
     * The value must be a float number between 0 and 1 based on the RGB color
     * value, where `0` (0/255) represents the absence of color  and `1` (255/255)
     * represents the maximum intensity of the color.
     * For example, the following sets the color to red at its maximum intensity:
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     * }
     * ```
     * The `alpha` field is unavailable for button color. If specified, this field
     * is ignored.
     *
     * Generated from protobuf field <code>.google.type.Color color = 3;</code>
     * @param \Google\Type\Color $var
     * @return $this
     */
    public function setColor($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Color::class);
        $this->color = $var;

        return $this;
    }

    /**
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     * @return \Google\Apps\Card\V1\OnClick|null
     */
    public function getOnClick()
    {
        return $this->on_click;
    }

    public function hasOnClick()
    {
        return isset($this->on_click);
    }

    public function clearOnClick()
    {
        unset($this->on_click);
    }

    /**
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     * @param \Google\Apps\Card\V1\OnClick $var
     * @return $this
     */
    public function setOnClick($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\OnClick::class);
        $this->on_click = $var;

        return $this;
    }

    /**
     * If `true`, the button is displayed in an inactive state and doesn't respond
     * to user actions.
     *
     * Generated from protobuf field <code>bool disabled = 5;</code>
     * @return bool
     */
    public function getDisabled()
    {
        return $this->disabled;
    }

    /**
     * If `true`, the button is displayed in an inactive state and doesn't respond
     * to user actions.
     *
     * Generated from protobuf field <code>bool disabled = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->disabled = $var;

        return $this;
    }

    /**
     * The alternative text that's used for accessibility.
     * Set descriptive text that lets users know what the button does. For
     * example, if a button opens a hyperlink, you might write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/workspace/chat".
     *
     * Generated from protobuf field <code>string alt_text = 6;</code>
     * @return string
     */
    public function getAltText()
    {
        return $this->alt_text;
    }

    /**
     * The alternative text that's used for accessibility.
     * Set descriptive text that lets users know what the button does. For
     * example, if a button opens a hyperlink, you might write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/workspace/chat".
     *
     * Generated from protobuf field <code>string alt_text = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setAltText($var)
    {
        GPBUtil::checkString($var, True);
        $this->alt_text = $var;

        return $this;
    }

    /**
     * Optional. The type of a button. If unset, button type defaults to
     * `OUTLINED`. If the `color` field is set, the button type is forced to
     * `FILLED` and any value set for this field is ignored.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Button.Type type = 7;</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Optional. The type of a button. If unset, button type defaults to
     * `OUTLINED`. If the `color` field is set, the button type is forced to
     * `FILLED` and any value set for this field is ignored.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Button.Type type = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Card\V1\Button\Type::class);
        $this->type = $var;

        return $this;
    }

}

