<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/apihub/v1/plugin_service.proto

namespace Google\Cloud\ApiHub\V1\PluginInstance;

use UnexpectedValueException;

/**
 * State represents the state of the plugin instance.
 *
 * Protobuf type <code>google.cloud.apihub.v1.PluginInstance.State</code>
 */
class State
{
    /**
     * Default unspecified state.
     *
     * Generated from protobuf enum <code>STATE_UNSPECIFIED = 0;</code>
     */
    const STATE_UNSPECIFIED = 0;
    /**
     * The plugin instance is being created.
     *
     * Generated from protobuf enum <code>CREATING = 1;</code>
     */
    const CREATING = 1;
    /**
     * The plugin instance is active and ready for executions. This is the only
     * state where executions can run on the plugin instance.
     *
     * Generated from protobuf enum <code>ACTIVE = 2;</code>
     */
    const ACTIVE = 2;
    /**
     * The updated config that contains
     * [additional_config][google.cloud.apihub.v1.PluginInstance.additional_config]
     * and [auth_config][google.cloud.apihub.v1.PluginInstance.auth_config] is
     * being applied.
     *
     * Generated from protobuf enum <code>APPLYING_CONFIG = 3;</code>
     */
    const APPLYING_CONFIG = 3;
    /**
     * The ERROR state can come while applying config. Users
     * can retrigger
     * [ApplyPluginInstanceConfig][google.cloud.apihub.v1.ApiHubPlugin.ApplyPluginInstanceConfig]
     * to restore the plugin instance back to active state. Note, In case the
     * ERROR state happens while applying config (auth_config,
     * additional_config), the plugin instance will reflect the config which was
     * trying to be applied while error happened. In order to overwrite, trigger
     * ApplyConfig with a new config.
     *
     * Generated from protobuf enum <code>ERROR = 4;</code>
     */
    const ERROR = 4;
    /**
     * The plugin instance is in a failed state. This indicates that an
     * unrecoverable error occurred during a previous operation (Create,
     * Delete).
     *
     * Generated from protobuf enum <code>FAILED = 5;</code>
     */
    const FAILED = 5;
    /**
     * The plugin instance is being deleted. Delete is only possible if there is
     * no other operation running on the plugin instance and plugin instance
     * action.
     *
     * Generated from protobuf enum <code>DELETING = 6;</code>
     */
    const DELETING = 6;

    private static $valueToName = [
        self::STATE_UNSPECIFIED => 'STATE_UNSPECIFIED',
        self::CREATING => 'CREATING',
        self::ACTIVE => 'ACTIVE',
        self::APPLYING_CONFIG => 'APPLYING_CONFIG',
        self::ERROR => 'ERROR',
        self::FAILED => 'FAILED',
        self::DELETING => 'DELETING',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


