<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/apihub/v1/plugin_service.proto

namespace Google\Cloud\ApiHub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a plugin instance resource in the API Hub.
 * A PluginInstance is a specific instance of a hub plugin with its own
 * configuration, state, and execution details.
 *
 * Generated from protobuf message <code>google.cloud.apihub.v1.PluginInstance</code>
 */
class PluginInstance extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The unique name of the plugin instance resource.
     * Format:
     * `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The display name for this plugin instance. Max length is 255
     * characters.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Optional. The authentication information for this plugin instance.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AuthConfig auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $auth_config = null;
    /**
     * Optional. The additional information for this plugin instance corresponding
     * to the additional config template of the plugin. This information will be
     * sent to plugin hosting service on each call to plugin hosted service. The
     * key will be the config_variable_template.display_name to uniquely identify
     * the config variable.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.ConfigVariable> additional_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $additional_config;
    /**
     * Output only. The current state of the plugin instance (e.g., enabled,
     * disabled, provisioning).
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.PluginInstance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. Error message describing the failure, if any, during Create,
     * Delete or ApplyConfig operation corresponding to the plugin instance.This
     * field will only be populated if the plugin instance is in the ERROR or
     * FAILED state.
     *
     * Generated from protobuf field <code>string error_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $error_message = '';
    /**
     * Required. The action status for the plugin instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.apihub.v1.PluginInstanceAction actions = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $actions;
    /**
     * Output only. Timestamp indicating when the plugin instance was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Timestamp indicating when the plugin instance was last
     * updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. The source project id of the plugin instance. This will be the id
     * of runtime project in case of gcp based plugins and org id in case of non
     * gcp based plugins. This field will be a required field for Google provided
     * on-ramp plugins.
     *
     * Generated from protobuf field <code>string source_project_id = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $source_project_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The unique name of the plugin instance resource.
     *           Format:
     *           `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
     *     @type string $display_name
     *           Required. The display name for this plugin instance. Max length is 255
     *           characters.
     *     @type \Google\Cloud\ApiHub\V1\AuthConfig $auth_config
     *           Optional. The authentication information for this plugin instance.
     *     @type array|\Google\Protobuf\Internal\MapField $additional_config
     *           Optional. The additional information for this plugin instance corresponding
     *           to the additional config template of the plugin. This information will be
     *           sent to plugin hosting service on each call to plugin hosted service. The
     *           key will be the config_variable_template.display_name to uniquely identify
     *           the config variable.
     *     @type int $state
     *           Output only. The current state of the plugin instance (e.g., enabled,
     *           disabled, provisioning).
     *     @type string $error_message
     *           Output only. Error message describing the failure, if any, during Create,
     *           Delete or ApplyConfig operation corresponding to the plugin instance.This
     *           field will only be populated if the plugin instance is in the ERROR or
     *           FAILED state.
     *     @type array<\Google\Cloud\ApiHub\V1\PluginInstanceAction>|\Google\Protobuf\Internal\RepeatedField $actions
     *           Required. The action status for the plugin instance.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Timestamp indicating when the plugin instance was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Timestamp indicating when the plugin instance was last
     *           updated.
     *     @type string $source_project_id
     *           Optional. The source project id of the plugin instance. This will be the id
     *           of runtime project in case of gcp based plugins and org id in case of non
     *           gcp based plugins. This field will be a required field for Google provided
     *           on-ramp plugins.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Apihub\V1\PluginService::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The unique name of the plugin instance resource.
     * Format:
     * `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The unique name of the plugin instance resource.
     * Format:
     * `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The display name for this plugin instance. Max length is 255
     * characters.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The display name for this plugin instance. Max length is 255
     * characters.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. The authentication information for this plugin instance.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AuthConfig auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\AuthConfig|null
     */
    public function getAuthConfig()
    {
        return $this->auth_config;
    }

    public function hasAuthConfig()
    {
        return isset($this->auth_config);
    }

    public function clearAuthConfig()
    {
        unset($this->auth_config);
    }

    /**
     * Optional. The authentication information for this plugin instance.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AuthConfig auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\AuthConfig $var
     * @return $this
     */
    public function setAuthConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\AuthConfig::class);
        $this->auth_config = $var;

        return $this;
    }

    /**
     * Optional. The additional information for this plugin instance corresponding
     * to the additional config template of the plugin. This information will be
     * sent to plugin hosting service on each call to plugin hosted service. The
     * key will be the config_variable_template.display_name to uniquely identify
     * the config variable.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.ConfigVariable> additional_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAdditionalConfig()
    {
        return $this->additional_config;
    }

    /**
     * Optional. The additional information for this plugin instance corresponding
     * to the additional config template of the plugin. This information will be
     * sent to plugin hosting service on each call to plugin hosted service. The
     * key will be the config_variable_template.display_name to uniquely identify
     * the config variable.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.ConfigVariable> additional_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAdditionalConfig($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ApiHub\V1\ConfigVariable::class);
        $this->additional_config = $arr;

        return $this;
    }

    /**
     * Output only. The current state of the plugin instance (e.g., enabled,
     * disabled, provisioning).
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.PluginInstance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current state of the plugin instance (e.g., enabled,
     * disabled, provisioning).
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.PluginInstance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ApiHub\V1\PluginInstance\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Error message describing the failure, if any, during Create,
     * Delete or ApplyConfig operation corresponding to the plugin instance.This
     * field will only be populated if the plugin instance is in the ERROR or
     * FAILED state.
     *
     * Generated from protobuf field <code>string error_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->error_message;
    }

    /**
     * Output only. Error message describing the failure, if any, during Create,
     * Delete or ApplyConfig operation corresponding to the plugin instance.This
     * field will only be populated if the plugin instance is in the ERROR or
     * FAILED state.
     *
     * Generated from protobuf field <code>string error_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setErrorMessage($var)
    {
        GPBUtil::checkString($var, True);
        $this->error_message = $var;

        return $this;
    }

    /**
     * Required. The action status for the plugin instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.apihub.v1.PluginInstanceAction actions = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getActions()
    {
        return $this->actions;
    }

    /**
     * Required. The action status for the plugin instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.apihub.v1.PluginInstanceAction actions = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\ApiHub\V1\PluginInstanceAction>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setActions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ApiHub\V1\PluginInstanceAction::class);
        $this->actions = $arr;

        return $this;
    }

    /**
     * Output only. Timestamp indicating when the plugin instance was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Timestamp indicating when the plugin instance was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp indicating when the plugin instance was last
     * updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Timestamp indicating when the plugin instance was last
     * updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. The source project id of the plugin instance. This will be the id
     * of runtime project in case of gcp based plugins and org id in case of non
     * gcp based plugins. This field will be a required field for Google provided
     * on-ramp plugins.
     *
     * Generated from protobuf field <code>string source_project_id = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getSourceProjectId()
    {
        return $this->source_project_id;
    }

    /**
     * Optional. The source project id of the plugin instance. This will be the id
     * of runtime project in case of gcp based plugins and org id in case of non
     * gcp based plugins. This field will be a required field for Google provided
     * on-ramp plugins.
     *
     * Generated from protobuf field <code>string source_project_id = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setSourceProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_project_id = $var;

        return $this;
    }

}

