<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/apihub/v1/common_fields.proto

namespace Google\Cloud\ApiHub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an operation contained in an API version in the API Hub.
 * An operation is added/updated/deleted in an API version when a new spec is
 * added or an existing spec is updated/deleted in a version.
 * Currently, an operation will be created only corresponding to OpenAPI spec as
 * parsing is supported for OpenAPI spec.
 * Alternatively operations can be managed via create,update and delete APIs,
 * creation of apiOperation can be possible only for version with no parsed
 * operations and update/delete can be possible only for operations created via
 * create API.
 *
 * Generated from protobuf message <code>google.cloud.apihub.v1.ApiOperation</code>
 */
class ApiOperation extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the operation.
     * Format:
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The name of the spec will be of the format:
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
     * Note:The name of the spec will be empty if the operation is created via
     * [CreateApiOperation][google.cloud.apihub.v1.ApiHub.CreateApiOperation] API.
     *
     * Generated from protobuf field <code>string spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $spec = '';
    /**
     * Optional. Operation details.
     * Note: Even though this field is optional, it is required for
     * [CreateApiOperation][google.cloud.apihub.v1.ApiHub.CreateApiOperation]
     * API and we will fail the request if not provided.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.OperationDetails details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $details = null;
    /**
     * Output only. The time at which the operation was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time at which the operation was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. The list of user defined attributes associated with the API
     * operation resource. The key is the attribute name. It will be of the
     * format: `projects/{project}/locations/{location}/attributes/{attribute}`.
     * The value is the attribute values associated with the resource.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.AttributeValues> attributes = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $attributes;
    /**
     * Output only. The list of sources and metadata from the sources of the API
     * operation.
     *
     * Generated from protobuf field <code>repeated .google.cloud.apihub.v1.SourceMetadata source_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $source_metadata;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the operation.
     *           Format:
     *           `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
     *     @type string $spec
     *           Output only. The name of the spec will be of the format:
     *           `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
     *           Note:The name of the spec will be empty if the operation is created via
     *           [CreateApiOperation][google.cloud.apihub.v1.ApiHub.CreateApiOperation] API.
     *     @type \Google\Cloud\ApiHub\V1\OperationDetails $details
     *           Optional. Operation details.
     *           Note: Even though this field is optional, it is required for
     *           [CreateApiOperation][google.cloud.apihub.v1.ApiHub.CreateApiOperation]
     *           API and we will fail the request if not provided.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time at which the operation was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time at which the operation was last updated.
     *     @type array|\Google\Protobuf\Internal\MapField $attributes
     *           Optional. The list of user defined attributes associated with the API
     *           operation resource. The key is the attribute name. It will be of the
     *           format: `projects/{project}/locations/{location}/attributes/{attribute}`.
     *           The value is the attribute values associated with the resource.
     *     @type array<\Google\Cloud\ApiHub\V1\SourceMetadata>|\Google\Protobuf\Internal\RepeatedField $source_metadata
     *           Output only. The list of sources and metadata from the sources of the API
     *           operation.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Apihub\V1\CommonFields::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the operation.
     * Format:
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the operation.
     * Format:
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The name of the spec will be of the format:
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
     * Note:The name of the spec will be empty if the operation is created via
     * [CreateApiOperation][google.cloud.apihub.v1.ApiHub.CreateApiOperation] API.
     *
     * Generated from protobuf field <code>string spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSpec()
    {
        return $this->spec;
    }

    /**
     * Output only. The name of the spec will be of the format:
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
     * Note:The name of the spec will be empty if the operation is created via
     * [CreateApiOperation][google.cloud.apihub.v1.ApiHub.CreateApiOperation] API.
     *
     * Generated from protobuf field <code>string spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSpec($var)
    {
        GPBUtil::checkString($var, True);
        $this->spec = $var;

        return $this;
    }

    /**
     * Optional. Operation details.
     * Note: Even though this field is optional, it is required for
     * [CreateApiOperation][google.cloud.apihub.v1.ApiHub.CreateApiOperation]
     * API and we will fail the request if not provided.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.OperationDetails details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\OperationDetails|null
     */
    public function getDetails()
    {
        return $this->details;
    }

    public function hasDetails()
    {
        return isset($this->details);
    }

    public function clearDetails()
    {
        unset($this->details);
    }

    /**
     * Optional. Operation details.
     * Note: Even though this field is optional, it is required for
     * [CreateApiOperation][google.cloud.apihub.v1.ApiHub.CreateApiOperation]
     * API and we will fail the request if not provided.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.OperationDetails details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\OperationDetails $var
     * @return $this
     */
    public function setDetails($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\OperationDetails::class);
        $this->details = $var;

        return $this;
    }

    /**
     * Output only. The time at which the operation was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time at which the operation was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time at which the operation was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time at which the operation was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. The list of user defined attributes associated with the API
     * operation resource. The key is the attribute name. It will be of the
     * format: `projects/{project}/locations/{location}/attributes/{attribute}`.
     * The value is the attribute values associated with the resource.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.AttributeValues> attributes = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Optional. The list of user defined attributes associated with the API
     * operation resource. The key is the attribute name. It will be of the
     * format: `projects/{project}/locations/{location}/attributes/{attribute}`.
     * The value is the attribute values associated with the resource.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.AttributeValues> attributes = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ApiHub\V1\AttributeValues::class);
        $this->attributes = $arr;

        return $this;
    }

    /**
     * Output only. The list of sources and metadata from the sources of the API
     * operation.
     *
     * Generated from protobuf field <code>repeated .google.cloud.apihub.v1.SourceMetadata source_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSourceMetadata()
    {
        return $this->source_metadata;
    }

    /**
     * Output only. The list of sources and metadata from the sources of the API
     * operation.
     *
     * Generated from protobuf field <code>repeated .google.cloud.apihub.v1.SourceMetadata source_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\ApiHub\V1\SourceMetadata>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSourceMetadata($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ApiHub\V1\SourceMetadata::class);
        $this->source_metadata = $arr;

        return $this;
    }

}

