<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/alloydb/v1/resources.proto

namespace Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A weekly schedule starts a backup at prescribed start times within a
 * day, for the specified days of the week.
 * The weekly schedule message is flexible and can be used to create many
 * types of schedules. For example, to have a daily backup that starts at
 * 22:00, configure the `start_times` field to have one element "22:00" and
 * the `days_of_week` field to have all seven days of the week.
 *
 * Generated from protobuf message <code>google.cloud.alloydb.v1.AutomatedBackupPolicy.WeeklySchedule</code>
 */
class WeeklySchedule extends \Google\Protobuf\Internal\Message
{
    /**
     * The times during the day to start a backup. The start times are assumed
     * to be in UTC and to be an exact hour (e.g., 04:00:00).
     * If no start times are provided, a single fixed start time is chosen
     * arbitrarily.
     *
     * Generated from protobuf field <code>repeated .google.type.TimeOfDay start_times = 1;</code>
     */
    private $start_times;
    /**
     * The days of the week to perform a backup.
     * If this field is left empty, the default of every day of the week is
     * used.
     *
     * Generated from protobuf field <code>repeated .google.type.DayOfWeek days_of_week = 2;</code>
     */
    private $days_of_week;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<\Google\Type\TimeOfDay>|\Google\Protobuf\Internal\RepeatedField $start_times
     *           The times during the day to start a backup. The start times are assumed
     *           to be in UTC and to be an exact hour (e.g., 04:00:00).
     *           If no start times are provided, a single fixed start time is chosen
     *           arbitrarily.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $days_of_week
     *           The days of the week to perform a backup.
     *           If this field is left empty, the default of every day of the week is
     *           used.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Alloydb\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * The times during the day to start a backup. The start times are assumed
     * to be in UTC and to be an exact hour (e.g., 04:00:00).
     * If no start times are provided, a single fixed start time is chosen
     * arbitrarily.
     *
     * Generated from protobuf field <code>repeated .google.type.TimeOfDay start_times = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStartTimes()
    {
        return $this->start_times;
    }

    /**
     * The times during the day to start a backup. The start times are assumed
     * to be in UTC and to be an exact hour (e.g., 04:00:00).
     * If no start times are provided, a single fixed start time is chosen
     * arbitrarily.
     *
     * Generated from protobuf field <code>repeated .google.type.TimeOfDay start_times = 1;</code>
     * @param array<\Google\Type\TimeOfDay>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStartTimes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Type\TimeOfDay::class);
        $this->start_times = $arr;

        return $this;
    }

    /**
     * The days of the week to perform a backup.
     * If this field is left empty, the default of every day of the week is
     * used.
     *
     * Generated from protobuf field <code>repeated .google.type.DayOfWeek days_of_week = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDaysOfWeek()
    {
        return $this->days_of_week;
    }

    /**
     * The days of the week to perform a backup.
     * If this field is left empty, the default of every day of the week is
     * used.
     *
     * Generated from protobuf field <code>repeated .google.type.DayOfWeek days_of_week = 2;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDaysOfWeek($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Type\DayOfWeek::class);
        $this->days_of_week = $arr;

        return $this;
    }

}


