<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/tensorboard_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\ServerStream;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\BatchCreateTensorboardRunsRequest;
use Google\Cloud\AIPlatform\V1\BatchCreateTensorboardRunsResponse;
use Google\Cloud\AIPlatform\V1\BatchCreateTensorboardTimeSeriesRequest;
use Google\Cloud\AIPlatform\V1\BatchCreateTensorboardTimeSeriesResponse;
use Google\Cloud\AIPlatform\V1\BatchReadTensorboardTimeSeriesDataRequest;
use Google\Cloud\AIPlatform\V1\BatchReadTensorboardTimeSeriesDataResponse;
use Google\Cloud\AIPlatform\V1\CreateTensorboardExperimentRequest;
use Google\Cloud\AIPlatform\V1\CreateTensorboardRequest;
use Google\Cloud\AIPlatform\V1\CreateTensorboardRunRequest;
use Google\Cloud\AIPlatform\V1\CreateTensorboardTimeSeriesRequest;
use Google\Cloud\AIPlatform\V1\DeleteTensorboardExperimentRequest;
use Google\Cloud\AIPlatform\V1\DeleteTensorboardRequest;
use Google\Cloud\AIPlatform\V1\DeleteTensorboardRunRequest;
use Google\Cloud\AIPlatform\V1\DeleteTensorboardTimeSeriesRequest;
use Google\Cloud\AIPlatform\V1\ExportTensorboardTimeSeriesDataRequest;
use Google\Cloud\AIPlatform\V1\GetTensorboardExperimentRequest;
use Google\Cloud\AIPlatform\V1\GetTensorboardRequest;
use Google\Cloud\AIPlatform\V1\GetTensorboardRunRequest;
use Google\Cloud\AIPlatform\V1\GetTensorboardTimeSeriesRequest;
use Google\Cloud\AIPlatform\V1\ListTensorboardExperimentsRequest;
use Google\Cloud\AIPlatform\V1\ListTensorboardRunsRequest;
use Google\Cloud\AIPlatform\V1\ListTensorboardTimeSeriesRequest;
use Google\Cloud\AIPlatform\V1\ListTensorboardsRequest;
use Google\Cloud\AIPlatform\V1\ReadTensorboardBlobDataRequest;
use Google\Cloud\AIPlatform\V1\ReadTensorboardBlobDataResponse;
use Google\Cloud\AIPlatform\V1\ReadTensorboardSizeRequest;
use Google\Cloud\AIPlatform\V1\ReadTensorboardSizeResponse;
use Google\Cloud\AIPlatform\V1\ReadTensorboardTimeSeriesDataRequest;
use Google\Cloud\AIPlatform\V1\ReadTensorboardTimeSeriesDataResponse;
use Google\Cloud\AIPlatform\V1\ReadTensorboardUsageRequest;
use Google\Cloud\AIPlatform\V1\ReadTensorboardUsageResponse;
use Google\Cloud\AIPlatform\V1\Tensorboard;
use Google\Cloud\AIPlatform\V1\TensorboardExperiment;
use Google\Cloud\AIPlatform\V1\TensorboardRun;
use Google\Cloud\AIPlatform\V1\TensorboardTimeSeries;
use Google\Cloud\AIPlatform\V1\UpdateTensorboardExperimentRequest;
use Google\Cloud\AIPlatform\V1\UpdateTensorboardRequest;
use Google\Cloud\AIPlatform\V1\UpdateTensorboardRunRequest;
use Google\Cloud\AIPlatform\V1\UpdateTensorboardTimeSeriesRequest;
use Google\Cloud\AIPlatform\V1\WriteTensorboardExperimentDataRequest;
use Google\Cloud\AIPlatform\V1\WriteTensorboardExperimentDataResponse;
use Google\Cloud\AIPlatform\V1\WriteTensorboardRunDataRequest;
use Google\Cloud\AIPlatform\V1\WriteTensorboardRunDataResponse;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: TensorboardService
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<BatchCreateTensorboardRunsResponse> batchCreateTensorboardRunsAsync(BatchCreateTensorboardRunsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BatchCreateTensorboardTimeSeriesResponse> batchCreateTensorboardTimeSeriesAsync(BatchCreateTensorboardTimeSeriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BatchReadTensorboardTimeSeriesDataResponse> batchReadTensorboardTimeSeriesDataAsync(BatchReadTensorboardTimeSeriesDataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createTensorboardAsync(CreateTensorboardRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TensorboardExperiment> createTensorboardExperimentAsync(CreateTensorboardExperimentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TensorboardRun> createTensorboardRunAsync(CreateTensorboardRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TensorboardTimeSeries> createTensorboardTimeSeriesAsync(CreateTensorboardTimeSeriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteTensorboardAsync(DeleteTensorboardRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteTensorboardExperimentAsync(DeleteTensorboardExperimentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteTensorboardRunAsync(DeleteTensorboardRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteTensorboardTimeSeriesAsync(DeleteTensorboardTimeSeriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> exportTensorboardTimeSeriesDataAsync(ExportTensorboardTimeSeriesDataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Tensorboard> getTensorboardAsync(GetTensorboardRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TensorboardExperiment> getTensorboardExperimentAsync(GetTensorboardExperimentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TensorboardRun> getTensorboardRunAsync(GetTensorboardRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TensorboardTimeSeries> getTensorboardTimeSeriesAsync(GetTensorboardTimeSeriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTensorboardExperimentsAsync(ListTensorboardExperimentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTensorboardRunsAsync(ListTensorboardRunsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTensorboardTimeSeriesAsync(ListTensorboardTimeSeriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTensorboardsAsync(ListTensorboardsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ReadTensorboardSizeResponse> readTensorboardSizeAsync(ReadTensorboardSizeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ReadTensorboardTimeSeriesDataResponse> readTensorboardTimeSeriesDataAsync(ReadTensorboardTimeSeriesDataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ReadTensorboardUsageResponse> readTensorboardUsageAsync(ReadTensorboardUsageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateTensorboardAsync(UpdateTensorboardRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TensorboardExperiment> updateTensorboardExperimentAsync(UpdateTensorboardExperimentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TensorboardRun> updateTensorboardRunAsync(UpdateTensorboardRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TensorboardTimeSeries> updateTensorboardTimeSeriesAsync(UpdateTensorboardTimeSeriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<WriteTensorboardExperimentDataResponse> writeTensorboardExperimentDataAsync(WriteTensorboardExperimentDataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<WriteTensorboardRunDataResponse> writeTensorboardRunDataAsync(WriteTensorboardRunDataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class TensorboardServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.aiplatform.v1.TensorboardService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'aiplatform.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloud-platform.read-only',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/tensorboard_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/tensorboard_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/tensorboard_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/tensorboard_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tensorboard
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tensorboard
     *
     * @return string The formatted tensorboard resource.
     */
    public static function tensorboardName(string $project, string $location, string $tensorboard): string
    {
        return self::getPathTemplate('tensorboard')->render([
            'project' => $project,
            'location' => $location,
            'tensorboard' => $tensorboard,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * tensorboard_experiment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tensorboard
     * @param string $experiment
     *
     * @return string The formatted tensorboard_experiment resource.
     */
    public static function tensorboardExperimentName(
        string $project,
        string $location,
        string $tensorboard,
        string $experiment
    ): string {
        return self::getPathTemplate('tensorboardExperiment')->render([
            'project' => $project,
            'location' => $location,
            'tensorboard' => $tensorboard,
            'experiment' => $experiment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * tensorboard_run resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tensorboard
     * @param string $experiment
     * @param string $run
     *
     * @return string The formatted tensorboard_run resource.
     */
    public static function tensorboardRunName(
        string $project,
        string $location,
        string $tensorboard,
        string $experiment,
        string $run
    ): string {
        return self::getPathTemplate('tensorboardRun')->render([
            'project' => $project,
            'location' => $location,
            'tensorboard' => $tensorboard,
            'experiment' => $experiment,
            'run' => $run,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * tensorboard_time_series resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tensorboard
     * @param string $experiment
     * @param string $run
     * @param string $timeSeries
     *
     * @return string The formatted tensorboard_time_series resource.
     */
    public static function tensorboardTimeSeriesName(
        string $project,
        string $location,
        string $tensorboard,
        string $experiment,
        string $run,
        string $timeSeries
    ): string {
        return self::getPathTemplate('tensorboardTimeSeries')->render([
            'project' => $project,
            'location' => $location,
            'tensorboard' => $tensorboard,
            'experiment' => $experiment,
            'run' => $run,
            'time_series' => $timeSeries,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - location: projects/{project}/locations/{location}
     * - tensorboard: projects/{project}/locations/{location}/tensorboards/{tensorboard}
     * - tensorboardExperiment: projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}
     * - tensorboardRun: projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}
     * - tensorboardTimeSeries: projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\AIPlatform\V1\TensorboardServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new TensorboardServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Batch create TensorboardRuns.
     *
     * The async variant is
     * {@see TensorboardServiceClient::batchCreateTensorboardRunsAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/batch_create_tensorboard_runs.php
     *
     * @param BatchCreateTensorboardRunsRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchCreateTensorboardRunsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchCreateTensorboardRuns(
        BatchCreateTensorboardRunsRequest $request,
        array $callOptions = []
    ): BatchCreateTensorboardRunsResponse {
        return $this->startApiCall('BatchCreateTensorboardRuns', $request, $callOptions)->wait();
    }

    /**
     * Batch create TensorboardTimeSeries that belong to a TensorboardExperiment.
     *
     * The async variant is
     * {@see TensorboardServiceClient::batchCreateTensorboardTimeSeriesAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/batch_create_tensorboard_time_series.php
     *
     * @param BatchCreateTensorboardTimeSeriesRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchCreateTensorboardTimeSeriesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchCreateTensorboardTimeSeries(
        BatchCreateTensorboardTimeSeriesRequest $request,
        array $callOptions = []
    ): BatchCreateTensorboardTimeSeriesResponse {
        return $this->startApiCall('BatchCreateTensorboardTimeSeries', $request, $callOptions)->wait();
    }

    /**
     * Reads multiple TensorboardTimeSeries' data. The data point number limit is
     * 1000 for scalars, 100 for tensors and blob references. If the number of
     * data points stored is less than the limit, all data is returned.
     * Otherwise, the number limit of data points is randomly selected from
     * this time series and returned.
     *
     * The async variant is
     * {@see TensorboardServiceClient::batchReadTensorboardTimeSeriesDataAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/batch_read_tensorboard_time_series_data.php
     *
     * @param BatchReadTensorboardTimeSeriesDataRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchReadTensorboardTimeSeriesDataResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchReadTensorboardTimeSeriesData(
        BatchReadTensorboardTimeSeriesDataRequest $request,
        array $callOptions = []
    ): BatchReadTensorboardTimeSeriesDataResponse {
        return $this->startApiCall('BatchReadTensorboardTimeSeriesData', $request, $callOptions)->wait();
    }

    /**
     * Creates a Tensorboard.
     *
     * The async variant is {@see TensorboardServiceClient::createTensorboardAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/create_tensorboard.php
     *
     * @param CreateTensorboardRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Tensorboard>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTensorboard(CreateTensorboardRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateTensorboard', $request, $callOptions)->wait();
    }

    /**
     * Creates a TensorboardExperiment.
     *
     * The async variant is
     * {@see TensorboardServiceClient::createTensorboardExperimentAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/create_tensorboard_experiment.php
     *
     * @param CreateTensorboardExperimentRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TensorboardExperiment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTensorboardExperiment(
        CreateTensorboardExperimentRequest $request,
        array $callOptions = []
    ): TensorboardExperiment {
        return $this->startApiCall('CreateTensorboardExperiment', $request, $callOptions)->wait();
    }

    /**
     * Creates a TensorboardRun.
     *
     * The async variant is
     * {@see TensorboardServiceClient::createTensorboardRunAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/create_tensorboard_run.php
     *
     * @param CreateTensorboardRunRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TensorboardRun
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTensorboardRun(CreateTensorboardRunRequest $request, array $callOptions = []): TensorboardRun
    {
        return $this->startApiCall('CreateTensorboardRun', $request, $callOptions)->wait();
    }

    /**
     * Creates a TensorboardTimeSeries.
     *
     * The async variant is
     * {@see TensorboardServiceClient::createTensorboardTimeSeriesAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/create_tensorboard_time_series.php
     *
     * @param CreateTensorboardTimeSeriesRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TensorboardTimeSeries
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTensorboardTimeSeries(
        CreateTensorboardTimeSeriesRequest $request,
        array $callOptions = []
    ): TensorboardTimeSeries {
        return $this->startApiCall('CreateTensorboardTimeSeries', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Tensorboard.
     *
     * The async variant is {@see TensorboardServiceClient::deleteTensorboardAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/delete_tensorboard.php
     *
     * @param DeleteTensorboardRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTensorboard(DeleteTensorboardRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteTensorboard', $request, $callOptions)->wait();
    }

    /**
     * Deletes a TensorboardExperiment.
     *
     * The async variant is
     * {@see TensorboardServiceClient::deleteTensorboardExperimentAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/delete_tensorboard_experiment.php
     *
     * @param DeleteTensorboardExperimentRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTensorboardExperiment(
        DeleteTensorboardExperimentRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteTensorboardExperiment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a TensorboardRun.
     *
     * The async variant is
     * {@see TensorboardServiceClient::deleteTensorboardRunAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/delete_tensorboard_run.php
     *
     * @param DeleteTensorboardRunRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTensorboardRun(
        DeleteTensorboardRunRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteTensorboardRun', $request, $callOptions)->wait();
    }

    /**
     * Deletes a TensorboardTimeSeries.
     *
     * The async variant is
     * {@see TensorboardServiceClient::deleteTensorboardTimeSeriesAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/delete_tensorboard_time_series.php
     *
     * @param DeleteTensorboardTimeSeriesRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTensorboardTimeSeries(
        DeleteTensorboardTimeSeriesRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteTensorboardTimeSeries', $request, $callOptions)->wait();
    }

    /**
     * Exports a TensorboardTimeSeries' data. Data is returned in paginated
     * responses.
     *
     * The async variant is
     * {@see TensorboardServiceClient::exportTensorboardTimeSeriesDataAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/export_tensorboard_time_series_data.php
     *
     * @param ExportTensorboardTimeSeriesDataRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportTensorboardTimeSeriesData(
        ExportTensorboardTimeSeriesDataRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ExportTensorboardTimeSeriesData', $request, $callOptions);
    }

    /**
     * Gets a Tensorboard.
     *
     * The async variant is {@see TensorboardServiceClient::getTensorboardAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/get_tensorboard.php
     *
     * @param GetTensorboardRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Tensorboard
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTensorboard(GetTensorboardRequest $request, array $callOptions = []): Tensorboard
    {
        return $this->startApiCall('GetTensorboard', $request, $callOptions)->wait();
    }

    /**
     * Gets a TensorboardExperiment.
     *
     * The async variant is
     * {@see TensorboardServiceClient::getTensorboardExperimentAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/get_tensorboard_experiment.php
     *
     * @param GetTensorboardExperimentRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TensorboardExperiment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTensorboardExperiment(
        GetTensorboardExperimentRequest $request,
        array $callOptions = []
    ): TensorboardExperiment {
        return $this->startApiCall('GetTensorboardExperiment', $request, $callOptions)->wait();
    }

    /**
     * Gets a TensorboardRun.
     *
     * The async variant is {@see TensorboardServiceClient::getTensorboardRunAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/get_tensorboard_run.php
     *
     * @param GetTensorboardRunRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TensorboardRun
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTensorboardRun(GetTensorboardRunRequest $request, array $callOptions = []): TensorboardRun
    {
        return $this->startApiCall('GetTensorboardRun', $request, $callOptions)->wait();
    }

    /**
     * Gets a TensorboardTimeSeries.
     *
     * The async variant is
     * {@see TensorboardServiceClient::getTensorboardTimeSeriesAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/get_tensorboard_time_series.php
     *
     * @param GetTensorboardTimeSeriesRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TensorboardTimeSeries
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTensorboardTimeSeries(
        GetTensorboardTimeSeriesRequest $request,
        array $callOptions = []
    ): TensorboardTimeSeries {
        return $this->startApiCall('GetTensorboardTimeSeries', $request, $callOptions)->wait();
    }

    /**
     * Lists TensorboardExperiments in a Location.
     *
     * The async variant is
     * {@see TensorboardServiceClient::listTensorboardExperimentsAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/list_tensorboard_experiments.php
     *
     * @param ListTensorboardExperimentsRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTensorboardExperiments(
        ListTensorboardExperimentsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListTensorboardExperiments', $request, $callOptions);
    }

    /**
     * Lists TensorboardRuns in a Location.
     *
     * The async variant is {@see TensorboardServiceClient::listTensorboardRunsAsync()}
     * .
     *
     * @example samples/V1/TensorboardServiceClient/list_tensorboard_runs.php
     *
     * @param ListTensorboardRunsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTensorboardRuns(ListTensorboardRunsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTensorboardRuns', $request, $callOptions);
    }

    /**
     * Lists TensorboardTimeSeries in a Location.
     *
     * The async variant is
     * {@see TensorboardServiceClient::listTensorboardTimeSeriesAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/list_tensorboard_time_series.php
     *
     * @param ListTensorboardTimeSeriesRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTensorboardTimeSeries(
        ListTensorboardTimeSeriesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListTensorboardTimeSeries', $request, $callOptions);
    }

    /**
     * Lists Tensorboards in a Location.
     *
     * The async variant is {@see TensorboardServiceClient::listTensorboardsAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/list_tensorboards.php
     *
     * @param ListTensorboardsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTensorboards(ListTensorboardsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTensorboards', $request, $callOptions);
    }

    /**
     * Gets bytes of TensorboardBlobs.
     * This is to allow reading blob data stored in consumer project's Cloud
     * Storage bucket without users having to obtain Cloud Storage access
     * permission.
     *
     * @example samples/V1/TensorboardServiceClient/read_tensorboard_blob_data.php
     *
     * @param ReadTensorboardBlobDataRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type int $timeoutMillis
     *           Timeout to use for this call.
     * }
     *
     * @return ServerStream<ReadTensorboardBlobDataResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function readTensorboardBlobData(
        ReadTensorboardBlobDataRequest $request,
        array $callOptions = []
    ): ServerStream {
        return $this->startApiCall('ReadTensorboardBlobData', $request, $callOptions);
    }

    /**
     * Returns the storage size for a given TensorBoard instance.
     *
     * The async variant is {@see TensorboardServiceClient::readTensorboardSizeAsync()}
     * .
     *
     * @example samples/V1/TensorboardServiceClient/read_tensorboard_size.php
     *
     * @param ReadTensorboardSizeRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReadTensorboardSizeResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function readTensorboardSize(
        ReadTensorboardSizeRequest $request,
        array $callOptions = []
    ): ReadTensorboardSizeResponse {
        return $this->startApiCall('ReadTensorboardSize', $request, $callOptions)->wait();
    }

    /**
     * Reads a TensorboardTimeSeries' data. By default, if the number of data
     * points stored is less than 1000, all data is returned. Otherwise, 1000
     * data points is randomly selected from this time series and returned.
     * This value can be changed by changing max_data_points, which can't be
     * greater than 10k.
     *
     * The async variant is
     * {@see TensorboardServiceClient::readTensorboardTimeSeriesDataAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/read_tensorboard_time_series_data.php
     *
     * @param ReadTensorboardTimeSeriesDataRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReadTensorboardTimeSeriesDataResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function readTensorboardTimeSeriesData(
        ReadTensorboardTimeSeriesDataRequest $request,
        array $callOptions = []
    ): ReadTensorboardTimeSeriesDataResponse {
        return $this->startApiCall('ReadTensorboardTimeSeriesData', $request, $callOptions)->wait();
    }

    /**
     * Returns a list of monthly active users for a given TensorBoard instance.
     *
     * The async variant is
     * {@see TensorboardServiceClient::readTensorboardUsageAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/read_tensorboard_usage.php
     *
     * @param ReadTensorboardUsageRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReadTensorboardUsageResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function readTensorboardUsage(
        ReadTensorboardUsageRequest $request,
        array $callOptions = []
    ): ReadTensorboardUsageResponse {
        return $this->startApiCall('ReadTensorboardUsage', $request, $callOptions)->wait();
    }

    /**
     * Updates a Tensorboard.
     *
     * The async variant is {@see TensorboardServiceClient::updateTensorboardAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/update_tensorboard.php
     *
     * @param UpdateTensorboardRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Tensorboard>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTensorboard(UpdateTensorboardRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateTensorboard', $request, $callOptions)->wait();
    }

    /**
     * Updates a TensorboardExperiment.
     *
     * The async variant is
     * {@see TensorboardServiceClient::updateTensorboardExperimentAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/update_tensorboard_experiment.php
     *
     * @param UpdateTensorboardExperimentRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TensorboardExperiment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTensorboardExperiment(
        UpdateTensorboardExperimentRequest $request,
        array $callOptions = []
    ): TensorboardExperiment {
        return $this->startApiCall('UpdateTensorboardExperiment', $request, $callOptions)->wait();
    }

    /**
     * Updates a TensorboardRun.
     *
     * The async variant is
     * {@see TensorboardServiceClient::updateTensorboardRunAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/update_tensorboard_run.php
     *
     * @param UpdateTensorboardRunRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TensorboardRun
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTensorboardRun(UpdateTensorboardRunRequest $request, array $callOptions = []): TensorboardRun
    {
        return $this->startApiCall('UpdateTensorboardRun', $request, $callOptions)->wait();
    }

    /**
     * Updates a TensorboardTimeSeries.
     *
     * The async variant is
     * {@see TensorboardServiceClient::updateTensorboardTimeSeriesAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/update_tensorboard_time_series.php
     *
     * @param UpdateTensorboardTimeSeriesRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TensorboardTimeSeries
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTensorboardTimeSeries(
        UpdateTensorboardTimeSeriesRequest $request,
        array $callOptions = []
    ): TensorboardTimeSeries {
        return $this->startApiCall('UpdateTensorboardTimeSeries', $request, $callOptions)->wait();
    }

    /**
     * Write time series data points of multiple TensorboardTimeSeries in multiple
     * TensorboardRun's. If any data fail to be ingested, an error is returned.
     *
     * The async variant is
     * {@see TensorboardServiceClient::writeTensorboardExperimentDataAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/write_tensorboard_experiment_data.php
     *
     * @param WriteTensorboardExperimentDataRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return WriteTensorboardExperimentDataResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function writeTensorboardExperimentData(
        WriteTensorboardExperimentDataRequest $request,
        array $callOptions = []
    ): WriteTensorboardExperimentDataResponse {
        return $this->startApiCall('WriteTensorboardExperimentData', $request, $callOptions)->wait();
    }

    /**
     * Write time series data points into multiple TensorboardTimeSeries under
     * a TensorboardRun. If any data fail to be ingested, an error is returned.
     *
     * The async variant is
     * {@see TensorboardServiceClient::writeTensorboardRunDataAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/write_tensorboard_run_data.php
     *
     * @param WriteTensorboardRunDataRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return WriteTensorboardRunDataResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function writeTensorboardRunData(
        WriteTensorboardRunDataRequest $request,
        array $callOptions = []
    ): WriteTensorboardRunDataResponse {
        return $this->startApiCall('WriteTensorboardRunData', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see TensorboardServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see TensorboardServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see TensorboardServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see TensorboardServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/TensorboardServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see TensorboardServiceClient::testIamPermissionsAsync()}
     * .
     *
     * @example samples/V1/TensorboardServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
