<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/monitoring/v3/alert.proto

namespace Google\Cloud\Monitoring\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A condition type that compares a collection of time series
 * against a threshold.
 *
 * Generated from protobuf message <code>google.monitoring.v3.AlertPolicy.Condition.MetricThreshold</code>
 */
class AlertPolicy_Condition_MetricThreshold extends \Google\Protobuf\Internal\Message
{
    /**
     * A [filter](/monitoring/api/v3/filters) that
     * identifies which time series should be compared with the threshold.
     * The filter is similar to the one that is specified in the
     * [`MetricService.ListTimeSeries`
     * request](/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that
     * call is useful to verify the time series that will be retrieved /
     * processed) and must specify the metric type and optionally may contain
     * restrictions on resource type, resource labels, and metric labels.
     * This field may not exceed 2048 Unicode characters in length.
     *
     * Generated from protobuf field <code>string filter = 2;</code>
     */
    private $filter = '';
    /**
     * Specifies the alignment of data points in individual time series as
     * well as how to combine the retrieved time series together (such as
     * when aggregating multiple streams on each resource to a single
     * stream for each resource or when aggregating streams across all
     * members of a group of resrouces). Multiple aggregations
     * are applied in the order specified.
     * This field is similar to the one in the
     * [`MetricService.ListTimeSeries` request](/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
     * It is advisable to use the `ListTimeSeries` method when debugging this field.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
     */
    private $aggregations;
    /**
     * A [filter](/monitoring/api/v3/filters) that identifies a time
     * series that should be used as the denominator of a ratio that will be
     * compared with the threshold. If a `denominator_filter` is specified,
     * the time series specified by the `filter` field will be used as the
     * numerator.
     * The filter is similar to the one that is specified in the
     * [`MetricService.ListTimeSeries`
     * request](/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that
     * call is useful to verify the time series that will be retrieved /
     * processed) and must specify the metric type and optionally may contain
     * restrictions on resource type, resource labels, and metric labels.
     * This field may not exceed 2048 Unicode characters in length.
     *
     * Generated from protobuf field <code>string denominator_filter = 9;</code>
     */
    private $denominator_filter = '';
    /**
     * Specifies the alignment of data points in individual time series
     * selected by `denominatorFilter` as
     * well as how to combine the retrieved time series together (such as
     * when aggregating multiple streams on each resource to a single
     * stream for each resource or when aggregating streams across all
     * members of a group of resources).
     * When computing ratios, the `aggregations` and
     * `denominator_aggregations` fields must use the same alignment period
     * and produce time series that have the same periodicity and labels.
     * This field is similar to the one in the
     * [`MetricService.ListTimeSeries`
     * request](/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list). It
     * is advisable to use the `ListTimeSeries` method when debugging this
     * field.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
     */
    private $denominator_aggregations;
    /**
     * The comparison to apply between the time series (indicated by `filter`
     * and `aggregation`) and the threshold (indicated by `threshold_value`).
     * The comparison is applied on each time series, with the time series
     * on the left-hand side and the threshold on the right-hand side.
     * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
     */
    private $comparison = 0;
    /**
     * A value against which to compare the time series.
     *
     * Generated from protobuf field <code>double threshold_value = 5;</code>
     */
    private $threshold_value = 0.0;
    /**
     * The amount of time that a time series must violate the
     * threshold to be considered failing. Currently, only values
     * that are a multiple of a minute--e.g.  60, 120, or 300
     * seconds--are supported. If an invalid value is given, an
     * error will be returned. The `Duration.nanos` field is
     * ignored. When choosing a duration, it is useful to keep in mind the
     * frequency of the underlying time series data (which may also be
     * affected by any alignments specified in the `aggregation` field);
     * a good duration is long enough so that a single outlier does not
     * generate spurious alerts, but short enough that unhealthy states
     * are detected and alerted on quickly.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration duration = 6;</code>
     */
    private $duration = null;
    /**
     * The number/percent of time series for which the comparison must hold
     * in order for the condition to trigger. If unspecified, then the
     * condition will trigger if the comparison is true for any of the
     * time series that have been identified by `filter` and `aggregations`,
     * or by the ratio, if `denominator_filter` and `denominator_aggregations`
     * are specified.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
     */
    private $trigger = null;

    public function __construct() {
        \GPBMetadata\Google\Monitoring\V3\Alert::initOnce();
        parent::__construct();
    }

    /**
     * A [filter](/monitoring/api/v3/filters) that
     * identifies which time series should be compared with the threshold.
     * The filter is similar to the one that is specified in the
     * [`MetricService.ListTimeSeries`
     * request](/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that
     * call is useful to verify the time series that will be retrieved /
     * processed) and must specify the metric type and optionally may contain
     * restrictions on resource type, resource labels, and metric labels.
     * This field may not exceed 2048 Unicode characters in length.
     *
     * Generated from protobuf field <code>string filter = 2;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * A [filter](/monitoring/api/v3/filters) that
     * identifies which time series should be compared with the threshold.
     * The filter is similar to the one that is specified in the
     * [`MetricService.ListTimeSeries`
     * request](/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that
     * call is useful to verify the time series that will be retrieved /
     * processed) and must specify the metric type and optionally may contain
     * restrictions on resource type, resource labels, and metric labels.
     * This field may not exceed 2048 Unicode characters in length.
     *
     * Generated from protobuf field <code>string filter = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * Specifies the alignment of data points in individual time series as
     * well as how to combine the retrieved time series together (such as
     * when aggregating multiple streams on each resource to a single
     * stream for each resource or when aggregating streams across all
     * members of a group of resrouces). Multiple aggregations
     * are applied in the order specified.
     * This field is similar to the one in the
     * [`MetricService.ListTimeSeries` request](/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
     * It is advisable to use the `ListTimeSeries` method when debugging this field.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAggregations()
    {
        return $this->aggregations;
    }

    /**
     * Specifies the alignment of data points in individual time series as
     * well as how to combine the retrieved time series together (such as
     * when aggregating multiple streams on each resource to a single
     * stream for each resource or when aggregating streams across all
     * members of a group of resrouces). Multiple aggregations
     * are applied in the order specified.
     * This field is similar to the one in the
     * [`MetricService.ListTimeSeries` request](/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
     * It is advisable to use the `ListTimeSeries` method when debugging this field.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
     * @param \Google\Cloud\Monitoring\V3\Aggregation[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAggregations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Monitoring\V3\Aggregation::class);
        $this->aggregations = $arr;

        return $this;
    }

    /**
     * A [filter](/monitoring/api/v3/filters) that identifies a time
     * series that should be used as the denominator of a ratio that will be
     * compared with the threshold. If a `denominator_filter` is specified,
     * the time series specified by the `filter` field will be used as the
     * numerator.
     * The filter is similar to the one that is specified in the
     * [`MetricService.ListTimeSeries`
     * request](/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that
     * call is useful to verify the time series that will be retrieved /
     * processed) and must specify the metric type and optionally may contain
     * restrictions on resource type, resource labels, and metric labels.
     * This field may not exceed 2048 Unicode characters in length.
     *
     * Generated from protobuf field <code>string denominator_filter = 9;</code>
     * @return string
     */
    public function getDenominatorFilter()
    {
        return $this->denominator_filter;
    }

    /**
     * A [filter](/monitoring/api/v3/filters) that identifies a time
     * series that should be used as the denominator of a ratio that will be
     * compared with the threshold. If a `denominator_filter` is specified,
     * the time series specified by the `filter` field will be used as the
     * numerator.
     * The filter is similar to the one that is specified in the
     * [`MetricService.ListTimeSeries`
     * request](/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that
     * call is useful to verify the time series that will be retrieved /
     * processed) and must specify the metric type and optionally may contain
     * restrictions on resource type, resource labels, and metric labels.
     * This field may not exceed 2048 Unicode characters in length.
     *
     * Generated from protobuf field <code>string denominator_filter = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setDenominatorFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->denominator_filter = $var;

        return $this;
    }

    /**
     * Specifies the alignment of data points in individual time series
     * selected by `denominatorFilter` as
     * well as how to combine the retrieved time series together (such as
     * when aggregating multiple streams on each resource to a single
     * stream for each resource or when aggregating streams across all
     * members of a group of resources).
     * When computing ratios, the `aggregations` and
     * `denominator_aggregations` fields must use the same alignment period
     * and produce time series that have the same periodicity and labels.
     * This field is similar to the one in the
     * [`MetricService.ListTimeSeries`
     * request](/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list). It
     * is advisable to use the `ListTimeSeries` method when debugging this
     * field.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDenominatorAggregations()
    {
        return $this->denominator_aggregations;
    }

    /**
     * Specifies the alignment of data points in individual time series
     * selected by `denominatorFilter` as
     * well as how to combine the retrieved time series together (such as
     * when aggregating multiple streams on each resource to a single
     * stream for each resource or when aggregating streams across all
     * members of a group of resources).
     * When computing ratios, the `aggregations` and
     * `denominator_aggregations` fields must use the same alignment period
     * and produce time series that have the same periodicity and labels.
     * This field is similar to the one in the
     * [`MetricService.ListTimeSeries`
     * request](/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list). It
     * is advisable to use the `ListTimeSeries` method when debugging this
     * field.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
     * @param \Google\Cloud\Monitoring\V3\Aggregation[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDenominatorAggregations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Monitoring\V3\Aggregation::class);
        $this->denominator_aggregations = $arr;

        return $this;
    }

    /**
     * The comparison to apply between the time series (indicated by `filter`
     * and `aggregation`) and the threshold (indicated by `threshold_value`).
     * The comparison is applied on each time series, with the time series
     * on the left-hand side and the threshold on the right-hand side.
     * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
     * @return int
     */
    public function getComparison()
    {
        return $this->comparison;
    }

    /**
     * The comparison to apply between the time series (indicated by `filter`
     * and `aggregation`) and the threshold (indicated by `threshold_value`).
     * The comparison is applied on each time series, with the time series
     * on the left-hand side and the threshold on the right-hand side.
     * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setComparison($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Monitoring\V3\ComparisonType::class);
        $this->comparison = $var;

        return $this;
    }

    /**
     * A value against which to compare the time series.
     *
     * Generated from protobuf field <code>double threshold_value = 5;</code>
     * @return float
     */
    public function getThresholdValue()
    {
        return $this->threshold_value;
    }

    /**
     * A value against which to compare the time series.
     *
     * Generated from protobuf field <code>double threshold_value = 5;</code>
     * @param float $var
     * @return $this
     */
    public function setThresholdValue($var)
    {
        GPBUtil::checkDouble($var);
        $this->threshold_value = $var;

        return $this;
    }

    /**
     * The amount of time that a time series must violate the
     * threshold to be considered failing. Currently, only values
     * that are a multiple of a minute--e.g.  60, 120, or 300
     * seconds--are supported. If an invalid value is given, an
     * error will be returned. The `Duration.nanos` field is
     * ignored. When choosing a duration, it is useful to keep in mind the
     * frequency of the underlying time series data (which may also be
     * affected by any alignments specified in the `aggregation` field);
     * a good duration is long enough so that a single outlier does not
     * generate spurious alerts, but short enough that unhealthy states
     * are detected and alerted on quickly.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration duration = 6;</code>
     * @return \Google\Protobuf\Duration
     */
    public function getDuration()
    {
        return $this->duration;
    }

    /**
     * The amount of time that a time series must violate the
     * threshold to be considered failing. Currently, only values
     * that are a multiple of a minute--e.g.  60, 120, or 300
     * seconds--are supported. If an invalid value is given, an
     * error will be returned. The `Duration.nanos` field is
     * ignored. When choosing a duration, it is useful to keep in mind the
     * frequency of the underlying time series data (which may also be
     * affected by any alignments specified in the `aggregation` field);
     * a good duration is long enough so that a single outlier does not
     * generate spurious alerts, but short enough that unhealthy states
     * are detected and alerted on quickly.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration duration = 6;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->duration = $var;

        return $this;
    }

    /**
     * The number/percent of time series for which the comparison must hold
     * in order for the condition to trigger. If unspecified, then the
     * condition will trigger if the comparison is true for any of the
     * time series that have been identified by `filter` and `aggregations`,
     * or by the ratio, if `denominator_filter` and `denominator_aggregations`
     * are specified.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
     * @return \Google\Cloud\Monitoring\V3\AlertPolicy_Condition_Trigger
     */
    public function getTrigger()
    {
        return $this->trigger;
    }

    /**
     * The number/percent of time series for which the comparison must hold
     * in order for the condition to trigger. If unspecified, then the
     * condition will trigger if the comparison is true for any of the
     * time series that have been identified by `filter` and `aggregations`,
     * or by the ratio, if `denominator_filter` and `denominator_aggregations`
     * are specified.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
     * @param \Google\Cloud\Monitoring\V3\AlertPolicy_Condition_Trigger $var
     * @return $this
     */
    public function setTrigger($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\AlertPolicy_Condition_Trigger::class);
        $this->trigger = $var;

        return $this;
    }

}

