<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycenter/v1/finding.proto

namespace Google\Cloud\SecurityCenter\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Security Command Center finding.
 * A finding is a record of assessment data like security, risk, health, or
 * privacy, that is ingested into Security Command Center for presentation,
 * notification, analysis, policy testing, and enforcement. For example, a
 * cross-site scripting (XSS) vulnerability in an App Engine application is a
 * finding.
 *
 * Generated from protobuf message <code>google.cloud.securitycenter.v1.Finding</code>
 */
class Finding extends \Google\Protobuf\Internal\Message
{
    /**
     * The [relative resource
     * name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * of the finding. Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
     * "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     *
     * Generated from protobuf field <code>string parent = 2;</code>
     */
    protected $parent = '';
    /**
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     *
     * Generated from protobuf field <code>string resource_name = 3;</code>
     */
    protected $resource_name = '';
    /**
     * The state of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     */
    protected $state = 0;
    /**
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     *
     * Generated from protobuf field <code>string category = 5;</code>
     */
    protected $category = '';
    /**
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     *
     * Generated from protobuf field <code>string external_uri = 6;</code>
     */
    protected $external_uri = '';
    /**
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> source_properties = 7;</code>
     */
    private $source_properties;
    /**
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $security_marks = null;
    /**
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    protected $event_time = null;
    /**
     * The time at which the finding was created in Security Command Center.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    protected $create_time = null;
    /**
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     */
    protected $severity = 0;
    /**
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     *
     * Generated from protobuf field <code>string canonical_name = 14;</code>
     */
    protected $canonical_name = '';
    /**
     * Indicates the mute state of a finding (either muted, unmuted
     * or undefined). Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
     */
    protected $mute = 0;
    /**
     * The class of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
     */
    protected $finding_class = 0;
    /**
     * Represents what's commonly known as an *indicator of compromise* (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion. For more information, see [Indicator of
     * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     */
    protected $indicator = null;
    /**
     * Represents vulnerability-specific fields like CVE and CVSS scores.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     */
    protected $vulnerability = null;
    /**
     * Output only. The most recent time this finding was muted or unmuted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $mute_update_time = null;
    /**
     * Output only. Third party SIEM/SOAR fields within SCC, contains external
     * system information and external system finding fields.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycenter.v1.ExternalSystem> external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $external_systems;
    /**
     * MITRE ATT&CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     */
    protected $mitre_attack = null;
    /**
     * Access details associated with the finding, such as more information on the
     * caller, which method was accessed, and from where.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     */
    protected $access = null;
    /**
     * Contains information about the IP connection associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    private $connections;
    /**
     * Records additional information about the mute operation, for example, the
     * [mute configuration](/security-command-center/docs/how-to-mute-findings)
     * that muted the finding and the user who muted the finding.
     *
     * Generated from protobuf field <code>string mute_initiator = 28;</code>
     */
    protected $mute_initiator = '';
    /**
     * Represents operating system processes associated with the Finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    private $processes;
    /**
     * Output only. Map containing the points of contact for the given finding.
     * The key represents the type of contact, while the value contains a list of
     * all the contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycenter.v1.ContactDetails> contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $contacts;
    /**
     * Contains compliance information for security standards associated to the
     * finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    private $compliances;
    /**
     * Output only. The human readable display name of the finding source such as
     * "Event Threat Detection" or "Security Health Analytics".
     *
     * Generated from protobuf field <code>string parent_display_name = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $parent_display_name = '';
    /**
     * Contains more details about the finding.
     *
     * Generated from protobuf field <code>string description = 37;</code>
     */
    protected $description = '';
    /**
     * Represents exfiltrations associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     */
    protected $exfiltration = null;
    /**
     * Represents IAM bindings associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    private $iam_bindings;
    /**
     * Steps to address the finding.
     *
     * Generated from protobuf field <code>string next_steps = 40;</code>
     */
    protected $next_steps = '';
    /**
     * Unique identifier of the module which generated the finding.
     * Example:
     * folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
     *
     * Generated from protobuf field <code>string module_name = 41;</code>
     */
    protected $module_name = '';
    /**
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    private $containers;
    /**
     * Kubernetes resources associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     */
    protected $kubernetes = null;
    /**
     * Database associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
     */
    protected $database = null;
    /**
     * The results of an attack path simulation relevant to this finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.AttackExposure attack_exposure = 45;</code>
     */
    protected $attack_exposure = null;
    /**
     * File associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    private $files;
    /**
     * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     * associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
     */
    protected $cloud_dlp_inspection = null;
    /**
     * Cloud DLP data profile that is associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
     */
    protected $cloud_dlp_data_profile = null;
    /**
     * Signature of the kernel rootkit.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
     */
    protected $kernel_rootkit = null;
    /**
     * Contains information about the org policies associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.OrgPolicy org_policies = 51;</code>
     */
    private $org_policies;
    /**
     * Represents an application associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Application application = 53;</code>
     */
    protected $application = null;
    /**
     * Fields related to Backup and DR findings.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.BackupDisasterRecovery backup_disaster_recovery = 55;</code>
     */
    protected $backup_disaster_recovery = null;
    /**
     * The security posture associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityPosture security_posture = 56;</code>
     */
    protected $security_posture = null;
    /**
     * Log entries that are relevant to the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.LogEntry log_entries = 57;</code>
     */
    private $log_entries;
    /**
     * The load balancers associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.LoadBalancer load_balancers = 58;</code>
     */
    private $load_balancers;
    /**
     * Fields related to Cloud Armor findings.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.CloudArmor cloud_armor = 59;</code>
     */
    protected $cloud_armor = null;
    /**
     * Notebook associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Notebook notebook = 63;</code>
     */
    protected $notebook = null;
    /**
     * Contains details about a group of security issues that, when the issues
     * occur together, represent a greater risk than when the issues occur
     * independently. A group of such issues is referred to as a toxic
     * combination.
     * This field cannot be updated. Its value is ignored in all update requests.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.ToxicCombination toxic_combination = 64;</code>
     */
    protected $toxic_combination = null;
    /**
     * Contains details about groups of which this finding is a member. A group is
     * a collection of findings that are related in some way.
     * This field cannot be updated. Its value is ignored in all update requests.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.GroupMembership group_memberships = 65;</code>
     */
    private $group_memberships;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The [relative resource
     *           name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     *           of the finding. Example:
     *           "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     *           "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
     *           "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
     *     @type string $parent
     *           The relative resource name of the source the finding belongs to. See:
     *           https://cloud.google.com/apis/design/resource_names#relative_resource_name
     *           This field is immutable after creation time.
     *           For example:
     *           "organizations/{organization_id}/sources/{source_id}"
     *     @type string $resource_name
     *           For findings on Google Cloud resources, the full resource
     *           name of the Google Cloud resource this finding is for. See:
     *           https://cloud.google.com/apis/design/resource_names#full_resource_name
     *           When the finding is for a non-Google Cloud resource, the resourceName can
     *           be a customer or partner defined string. This field is immutable after
     *           creation time.
     *     @type int $state
     *           The state of the finding.
     *     @type string $category
     *           The additional taxonomy group within findings from a given source.
     *           This field is immutable after creation time.
     *           Example: "XSS_FLASH_INJECTION"
     *     @type string $external_uri
     *           The URI that, if available, points to a web page outside of Security
     *           Command Center where additional information about the finding can be found.
     *           This field is guaranteed to be either empty or a well formed URL.
     *     @type array|\Google\Protobuf\Internal\MapField $source_properties
     *           Source specific properties. These properties are managed by the source
     *           that writes the finding. The key names in the source_properties map must be
     *           between 1 and 255 characters, and must start with a letter and contain
     *           alphanumeric characters or underscores only.
     *     @type \Google\Cloud\SecurityCenter\V1\SecurityMarks $security_marks
     *           Output only. User specified security marks. These marks are entirely
     *           managed by the user and come from the SecurityMarks resource that belongs
     *           to the finding.
     *     @type \Google\Protobuf\Timestamp $event_time
     *           The time the finding was first detected. If an existing finding is updated,
     *           then this is the time the update occurred.
     *           For example, if the finding represents an open firewall, this property
     *           captures the time the detector believes the firewall became open. The
     *           accuracy is determined by the detector. If the finding is later resolved,
     *           then this time reflects when the finding was resolved. This must not
     *           be set to a value greater than the current timestamp.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           The time at which the finding was created in Security Command Center.
     *     @type int $severity
     *           The severity of the finding. This field is managed by the source that
     *           writes the finding.
     *     @type string $canonical_name
     *           The canonical name of the finding. It's either
     *           "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     *           "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     *           "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     *           depending on the closest CRM ancestor of the resource associated with the
     *           finding.
     *     @type int $mute
     *           Indicates the mute state of a finding (either muted, unmuted
     *           or undefined). Unlike other attributes of a finding, a finding provider
     *           shouldn't set the value of mute.
     *     @type int $finding_class
     *           The class of the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\Indicator $indicator
     *           Represents what's commonly known as an *indicator of compromise* (IoC) in
     *           computer forensics. This is an artifact observed on a network or in an
     *           operating system that, with high confidence, indicates a computer
     *           intrusion. For more information, see [Indicator of
     *           compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     *     @type \Google\Cloud\SecurityCenter\V1\Vulnerability $vulnerability
     *           Represents vulnerability-specific fields like CVE and CVSS scores.
     *           CVE stands for Common Vulnerabilities and Exposures
     *           (https://cve.mitre.org/about/)
     *     @type \Google\Protobuf\Timestamp $mute_update_time
     *           Output only. The most recent time this finding was muted or unmuted.
     *     @type array|\Google\Protobuf\Internal\MapField $external_systems
     *           Output only. Third party SIEM/SOAR fields within SCC, contains external
     *           system information and external system finding fields.
     *     @type \Google\Cloud\SecurityCenter\V1\MitreAttack $mitre_attack
     *           MITRE ATT&CK tactics and techniques related to this finding.
     *           See: https://attack.mitre.org
     *     @type \Google\Cloud\SecurityCenter\V1\Access $access
     *           Access details associated with the finding, such as more information on the
     *           caller, which method was accessed, and from where.
     *     @type array<\Google\Cloud\SecurityCenter\V1\Connection>|\Google\Protobuf\Internal\RepeatedField $connections
     *           Contains information about the IP connection associated with the finding.
     *     @type string $mute_initiator
     *           Records additional information about the mute operation, for example, the
     *           [mute configuration](/security-command-center/docs/how-to-mute-findings)
     *           that muted the finding and the user who muted the finding.
     *     @type array<\Google\Cloud\SecurityCenter\V1\Process>|\Google\Protobuf\Internal\RepeatedField $processes
     *           Represents operating system processes associated with the Finding.
     *     @type array|\Google\Protobuf\Internal\MapField $contacts
     *           Output only. Map containing the points of contact for the given finding.
     *           The key represents the type of contact, while the value contains a list of
     *           all the contacts that pertain. Please refer to:
     *           https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *               {
     *                 "security": {
     *                   "contacts": [
     *                     {
     *                       "email": "person1&#64;company.com"
     *                     },
     *                     {
     *                       "email": "person2&#64;company.com"
     *                     }
     *                   ]
     *                 }
     *               }
     *     @type array<\Google\Cloud\SecurityCenter\V1\Compliance>|\Google\Protobuf\Internal\RepeatedField $compliances
     *           Contains compliance information for security standards associated to the
     *           finding.
     *     @type string $parent_display_name
     *           Output only. The human readable display name of the finding source such as
     *           "Event Threat Detection" or "Security Health Analytics".
     *     @type string $description
     *           Contains more details about the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\Exfiltration $exfiltration
     *           Represents exfiltrations associated with the finding.
     *     @type array<\Google\Cloud\SecurityCenter\V1\IamBinding>|\Google\Protobuf\Internal\RepeatedField $iam_bindings
     *           Represents IAM bindings associated with the finding.
     *     @type string $next_steps
     *           Steps to address the finding.
     *     @type string $module_name
     *           Unique identifier of the module which generated the finding.
     *           Example:
     *           folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
     *     @type array<\Google\Cloud\SecurityCenter\V1\Container>|\Google\Protobuf\Internal\RepeatedField $containers
     *           Containers associated with the finding. This field provides information for
     *           both Kubernetes and non-Kubernetes containers.
     *     @type \Google\Cloud\SecurityCenter\V1\Kubernetes $kubernetes
     *           Kubernetes resources associated with the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\Database $database
     *           Database associated with the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\AttackExposure $attack_exposure
     *           The results of an attack path simulation relevant to this finding.
     *     @type array<\Google\Cloud\SecurityCenter\V1\File>|\Google\Protobuf\Internal\RepeatedField $files
     *           File associated with the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\CloudDlpInspection $cloud_dlp_inspection
     *           Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     *           associated with the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\CloudDlpDataProfile $cloud_dlp_data_profile
     *           Cloud DLP data profile that is associated with the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\KernelRootkit $kernel_rootkit
     *           Signature of the kernel rootkit.
     *     @type array<\Google\Cloud\SecurityCenter\V1\OrgPolicy>|\Google\Protobuf\Internal\RepeatedField $org_policies
     *           Contains information about the org policies associated with the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\Application $application
     *           Represents an application associated with the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\BackupDisasterRecovery $backup_disaster_recovery
     *           Fields related to Backup and DR findings.
     *     @type \Google\Cloud\SecurityCenter\V1\SecurityPosture $security_posture
     *           The security posture associated with the finding.
     *     @type array<\Google\Cloud\SecurityCenter\V1\LogEntry>|\Google\Protobuf\Internal\RepeatedField $log_entries
     *           Log entries that are relevant to the finding.
     *     @type array<\Google\Cloud\SecurityCenter\V1\LoadBalancer>|\Google\Protobuf\Internal\RepeatedField $load_balancers
     *           The load balancers associated with the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\CloudArmor $cloud_armor
     *           Fields related to Cloud Armor findings.
     *     @type \Google\Cloud\SecurityCenter\V1\Notebook $notebook
     *           Notebook associated with the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\ToxicCombination $toxic_combination
     *           Contains details about a group of security issues that, when the issues
     *           occur together, represent a greater risk than when the issues occur
     *           independently. A group of such issues is referred to as a toxic
     *           combination.
     *           This field cannot be updated. Its value is ignored in all update requests.
     *     @type array<\Google\Cloud\SecurityCenter\V1\GroupMembership>|\Google\Protobuf\Internal\RepeatedField $group_memberships
     *           Contains details about groups of which this finding is a member. A group is
     *           a collection of findings that are related in some way.
     *           This field cannot be updated. Its value is ignored in all update requests.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycenter\V1\Finding::initOnce();
        parent::__construct($data);
    }

    /**
     * The [relative resource
     * name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * of the finding. Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
     * "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The [relative resource
     * name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * of the finding. Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
     * "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     *
     * Generated from protobuf field <code>string parent = 2;</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     *
     * Generated from protobuf field <code>string parent = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     *
     * Generated from protobuf field <code>string resource_name = 3;</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     *
     * Generated from protobuf field <code>string resource_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

    /**
     * The state of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * The state of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V1\Finding\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     *
     * Generated from protobuf field <code>string category = 5;</code>
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     *
     * Generated from protobuf field <code>string category = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setCategory($var)
    {
        GPBUtil::checkString($var, True);
        $this->category = $var;

        return $this;
    }

    /**
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     *
     * Generated from protobuf field <code>string external_uri = 6;</code>
     * @return string
     */
    public function getExternalUri()
    {
        return $this->external_uri;
    }

    /**
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     *
     * Generated from protobuf field <code>string external_uri = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setExternalUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->external_uri = $var;

        return $this;
    }

    /**
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> source_properties = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getSourceProperties()
    {
        return $this->source_properties;
    }

    /**
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> source_properties = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setSourceProperties($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\Value::class);
        $this->source_properties = $arr;

        return $this;
    }

    /**
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\SecurityCenter\V1\SecurityMarks|null
     */
    public function getSecurityMarks()
    {
        return $this->security_marks;
    }

    public function hasSecurityMarks()
    {
        return isset($this->security_marks);
    }

    public function clearSecurityMarks()
    {
        unset($this->security_marks);
    }

    /**
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\SecurityCenter\V1\SecurityMarks $var
     * @return $this
     */
    public function setSecurityMarks($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\SecurityMarks::class);
        $this->security_marks = $var;

        return $this;
    }

    /**
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 9;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEventTime()
    {
        return $this->event_time;
    }

    public function hasEventTime()
    {
        return isset($this->event_time);
    }

    public function clearEventTime()
    {
        unset($this->event_time);
    }

    /**
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 9;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEventTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->event_time = $var;

        return $this;
    }

    /**
     * The time at which the finding was created in Security Command Center.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * The time at which the finding was created in Security Command Center.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     * @return int
     */
    public function getSeverity()
    {
        return $this->severity;
    }

    /**
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setSeverity($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V1\Finding\Severity::class);
        $this->severity = $var;

        return $this;
    }

    /**
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     *
     * Generated from protobuf field <code>string canonical_name = 14;</code>
     * @return string
     */
    public function getCanonicalName()
    {
        return $this->canonical_name;
    }

    /**
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     *
     * Generated from protobuf field <code>string canonical_name = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setCanonicalName($var)
    {
        GPBUtil::checkString($var, True);
        $this->canonical_name = $var;

        return $this;
    }

    /**
     * Indicates the mute state of a finding (either muted, unmuted
     * or undefined). Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
     * @return int
     */
    public function getMute()
    {
        return $this->mute;
    }

    /**
     * Indicates the mute state of a finding (either muted, unmuted
     * or undefined). Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
     * @param int $var
     * @return $this
     */
    public function setMute($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V1\Finding\Mute::class);
        $this->mute = $var;

        return $this;
    }

    /**
     * The class of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
     * @return int
     */
    public function getFindingClass()
    {
        return $this->finding_class;
    }

    /**
     * The class of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
     * @param int $var
     * @return $this
     */
    public function setFindingClass($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V1\Finding\FindingClass::class);
        $this->finding_class = $var;

        return $this;
    }

    /**
     * Represents what's commonly known as an *indicator of compromise* (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion. For more information, see [Indicator of
     * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Indicator|null
     */
    public function getIndicator()
    {
        return $this->indicator;
    }

    public function hasIndicator()
    {
        return isset($this->indicator);
    }

    public function clearIndicator()
    {
        unset($this->indicator);
    }

    /**
     * Represents what's commonly known as an *indicator of compromise* (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion. For more information, see [Indicator of
     * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Indicator $var
     * @return $this
     */
    public function setIndicator($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Indicator::class);
        $this->indicator = $var;

        return $this;
    }

    /**
     * Represents vulnerability-specific fields like CVE and CVSS scores.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Vulnerability|null
     */
    public function getVulnerability()
    {
        return $this->vulnerability;
    }

    public function hasVulnerability()
    {
        return isset($this->vulnerability);
    }

    public function clearVulnerability()
    {
        unset($this->vulnerability);
    }

    /**
     * Represents vulnerability-specific fields like CVE and CVSS scores.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Vulnerability $var
     * @return $this
     */
    public function setVulnerability($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Vulnerability::class);
        $this->vulnerability = $var;

        return $this;
    }

    /**
     * Output only. The most recent time this finding was muted or unmuted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getMuteUpdateTime()
    {
        return $this->mute_update_time;
    }

    public function hasMuteUpdateTime()
    {
        return isset($this->mute_update_time);
    }

    public function clearMuteUpdateTime()
    {
        unset($this->mute_update_time);
    }

    /**
     * Output only. The most recent time this finding was muted or unmuted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setMuteUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->mute_update_time = $var;

        return $this;
    }

    /**
     * Output only. Third party SIEM/SOAR fields within SCC, contains external
     * system information and external system finding fields.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycenter.v1.ExternalSystem> external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getExternalSystems()
    {
        return $this->external_systems;
    }

    /**
     * Output only. Third party SIEM/SOAR fields within SCC, contains external
     * system information and external system finding fields.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycenter.v1.ExternalSystem> external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setExternalSystems($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\ExternalSystem::class);
        $this->external_systems = $arr;

        return $this;
    }

    /**
     * MITRE ATT&CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     * @return \Google\Cloud\SecurityCenter\V1\MitreAttack|null
     */
    public function getMitreAttack()
    {
        return $this->mitre_attack;
    }

    public function hasMitreAttack()
    {
        return isset($this->mitre_attack);
    }

    public function clearMitreAttack()
    {
        unset($this->mitre_attack);
    }

    /**
     * MITRE ATT&CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     * @param \Google\Cloud\SecurityCenter\V1\MitreAttack $var
     * @return $this
     */
    public function setMitreAttack($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\MitreAttack::class);
        $this->mitre_attack = $var;

        return $this;
    }

    /**
     * Access details associated with the finding, such as more information on the
     * caller, which method was accessed, and from where.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Access|null
     */
    public function getAccess()
    {
        return $this->access;
    }

    public function hasAccess()
    {
        return isset($this->access);
    }

    public function clearAccess()
    {
        unset($this->access);
    }

    /**
     * Access details associated with the finding, such as more information on the
     * caller, which method was accessed, and from where.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Access $var
     * @return $this
     */
    public function setAccess($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Access::class);
        $this->access = $var;

        return $this;
    }

    /**
     * Contains information about the IP connection associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getConnections()
    {
        return $this->connections;
    }

    /**
     * Contains information about the IP connection associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\Connection>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setConnections($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\Connection::class);
        $this->connections = $arr;

        return $this;
    }

    /**
     * Records additional information about the mute operation, for example, the
     * [mute configuration](/security-command-center/docs/how-to-mute-findings)
     * that muted the finding and the user who muted the finding.
     *
     * Generated from protobuf field <code>string mute_initiator = 28;</code>
     * @return string
     */
    public function getMuteInitiator()
    {
        return $this->mute_initiator;
    }

    /**
     * Records additional information about the mute operation, for example, the
     * [mute configuration](/security-command-center/docs/how-to-mute-findings)
     * that muted the finding and the user who muted the finding.
     *
     * Generated from protobuf field <code>string mute_initiator = 28;</code>
     * @param string $var
     * @return $this
     */
    public function setMuteInitiator($var)
    {
        GPBUtil::checkString($var, True);
        $this->mute_initiator = $var;

        return $this;
    }

    /**
     * Represents operating system processes associated with the Finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProcesses()
    {
        return $this->processes;
    }

    /**
     * Represents operating system processes associated with the Finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\Process>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProcesses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\Process::class);
        $this->processes = $arr;

        return $this;
    }

    /**
     * Output only. Map containing the points of contact for the given finding.
     * The key represents the type of contact, while the value contains a list of
     * all the contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycenter.v1.ContactDetails> contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getContacts()
    {
        return $this->contacts;
    }

    /**
     * Output only. Map containing the points of contact for the given finding.
     * The key represents the type of contact, while the value contains a list of
     * all the contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycenter.v1.ContactDetails> contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setContacts($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\ContactDetails::class);
        $this->contacts = $arr;

        return $this;
    }

    /**
     * Contains compliance information for security standards associated to the
     * finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCompliances()
    {
        return $this->compliances;
    }

    /**
     * Contains compliance information for security standards associated to the
     * finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\Compliance>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCompliances($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\Compliance::class);
        $this->compliances = $arr;

        return $this;
    }

    /**
     * Output only. The human readable display name of the finding source such as
     * "Event Threat Detection" or "Security Health Analytics".
     *
     * Generated from protobuf field <code>string parent_display_name = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getParentDisplayName()
    {
        return $this->parent_display_name;
    }

    /**
     * Output only. The human readable display name of the finding source such as
     * "Event Threat Detection" or "Security Health Analytics".
     *
     * Generated from protobuf field <code>string parent_display_name = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setParentDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent_display_name = $var;

        return $this;
    }

    /**
     * Contains more details about the finding.
     *
     * Generated from protobuf field <code>string description = 37;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Contains more details about the finding.
     *
     * Generated from protobuf field <code>string description = 37;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Represents exfiltrations associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Exfiltration|null
     */
    public function getExfiltration()
    {
        return $this->exfiltration;
    }

    public function hasExfiltration()
    {
        return isset($this->exfiltration);
    }

    public function clearExfiltration()
    {
        unset($this->exfiltration);
    }

    /**
     * Represents exfiltrations associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Exfiltration $var
     * @return $this
     */
    public function setExfiltration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Exfiltration::class);
        $this->exfiltration = $var;

        return $this;
    }

    /**
     * Represents IAM bindings associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIamBindings()
    {
        return $this->iam_bindings;
    }

    /**
     * Represents IAM bindings associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\IamBinding>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIamBindings($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\IamBinding::class);
        $this->iam_bindings = $arr;

        return $this;
    }

    /**
     * Steps to address the finding.
     *
     * Generated from protobuf field <code>string next_steps = 40;</code>
     * @return string
     */
    public function getNextSteps()
    {
        return $this->next_steps;
    }

    /**
     * Steps to address the finding.
     *
     * Generated from protobuf field <code>string next_steps = 40;</code>
     * @param string $var
     * @return $this
     */
    public function setNextSteps($var)
    {
        GPBUtil::checkString($var, True);
        $this->next_steps = $var;

        return $this;
    }

    /**
     * Unique identifier of the module which generated the finding.
     * Example:
     * folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
     *
     * Generated from protobuf field <code>string module_name = 41;</code>
     * @return string
     */
    public function getModuleName()
    {
        return $this->module_name;
    }

    /**
     * Unique identifier of the module which generated the finding.
     * Example:
     * folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
     *
     * Generated from protobuf field <code>string module_name = 41;</code>
     * @param string $var
     * @return $this
     */
    public function setModuleName($var)
    {
        GPBUtil::checkString($var, True);
        $this->module_name = $var;

        return $this;
    }

    /**
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getContainers()
    {
        return $this->containers;
    }

    /**
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\Container>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setContainers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\Container::class);
        $this->containers = $arr;

        return $this;
    }

    /**
     * Kubernetes resources associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Kubernetes|null
     */
    public function getKubernetes()
    {
        return $this->kubernetes;
    }

    public function hasKubernetes()
    {
        return isset($this->kubernetes);
    }

    public function clearKubernetes()
    {
        unset($this->kubernetes);
    }

    /**
     * Kubernetes resources associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Kubernetes $var
     * @return $this
     */
    public function setKubernetes($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Kubernetes::class);
        $this->kubernetes = $var;

        return $this;
    }

    /**
     * Database associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Database|null
     */
    public function getDatabase()
    {
        return $this->database;
    }

    public function hasDatabase()
    {
        return isset($this->database);
    }

    public function clearDatabase()
    {
        unset($this->database);
    }

    /**
     * Database associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Database $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Database::class);
        $this->database = $var;

        return $this;
    }

    /**
     * The results of an attack path simulation relevant to this finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.AttackExposure attack_exposure = 45;</code>
     * @return \Google\Cloud\SecurityCenter\V1\AttackExposure|null
     */
    public function getAttackExposure()
    {
        return $this->attack_exposure;
    }

    public function hasAttackExposure()
    {
        return isset($this->attack_exposure);
    }

    public function clearAttackExposure()
    {
        unset($this->attack_exposure);
    }

    /**
     * The results of an attack path simulation relevant to this finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.AttackExposure attack_exposure = 45;</code>
     * @param \Google\Cloud\SecurityCenter\V1\AttackExposure $var
     * @return $this
     */
    public function setAttackExposure($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\AttackExposure::class);
        $this->attack_exposure = $var;

        return $this;
    }

    /**
     * File associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFiles()
    {
        return $this->files;
    }

    /**
     * File associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\File>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFiles($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\File::class);
        $this->files = $arr;

        return $this;
    }

    /**
     * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     * associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
     * @return \Google\Cloud\SecurityCenter\V1\CloudDlpInspection|null
     */
    public function getCloudDlpInspection()
    {
        return $this->cloud_dlp_inspection;
    }

    public function hasCloudDlpInspection()
    {
        return isset($this->cloud_dlp_inspection);
    }

    public function clearCloudDlpInspection()
    {
        unset($this->cloud_dlp_inspection);
    }

    /**
     * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     * associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
     * @param \Google\Cloud\SecurityCenter\V1\CloudDlpInspection $var
     * @return $this
     */
    public function setCloudDlpInspection($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\CloudDlpInspection::class);
        $this->cloud_dlp_inspection = $var;

        return $this;
    }

    /**
     * Cloud DLP data profile that is associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
     * @return \Google\Cloud\SecurityCenter\V1\CloudDlpDataProfile|null
     */
    public function getCloudDlpDataProfile()
    {
        return $this->cloud_dlp_data_profile;
    }

    public function hasCloudDlpDataProfile()
    {
        return isset($this->cloud_dlp_data_profile);
    }

    public function clearCloudDlpDataProfile()
    {
        unset($this->cloud_dlp_data_profile);
    }

    /**
     * Cloud DLP data profile that is associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
     * @param \Google\Cloud\SecurityCenter\V1\CloudDlpDataProfile $var
     * @return $this
     */
    public function setCloudDlpDataProfile($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\CloudDlpDataProfile::class);
        $this->cloud_dlp_data_profile = $var;

        return $this;
    }

    /**
     * Signature of the kernel rootkit.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
     * @return \Google\Cloud\SecurityCenter\V1\KernelRootkit|null
     */
    public function getKernelRootkit()
    {
        return $this->kernel_rootkit;
    }

    public function hasKernelRootkit()
    {
        return isset($this->kernel_rootkit);
    }

    public function clearKernelRootkit()
    {
        unset($this->kernel_rootkit);
    }

    /**
     * Signature of the kernel rootkit.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
     * @param \Google\Cloud\SecurityCenter\V1\KernelRootkit $var
     * @return $this
     */
    public function setKernelRootkit($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\KernelRootkit::class);
        $this->kernel_rootkit = $var;

        return $this;
    }

    /**
     * Contains information about the org policies associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.OrgPolicy org_policies = 51;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOrgPolicies()
    {
        return $this->org_policies;
    }

    /**
     * Contains information about the org policies associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.OrgPolicy org_policies = 51;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\OrgPolicy>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOrgPolicies($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\OrgPolicy::class);
        $this->org_policies = $arr;

        return $this;
    }

    /**
     * Represents an application associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Application application = 53;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Application|null
     */
    public function getApplication()
    {
        return $this->application;
    }

    public function hasApplication()
    {
        return isset($this->application);
    }

    public function clearApplication()
    {
        unset($this->application);
    }

    /**
     * Represents an application associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Application application = 53;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Application $var
     * @return $this
     */
    public function setApplication($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Application::class);
        $this->application = $var;

        return $this;
    }

    /**
     * Fields related to Backup and DR findings.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.BackupDisasterRecovery backup_disaster_recovery = 55;</code>
     * @return \Google\Cloud\SecurityCenter\V1\BackupDisasterRecovery|null
     */
    public function getBackupDisasterRecovery()
    {
        return $this->backup_disaster_recovery;
    }

    public function hasBackupDisasterRecovery()
    {
        return isset($this->backup_disaster_recovery);
    }

    public function clearBackupDisasterRecovery()
    {
        unset($this->backup_disaster_recovery);
    }

    /**
     * Fields related to Backup and DR findings.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.BackupDisasterRecovery backup_disaster_recovery = 55;</code>
     * @param \Google\Cloud\SecurityCenter\V1\BackupDisasterRecovery $var
     * @return $this
     */
    public function setBackupDisasterRecovery($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\BackupDisasterRecovery::class);
        $this->backup_disaster_recovery = $var;

        return $this;
    }

    /**
     * The security posture associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityPosture security_posture = 56;</code>
     * @return \Google\Cloud\SecurityCenter\V1\SecurityPosture|null
     */
    public function getSecurityPosture()
    {
        return $this->security_posture;
    }

    public function hasSecurityPosture()
    {
        return isset($this->security_posture);
    }

    public function clearSecurityPosture()
    {
        unset($this->security_posture);
    }

    /**
     * The security posture associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityPosture security_posture = 56;</code>
     * @param \Google\Cloud\SecurityCenter\V1\SecurityPosture $var
     * @return $this
     */
    public function setSecurityPosture($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\SecurityPosture::class);
        $this->security_posture = $var;

        return $this;
    }

    /**
     * Log entries that are relevant to the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.LogEntry log_entries = 57;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLogEntries()
    {
        return $this->log_entries;
    }

    /**
     * Log entries that are relevant to the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.LogEntry log_entries = 57;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\LogEntry>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLogEntries($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\LogEntry::class);
        $this->log_entries = $arr;

        return $this;
    }

    /**
     * The load balancers associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.LoadBalancer load_balancers = 58;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLoadBalancers()
    {
        return $this->load_balancers;
    }

    /**
     * The load balancers associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.LoadBalancer load_balancers = 58;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\LoadBalancer>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLoadBalancers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\LoadBalancer::class);
        $this->load_balancers = $arr;

        return $this;
    }

    /**
     * Fields related to Cloud Armor findings.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.CloudArmor cloud_armor = 59;</code>
     * @return \Google\Cloud\SecurityCenter\V1\CloudArmor|null
     */
    public function getCloudArmor()
    {
        return $this->cloud_armor;
    }

    public function hasCloudArmor()
    {
        return isset($this->cloud_armor);
    }

    public function clearCloudArmor()
    {
        unset($this->cloud_armor);
    }

    /**
     * Fields related to Cloud Armor findings.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.CloudArmor cloud_armor = 59;</code>
     * @param \Google\Cloud\SecurityCenter\V1\CloudArmor $var
     * @return $this
     */
    public function setCloudArmor($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\CloudArmor::class);
        $this->cloud_armor = $var;

        return $this;
    }

    /**
     * Notebook associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Notebook notebook = 63;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Notebook|null
     */
    public function getNotebook()
    {
        return $this->notebook;
    }

    public function hasNotebook()
    {
        return isset($this->notebook);
    }

    public function clearNotebook()
    {
        unset($this->notebook);
    }

    /**
     * Notebook associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Notebook notebook = 63;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Notebook $var
     * @return $this
     */
    public function setNotebook($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Notebook::class);
        $this->notebook = $var;

        return $this;
    }

    /**
     * Contains details about a group of security issues that, when the issues
     * occur together, represent a greater risk than when the issues occur
     * independently. A group of such issues is referred to as a toxic
     * combination.
     * This field cannot be updated. Its value is ignored in all update requests.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.ToxicCombination toxic_combination = 64;</code>
     * @return \Google\Cloud\SecurityCenter\V1\ToxicCombination|null
     */
    public function getToxicCombination()
    {
        return $this->toxic_combination;
    }

    public function hasToxicCombination()
    {
        return isset($this->toxic_combination);
    }

    public function clearToxicCombination()
    {
        unset($this->toxic_combination);
    }

    /**
     * Contains details about a group of security issues that, when the issues
     * occur together, represent a greater risk than when the issues occur
     * independently. A group of such issues is referred to as a toxic
     * combination.
     * This field cannot be updated. Its value is ignored in all update requests.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.ToxicCombination toxic_combination = 64;</code>
     * @param \Google\Cloud\SecurityCenter\V1\ToxicCombination $var
     * @return $this
     */
    public function setToxicCombination($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\ToxicCombination::class);
        $this->toxic_combination = $var;

        return $this;
    }

    /**
     * Contains details about groups of which this finding is a member. A group is
     * a collection of findings that are related in some way.
     * This field cannot be updated. Its value is ignored in all update requests.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.GroupMembership group_memberships = 65;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGroupMemberships()
    {
        return $this->group_memberships;
    }

    /**
     * Contains details about groups of which this finding is a member. A group is
     * a collection of findings that are related in some way.
     * This field cannot be updated. Its value is ignored in all update requests.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.GroupMembership group_memberships = 65;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\GroupMembership>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGroupMemberships($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\GroupMembership::class);
        $this->group_memberships = $arr;

        return $this;
    }

}

