<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * ClusterUpdate describes an update to the cluster. Exactly one update can
 * be applied to a cluster with each request, so at most one field can be
 * provided.
 *
 * Generated from protobuf message <code>google.container.v1.ClusterUpdate</code>
 */
class ClusterUpdate extends \Google\Protobuf\Internal\Message
{
    /**
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     *
     * Generated from protobuf field <code>string desired_node_version = 4;</code>
     */
    protected $desired_node_version = '';
    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string desired_monitoring_service = 5;</code>
     */
    protected $desired_monitoring_service = '';
    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AddonsConfig desired_addons_config = 6;</code>
     */
    protected $desired_addons_config = null;
    /**
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family" or
     * "desired_node_pool_autoscaling" is specified and there is more than one
     * node pool on the cluster.
     *
     * Generated from protobuf field <code>string desired_node_pool_id = 7;</code>
     */
    protected $desired_node_pool_id = '';
    /**
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     *
     * Generated from protobuf field <code>string desired_image_type = 8;</code>
     */
    protected $desired_image_type = '';
    /**
     * Configuration of etcd encryption.
     *
     * Generated from protobuf field <code>.google.container.v1.DatabaseEncryption desired_database_encryption = 46;</code>
     */
    protected $desired_database_encryption = null;
    /**
     * Configuration for Workload Identity.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadIdentityConfig desired_workload_identity_config = 47;</code>
     */
    protected $desired_workload_identity_config = null;
    /**
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     *
     * Generated from protobuf field <code>.google.container.v1.MeshCertificates desired_mesh_certificates = 67;</code>
     */
    protected $desired_mesh_certificates = null;
    /**
     * Configuration for Shielded Nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedNodes desired_shielded_nodes = 48;</code>
     */
    protected $desired_shielded_nodes = null;
    /**
     * The desired configuration for the fine-grained cost management feature.
     *
     * Generated from protobuf field <code>.google.container.v1.CostManagementConfig desired_cost_management_config = 49;</code>
     */
    protected $desired_cost_management_config = null;
    /**
     * DNSConfig contains clusterDNS config for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DNSConfig desired_dns_config = 53;</code>
     */
    protected $desired_dns_config = null;
    /**
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     */
    protected $desired_node_pool_autoscaling = null;
    /**
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     * This list must always include the cluster's primary zone.
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     *
     * Generated from protobuf field <code>repeated string desired_locations = 10;</code>
     */
    private $desired_locations;
    /**
     * The desired configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;</code>
     */
    protected $desired_master_authorized_networks_config = null;
    /**
     * Cluster-level autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     */
    protected $desired_cluster_autoscaling = null;
    /**
     * The desired configuration options for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.container.v1.BinaryAuthorization desired_binary_authorization = 16;</code>
     */
    protected $desired_binary_authorization = null;
    /**
     * The logging service the cluster should use to write logs.
     * Currently available options:
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string desired_logging_service = 19;</code>
     */
    protected $desired_logging_service = '';
    /**
     * The desired configuration for exporting resource usage.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;</code>
     */
    protected $desired_resource_usage_export_config = null;
    /**
     * Cluster-level Vertical Pod Autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;</code>
     */
    protected $desired_vertical_pod_autoscaling = null;
    /**
     * The desired private cluster configuration. master_global_access_config is
     * the only field that can be changed via this field.
     * See also
     * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1.ClusterUpdate.desired_enable_private_endpoint]
     * for modifying other fields within
     * [PrivateClusterConfig][google.container.v1.PrivateClusterConfig].
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateClusterConfig desired_private_cluster_config = 25;</code>
     */
    protected $desired_private_cluster_config = null;
    /**
     * The desired config of Intra-node visibility.
     *
     * Generated from protobuf field <code>.google.container.v1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;</code>
     */
    protected $desired_intra_node_visibility_config = null;
    /**
     * The desired status of whether to disable default sNAT for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     */
    protected $desired_default_snat_status = null;
    /**
     * The desired release channel configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ReleaseChannel desired_release_channel = 31;</code>
     */
    protected $desired_release_channel = null;
    /**
     * The desired L4 Internal Load Balancer Subsetting configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;</code>
     */
    protected $desired_l4ilb_subsetting_config = null;
    /**
     * The desired datapath provider for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DatapathProvider desired_datapath_provider = 50;</code>
     */
    protected $desired_datapath_provider = 0;
    /**
     * The desired state of IPv6 connectivity to Google Services.
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateIPv6GoogleAccess desired_private_ipv6_google_access = 51;</code>
     */
    protected $desired_private_ipv6_google_access = 0;
    /**
     * The desired notification configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.NotificationConfig desired_notification_config = 55;</code>
     */
    protected $desired_notification_config = null;
    /**
     * The desired authenticator groups config for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;</code>
     */
    protected $desired_authenticator_groups_config = null;
    /**
     * The desired logging configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.LoggingConfig desired_logging_config = 64;</code>
     */
    protected $desired_logging_config = null;
    /**
     * The desired monitoring configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.MonitoringConfig desired_monitoring_config = 65;</code>
     */
    protected $desired_monitoring_config = null;
    /**
     * The desired Identity Service component configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.IdentityServiceConfig desired_identity_service_config = 66;</code>
     */
    protected $desired_identity_service_config = null;
    /**
     * ServiceExternalIPsConfig specifies the config for the use of Services with
     * ExternalIPs field.
     *
     * Generated from protobuf field <code>.google.container.v1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;</code>
     */
    protected $desired_service_external_ips_config = null;
    /**
     * Enable/Disable private endpoint for the cluster's master.
     *
     * Generated from protobuf field <code>optional bool desired_enable_private_endpoint = 71;</code>
     */
    protected $desired_enable_private_endpoint = null;
    /**
     * The Kubernetes version to change the master to.
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     *
     * Generated from protobuf field <code>string desired_master_version = 100;</code>
     */
    protected $desired_master_version = '';
    /**
     * The desired GCFS config for the cluster
     *
     * Generated from protobuf field <code>.google.container.v1.GcfsConfig desired_gcfs_config = 109;</code>
     */
    protected $desired_gcfs_config = null;
    /**
     * The desired network tags that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkTags desired_node_pool_auto_config_network_tags = 110;</code>
     */
    protected $desired_node_pool_auto_config_network_tags = null;
    /**
     * The desired config of Gateway API on this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
     */
    protected $desired_gateway_api_config = null;
    /**
     * The current etag of the cluster.
     * If an etag is provided and does not match the current etag of the cluster,
     * update will be blocked and an ABORTED error will be returned.
     *
     * Generated from protobuf field <code>string etag = 115;</code>
     */
    protected $etag = '';
    /**
     * The desired node pool logging configuration defaults for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;</code>
     */
    protected $desired_node_pool_logging_config = null;
    /**
     * The desired fleet configuration for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.Fleet desired_fleet = 117;</code>
     */
    protected $desired_fleet = null;
    /**
     * The desired stack type of the cluster.
     * If a stack type is provided and does not match the current stack type of
     * the cluster, update will attempt to change the stack type to the new type.
     *
     * Generated from protobuf field <code>.google.container.v1.StackType desired_stack_type = 119;</code>
     */
    protected $desired_stack_type = 0;
    /**
     * The additional pod ranges to be added to the cluster. These pod ranges
     * can be used by node pools to allocate pod IPs.
     *
     * Generated from protobuf field <code>.google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;</code>
     */
    protected $additional_pod_ranges_config = null;
    /**
     * The additional pod ranges that are to be removed from the cluster.
     * The pod ranges specified here must have been specified earlier in the
     * 'additional_pod_ranges_config' argument.
     *
     * Generated from protobuf field <code>.google.container.v1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;</code>
     */
    protected $removed_additional_pod_ranges_config = null;
    /**
     * Kubernetes open source beta apis enabled on the cluster. Only beta apis
     *
     * Generated from protobuf field <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
     */
    protected $enable_k8s_beta_apis = null;
    /**
     * Enable/Disable Security Posture API features for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.SecurityPostureConfig desired_security_posture_config = 124;</code>
     */
    protected $desired_security_posture_config = null;
    /**
     * The desired network performance config.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;</code>
     */
    protected $desired_network_performance_config = null;
    /**
     * Enable/Disable FQDN Network Policy for the cluster.
     *
     * Generated from protobuf field <code>optional bool desired_enable_fqdn_network_policy = 126;</code>
     */
    protected $desired_enable_fqdn_network_policy = null;
    /**
     * The desired workload policy configuration for the autopilot cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;</code>
     */
    protected $desired_autopilot_workload_policy_config = null;
    /**
     * Desired Beta APIs to be enabled for cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
     */
    protected $desired_k8s_beta_apis = null;
    /**
     * The desired containerd config for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.ContainerdConfig desired_containerd_config = 134;</code>
     */
    protected $desired_containerd_config = null;
    /**
     * Enable/Disable Multi-Networking for the cluster
     *
     * Generated from protobuf field <code>optional bool desired_enable_multi_networking = 135;</code>
     */
    protected $desired_enable_multi_networking = null;
    /**
     * The desired resource manager tags that apply to all auto-provisioned node
     * pools in autopilot clusters and node auto-provisioning enabled clusters.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;</code>
     */
    protected $desired_node_pool_auto_config_resource_manager_tags = null;
    /**
     * Specify the details of in-transit encryption.
     *
     * Generated from protobuf field <code>optional .google.container.v1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;</code>
     */
    protected $desired_in_transit_encryption_config = null;
    /**
     * Enable/Disable Cilium Clusterwide Network Policy for the cluster.
     *
     * Generated from protobuf field <code>optional bool desired_enable_cilium_clusterwide_network_policy = 138;</code>
     */
    protected $desired_enable_cilium_clusterwide_network_policy = null;
    /**
     * The desired node kubelet config for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
     */
    protected $desired_node_kubelet_config = null;
    /**
     * The desired node kubelet config for all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     *
     * Generated from protobuf field <code>.google.container.v1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;</code>
     */
    protected $desired_node_pool_auto_config_kubelet_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $desired_node_version
     *           The Kubernetes version to change the nodes to (typically an
     *           upgrade).
     *           Users may specify either explicit versions offered by
     *           Kubernetes Engine or version aliases, which have the following behavior:
     *           - "latest": picks the highest valid Kubernetes version
     *           - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     *           - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     *           - "1.X.Y-gke.N": picks an explicit Kubernetes version
     *           - "-": picks the Kubernetes master version
     *     @type string $desired_monitoring_service
     *           The monitoring service the cluster should use to write metrics.
     *           Currently available options:
     *           * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     *           service with a Kubernetes-native resource model
     *           * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *             longer available as of GKE 1.15).
     *           * `none` - No metrics will be exported from the cluster.
     *           If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     *           used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     *     @type \Google\Cloud\Container\V1\AddonsConfig $desired_addons_config
     *           Configurations for the various addons available to run in the cluster.
     *     @type string $desired_node_pool_id
     *           The node pool to be upgraded. This field is mandatory if
     *           "desired_node_version", "desired_image_family" or
     *           "desired_node_pool_autoscaling" is specified and there is more than one
     *           node pool on the cluster.
     *     @type string $desired_image_type
     *           The desired image type for the node pool.
     *           NOTE: Set the "desired_node_pool" field as well.
     *     @type \Google\Cloud\Container\V1\DatabaseEncryption $desired_database_encryption
     *           Configuration of etcd encryption.
     *     @type \Google\Cloud\Container\V1\WorkloadIdentityConfig $desired_workload_identity_config
     *           Configuration for Workload Identity.
     *     @type \Google\Cloud\Container\V1\MeshCertificates $desired_mesh_certificates
     *           Configuration for issuance of mTLS keys and certificates to Kubernetes
     *           pods.
     *     @type \Google\Cloud\Container\V1\ShieldedNodes $desired_shielded_nodes
     *           Configuration for Shielded Nodes.
     *     @type \Google\Cloud\Container\V1\CostManagementConfig $desired_cost_management_config
     *           The desired configuration for the fine-grained cost management feature.
     *     @type \Google\Cloud\Container\V1\DNSConfig $desired_dns_config
     *           DNSConfig contains clusterDNS config for this cluster.
     *     @type \Google\Cloud\Container\V1\NodePoolAutoscaling $desired_node_pool_autoscaling
     *           Autoscaler configuration for the node pool specified in
     *           desired_node_pool_id. If there is only one pool in the
     *           cluster and desired_node_pool_id is not provided then
     *           the change applies to that single node pool.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $desired_locations
     *           The desired list of Google Compute Engine
     *           [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     *           cluster's nodes should be located.
     *           This list must always include the cluster's primary zone.
     *           Warning: changing cluster locations will update the locations of all node
     *           pools and will result in nodes being added and/or removed.
     *     @type \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig $desired_master_authorized_networks_config
     *           The desired configuration options for master authorized networks feature.
     *     @type \Google\Cloud\Container\V1\ClusterAutoscaling $desired_cluster_autoscaling
     *           Cluster-level autoscaling configuration.
     *     @type \Google\Cloud\Container\V1\BinaryAuthorization $desired_binary_authorization
     *           The desired configuration options for the Binary Authorization feature.
     *     @type string $desired_logging_service
     *           The logging service the cluster should use to write logs.
     *           Currently available options:
     *           * `logging.googleapis.com/kubernetes` - The Cloud Logging
     *           service with a Kubernetes-native resource model
     *           * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *             available as of GKE 1.15).
     *           * `none` - no logs will be exported from the cluster.
     *           If left as an empty string,`logging.googleapis.com/kubernetes` will be
     *           used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     *     @type \Google\Cloud\Container\V1\ResourceUsageExportConfig $desired_resource_usage_export_config
     *           The desired configuration for exporting resource usage.
     *     @type \Google\Cloud\Container\V1\VerticalPodAutoscaling $desired_vertical_pod_autoscaling
     *           Cluster-level Vertical Pod Autoscaling configuration.
     *     @type \Google\Cloud\Container\V1\PrivateClusterConfig $desired_private_cluster_config
     *           The desired private cluster configuration. master_global_access_config is
     *           the only field that can be changed via this field.
     *           See also
     *           [ClusterUpdate.desired_enable_private_endpoint][google.container.v1.ClusterUpdate.desired_enable_private_endpoint]
     *           for modifying other fields within
     *           [PrivateClusterConfig][google.container.v1.PrivateClusterConfig].
     *     @type \Google\Cloud\Container\V1\IntraNodeVisibilityConfig $desired_intra_node_visibility_config
     *           The desired config of Intra-node visibility.
     *     @type \Google\Cloud\Container\V1\DefaultSnatStatus $desired_default_snat_status
     *           The desired status of whether to disable default sNAT for this cluster.
     *     @type \Google\Cloud\Container\V1\ReleaseChannel $desired_release_channel
     *           The desired release channel configuration.
     *     @type \Google\Cloud\Container\V1\ILBSubsettingConfig $desired_l4ilb_subsetting_config
     *           The desired L4 Internal Load Balancer Subsetting configuration.
     *     @type int $desired_datapath_provider
     *           The desired datapath provider for the cluster.
     *     @type int $desired_private_ipv6_google_access
     *           The desired state of IPv6 connectivity to Google Services.
     *     @type \Google\Cloud\Container\V1\NotificationConfig $desired_notification_config
     *           The desired notification configuration.
     *     @type \Google\Cloud\Container\V1\AuthenticatorGroupsConfig $desired_authenticator_groups_config
     *           The desired authenticator groups config for the cluster.
     *     @type \Google\Cloud\Container\V1\LoggingConfig $desired_logging_config
     *           The desired logging configuration.
     *     @type \Google\Cloud\Container\V1\MonitoringConfig $desired_monitoring_config
     *           The desired monitoring configuration.
     *     @type \Google\Cloud\Container\V1\IdentityServiceConfig $desired_identity_service_config
     *           The desired Identity Service component configuration.
     *     @type \Google\Cloud\Container\V1\ServiceExternalIPsConfig $desired_service_external_ips_config
     *           ServiceExternalIPsConfig specifies the config for the use of Services with
     *           ExternalIPs field.
     *     @type bool $desired_enable_private_endpoint
     *           Enable/Disable private endpoint for the cluster's master.
     *     @type string $desired_master_version
     *           The Kubernetes version to change the master to.
     *           Users may specify either explicit versions offered by
     *           Kubernetes Engine or version aliases, which have the following behavior:
     *           - "latest": picks the highest valid Kubernetes version
     *           - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     *           - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     *           - "1.X.Y-gke.N": picks an explicit Kubernetes version
     *           - "-": picks the default Kubernetes version
     *     @type \Google\Cloud\Container\V1\GcfsConfig $desired_gcfs_config
     *           The desired GCFS config for the cluster
     *     @type \Google\Cloud\Container\V1\NetworkTags $desired_node_pool_auto_config_network_tags
     *           The desired network tags that apply to all auto-provisioned node pools
     *           in autopilot clusters and node auto-provisioning enabled clusters.
     *     @type \Google\Cloud\Container\V1\GatewayAPIConfig $desired_gateway_api_config
     *           The desired config of Gateway API on this cluster.
     *     @type string $etag
     *           The current etag of the cluster.
     *           If an etag is provided and does not match the current etag of the cluster,
     *           update will be blocked and an ABORTED error will be returned.
     *     @type \Google\Cloud\Container\V1\NodePoolLoggingConfig $desired_node_pool_logging_config
     *           The desired node pool logging configuration defaults for the cluster.
     *     @type \Google\Cloud\Container\V1\Fleet $desired_fleet
     *           The desired fleet configuration for the cluster.
     *     @type int $desired_stack_type
     *           The desired stack type of the cluster.
     *           If a stack type is provided and does not match the current stack type of
     *           the cluster, update will attempt to change the stack type to the new type.
     *     @type \Google\Cloud\Container\V1\AdditionalPodRangesConfig $additional_pod_ranges_config
     *           The additional pod ranges to be added to the cluster. These pod ranges
     *           can be used by node pools to allocate pod IPs.
     *     @type \Google\Cloud\Container\V1\AdditionalPodRangesConfig $removed_additional_pod_ranges_config
     *           The additional pod ranges that are to be removed from the cluster.
     *           The pod ranges specified here must have been specified earlier in the
     *           'additional_pod_ranges_config' argument.
     *     @type \Google\Cloud\Container\V1\K8sBetaAPIConfig $enable_k8s_beta_apis
     *           Kubernetes open source beta apis enabled on the cluster. Only beta apis
     *     @type \Google\Cloud\Container\V1\SecurityPostureConfig $desired_security_posture_config
     *           Enable/Disable Security Posture API features for the cluster.
     *     @type \Google\Cloud\Container\V1\NetworkConfig\ClusterNetworkPerformanceConfig $desired_network_performance_config
     *           The desired network performance config.
     *     @type bool $desired_enable_fqdn_network_policy
     *           Enable/Disable FQDN Network Policy for the cluster.
     *     @type \Google\Cloud\Container\V1\WorkloadPolicyConfig $desired_autopilot_workload_policy_config
     *           The desired workload policy configuration for the autopilot cluster.
     *     @type \Google\Cloud\Container\V1\K8sBetaAPIConfig $desired_k8s_beta_apis
     *           Desired Beta APIs to be enabled for cluster.
     *     @type \Google\Cloud\Container\V1\ContainerdConfig $desired_containerd_config
     *           The desired containerd config for the cluster.
     *     @type bool $desired_enable_multi_networking
     *           Enable/Disable Multi-Networking for the cluster
     *     @type \Google\Cloud\Container\V1\ResourceManagerTags $desired_node_pool_auto_config_resource_manager_tags
     *           The desired resource manager tags that apply to all auto-provisioned node
     *           pools in autopilot clusters and node auto-provisioning enabled clusters.
     *     @type int $desired_in_transit_encryption_config
     *           Specify the details of in-transit encryption.
     *     @type bool $desired_enable_cilium_clusterwide_network_policy
     *           Enable/Disable Cilium Clusterwide Network Policy for the cluster.
     *     @type \Google\Cloud\Container\V1\NodeKubeletConfig $desired_node_kubelet_config
     *           The desired node kubelet config for the cluster.
     *     @type \Google\Cloud\Container\V1\NodeKubeletConfig $desired_node_pool_auto_config_kubelet_config
     *           The desired node kubelet config for all auto-provisioned node pools
     *           in autopilot clusters and node auto-provisioning enabled clusters.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     *
     * Generated from protobuf field <code>string desired_node_version = 4;</code>
     * @return string
     */
    public function getDesiredNodeVersion()
    {
        return $this->desired_node_version;
    }

    /**
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     *
     * Generated from protobuf field <code>string desired_node_version = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredNodeVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_node_version = $var;

        return $this;
    }

    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string desired_monitoring_service = 5;</code>
     * @return string
     */
    public function getDesiredMonitoringService()
    {
        return $this->desired_monitoring_service;
    }

    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string desired_monitoring_service = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredMonitoringService($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_monitoring_service = $var;

        return $this;
    }

    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AddonsConfig desired_addons_config = 6;</code>
     * @return \Google\Cloud\Container\V1\AddonsConfig|null
     */
    public function getDesiredAddonsConfig()
    {
        return $this->desired_addons_config;
    }

    public function hasDesiredAddonsConfig()
    {
        return isset($this->desired_addons_config);
    }

    public function clearDesiredAddonsConfig()
    {
        unset($this->desired_addons_config);
    }

    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AddonsConfig desired_addons_config = 6;</code>
     * @param \Google\Cloud\Container\V1\AddonsConfig $var
     * @return $this
     */
    public function setDesiredAddonsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\AddonsConfig::class);
        $this->desired_addons_config = $var;

        return $this;
    }

    /**
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family" or
     * "desired_node_pool_autoscaling" is specified and there is more than one
     * node pool on the cluster.
     *
     * Generated from protobuf field <code>string desired_node_pool_id = 7;</code>
     * @return string
     */
    public function getDesiredNodePoolId()
    {
        return $this->desired_node_pool_id;
    }

    /**
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family" or
     * "desired_node_pool_autoscaling" is specified and there is more than one
     * node pool on the cluster.
     *
     * Generated from protobuf field <code>string desired_node_pool_id = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredNodePoolId($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_node_pool_id = $var;

        return $this;
    }

    /**
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     *
     * Generated from protobuf field <code>string desired_image_type = 8;</code>
     * @return string
     */
    public function getDesiredImageType()
    {
        return $this->desired_image_type;
    }

    /**
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     *
     * Generated from protobuf field <code>string desired_image_type = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredImageType($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_image_type = $var;

        return $this;
    }

    /**
     * Configuration of etcd encryption.
     *
     * Generated from protobuf field <code>.google.container.v1.DatabaseEncryption desired_database_encryption = 46;</code>
     * @return \Google\Cloud\Container\V1\DatabaseEncryption|null
     */
    public function getDesiredDatabaseEncryption()
    {
        return $this->desired_database_encryption;
    }

    public function hasDesiredDatabaseEncryption()
    {
        return isset($this->desired_database_encryption);
    }

    public function clearDesiredDatabaseEncryption()
    {
        unset($this->desired_database_encryption);
    }

    /**
     * Configuration of etcd encryption.
     *
     * Generated from protobuf field <code>.google.container.v1.DatabaseEncryption desired_database_encryption = 46;</code>
     * @param \Google\Cloud\Container\V1\DatabaseEncryption $var
     * @return $this
     */
    public function setDesiredDatabaseEncryption($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\DatabaseEncryption::class);
        $this->desired_database_encryption = $var;

        return $this;
    }

    /**
     * Configuration for Workload Identity.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadIdentityConfig desired_workload_identity_config = 47;</code>
     * @return \Google\Cloud\Container\V1\WorkloadIdentityConfig|null
     */
    public function getDesiredWorkloadIdentityConfig()
    {
        return $this->desired_workload_identity_config;
    }

    public function hasDesiredWorkloadIdentityConfig()
    {
        return isset($this->desired_workload_identity_config);
    }

    public function clearDesiredWorkloadIdentityConfig()
    {
        unset($this->desired_workload_identity_config);
    }

    /**
     * Configuration for Workload Identity.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadIdentityConfig desired_workload_identity_config = 47;</code>
     * @param \Google\Cloud\Container\V1\WorkloadIdentityConfig $var
     * @return $this
     */
    public function setDesiredWorkloadIdentityConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\WorkloadIdentityConfig::class);
        $this->desired_workload_identity_config = $var;

        return $this;
    }

    /**
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     *
     * Generated from protobuf field <code>.google.container.v1.MeshCertificates desired_mesh_certificates = 67;</code>
     * @return \Google\Cloud\Container\V1\MeshCertificates|null
     */
    public function getDesiredMeshCertificates()
    {
        return $this->desired_mesh_certificates;
    }

    public function hasDesiredMeshCertificates()
    {
        return isset($this->desired_mesh_certificates);
    }

    public function clearDesiredMeshCertificates()
    {
        unset($this->desired_mesh_certificates);
    }

    /**
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     *
     * Generated from protobuf field <code>.google.container.v1.MeshCertificates desired_mesh_certificates = 67;</code>
     * @param \Google\Cloud\Container\V1\MeshCertificates $var
     * @return $this
     */
    public function setDesiredMeshCertificates($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\MeshCertificates::class);
        $this->desired_mesh_certificates = $var;

        return $this;
    }

    /**
     * Configuration for Shielded Nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedNodes desired_shielded_nodes = 48;</code>
     * @return \Google\Cloud\Container\V1\ShieldedNodes|null
     */
    public function getDesiredShieldedNodes()
    {
        return $this->desired_shielded_nodes;
    }

    public function hasDesiredShieldedNodes()
    {
        return isset($this->desired_shielded_nodes);
    }

    public function clearDesiredShieldedNodes()
    {
        unset($this->desired_shielded_nodes);
    }

    /**
     * Configuration for Shielded Nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedNodes desired_shielded_nodes = 48;</code>
     * @param \Google\Cloud\Container\V1\ShieldedNodes $var
     * @return $this
     */
    public function setDesiredShieldedNodes($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ShieldedNodes::class);
        $this->desired_shielded_nodes = $var;

        return $this;
    }

    /**
     * The desired configuration for the fine-grained cost management feature.
     *
     * Generated from protobuf field <code>.google.container.v1.CostManagementConfig desired_cost_management_config = 49;</code>
     * @return \Google\Cloud\Container\V1\CostManagementConfig|null
     */
    public function getDesiredCostManagementConfig()
    {
        return $this->desired_cost_management_config;
    }

    public function hasDesiredCostManagementConfig()
    {
        return isset($this->desired_cost_management_config);
    }

    public function clearDesiredCostManagementConfig()
    {
        unset($this->desired_cost_management_config);
    }

    /**
     * The desired configuration for the fine-grained cost management feature.
     *
     * Generated from protobuf field <code>.google.container.v1.CostManagementConfig desired_cost_management_config = 49;</code>
     * @param \Google\Cloud\Container\V1\CostManagementConfig $var
     * @return $this
     */
    public function setDesiredCostManagementConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\CostManagementConfig::class);
        $this->desired_cost_management_config = $var;

        return $this;
    }

    /**
     * DNSConfig contains clusterDNS config for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DNSConfig desired_dns_config = 53;</code>
     * @return \Google\Cloud\Container\V1\DNSConfig|null
     */
    public function getDesiredDnsConfig()
    {
        return $this->desired_dns_config;
    }

    public function hasDesiredDnsConfig()
    {
        return isset($this->desired_dns_config);
    }

    public function clearDesiredDnsConfig()
    {
        unset($this->desired_dns_config);
    }

    /**
     * DNSConfig contains clusterDNS config for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DNSConfig desired_dns_config = 53;</code>
     * @param \Google\Cloud\Container\V1\DNSConfig $var
     * @return $this
     */
    public function setDesiredDnsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\DNSConfig::class);
        $this->desired_dns_config = $var;

        return $this;
    }

    /**
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     * @return \Google\Cloud\Container\V1\NodePoolAutoscaling|null
     */
    public function getDesiredNodePoolAutoscaling()
    {
        return $this->desired_node_pool_autoscaling;
    }

    public function hasDesiredNodePoolAutoscaling()
    {
        return isset($this->desired_node_pool_autoscaling);
    }

    public function clearDesiredNodePoolAutoscaling()
    {
        unset($this->desired_node_pool_autoscaling);
    }

    /**
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     * @param \Google\Cloud\Container\V1\NodePoolAutoscaling $var
     * @return $this
     */
    public function setDesiredNodePoolAutoscaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NodePoolAutoscaling::class);
        $this->desired_node_pool_autoscaling = $var;

        return $this;
    }

    /**
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     * This list must always include the cluster's primary zone.
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     *
     * Generated from protobuf field <code>repeated string desired_locations = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDesiredLocations()
    {
        return $this->desired_locations;
    }

    /**
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     * This list must always include the cluster's primary zone.
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     *
     * Generated from protobuf field <code>repeated string desired_locations = 10;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDesiredLocations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->desired_locations = $arr;

        return $this;
    }

    /**
     * The desired configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;</code>
     * @return \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig|null
     */
    public function getDesiredMasterAuthorizedNetworksConfig()
    {
        return $this->desired_master_authorized_networks_config;
    }

    public function hasDesiredMasterAuthorizedNetworksConfig()
    {
        return isset($this->desired_master_authorized_networks_config);
    }

    public function clearDesiredMasterAuthorizedNetworksConfig()
    {
        unset($this->desired_master_authorized_networks_config);
    }

    /**
     * The desired configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;</code>
     * @param \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig $var
     * @return $this
     */
    public function setDesiredMasterAuthorizedNetworksConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig::class);
        $this->desired_master_authorized_networks_config = $var;

        return $this;
    }

    /**
     * Cluster-level autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     * @return \Google\Cloud\Container\V1\ClusterAutoscaling|null
     */
    public function getDesiredClusterAutoscaling()
    {
        return $this->desired_cluster_autoscaling;
    }

    public function hasDesiredClusterAutoscaling()
    {
        return isset($this->desired_cluster_autoscaling);
    }

    public function clearDesiredClusterAutoscaling()
    {
        unset($this->desired_cluster_autoscaling);
    }

    /**
     * Cluster-level autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     * @param \Google\Cloud\Container\V1\ClusterAutoscaling $var
     * @return $this
     */
    public function setDesiredClusterAutoscaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ClusterAutoscaling::class);
        $this->desired_cluster_autoscaling = $var;

        return $this;
    }

    /**
     * The desired configuration options for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.container.v1.BinaryAuthorization desired_binary_authorization = 16;</code>
     * @return \Google\Cloud\Container\V1\BinaryAuthorization|null
     */
    public function getDesiredBinaryAuthorization()
    {
        return $this->desired_binary_authorization;
    }

    public function hasDesiredBinaryAuthorization()
    {
        return isset($this->desired_binary_authorization);
    }

    public function clearDesiredBinaryAuthorization()
    {
        unset($this->desired_binary_authorization);
    }

    /**
     * The desired configuration options for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.container.v1.BinaryAuthorization desired_binary_authorization = 16;</code>
     * @param \Google\Cloud\Container\V1\BinaryAuthorization $var
     * @return $this
     */
    public function setDesiredBinaryAuthorization($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\BinaryAuthorization::class);
        $this->desired_binary_authorization = $var;

        return $this;
    }

    /**
     * The logging service the cluster should use to write logs.
     * Currently available options:
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string desired_logging_service = 19;</code>
     * @return string
     */
    public function getDesiredLoggingService()
    {
        return $this->desired_logging_service;
    }

    /**
     * The logging service the cluster should use to write logs.
     * Currently available options:
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string desired_logging_service = 19;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredLoggingService($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_logging_service = $var;

        return $this;
    }

    /**
     * The desired configuration for exporting resource usage.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;</code>
     * @return \Google\Cloud\Container\V1\ResourceUsageExportConfig|null
     */
    public function getDesiredResourceUsageExportConfig()
    {
        return $this->desired_resource_usage_export_config;
    }

    public function hasDesiredResourceUsageExportConfig()
    {
        return isset($this->desired_resource_usage_export_config);
    }

    public function clearDesiredResourceUsageExportConfig()
    {
        unset($this->desired_resource_usage_export_config);
    }

    /**
     * The desired configuration for exporting resource usage.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;</code>
     * @param \Google\Cloud\Container\V1\ResourceUsageExportConfig $var
     * @return $this
     */
    public function setDesiredResourceUsageExportConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ResourceUsageExportConfig::class);
        $this->desired_resource_usage_export_config = $var;

        return $this;
    }

    /**
     * Cluster-level Vertical Pod Autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;</code>
     * @return \Google\Cloud\Container\V1\VerticalPodAutoscaling|null
     */
    public function getDesiredVerticalPodAutoscaling()
    {
        return $this->desired_vertical_pod_autoscaling;
    }

    public function hasDesiredVerticalPodAutoscaling()
    {
        return isset($this->desired_vertical_pod_autoscaling);
    }

    public function clearDesiredVerticalPodAutoscaling()
    {
        unset($this->desired_vertical_pod_autoscaling);
    }

    /**
     * Cluster-level Vertical Pod Autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;</code>
     * @param \Google\Cloud\Container\V1\VerticalPodAutoscaling $var
     * @return $this
     */
    public function setDesiredVerticalPodAutoscaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\VerticalPodAutoscaling::class);
        $this->desired_vertical_pod_autoscaling = $var;

        return $this;
    }

    /**
     * The desired private cluster configuration. master_global_access_config is
     * the only field that can be changed via this field.
     * See also
     * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1.ClusterUpdate.desired_enable_private_endpoint]
     * for modifying other fields within
     * [PrivateClusterConfig][google.container.v1.PrivateClusterConfig].
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateClusterConfig desired_private_cluster_config = 25;</code>
     * @return \Google\Cloud\Container\V1\PrivateClusterConfig|null
     */
    public function getDesiredPrivateClusterConfig()
    {
        return $this->desired_private_cluster_config;
    }

    public function hasDesiredPrivateClusterConfig()
    {
        return isset($this->desired_private_cluster_config);
    }

    public function clearDesiredPrivateClusterConfig()
    {
        unset($this->desired_private_cluster_config);
    }

    /**
     * The desired private cluster configuration. master_global_access_config is
     * the only field that can be changed via this field.
     * See also
     * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1.ClusterUpdate.desired_enable_private_endpoint]
     * for modifying other fields within
     * [PrivateClusterConfig][google.container.v1.PrivateClusterConfig].
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateClusterConfig desired_private_cluster_config = 25;</code>
     * @param \Google\Cloud\Container\V1\PrivateClusterConfig $var
     * @return $this
     */
    public function setDesiredPrivateClusterConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\PrivateClusterConfig::class);
        $this->desired_private_cluster_config = $var;

        return $this;
    }

    /**
     * The desired config of Intra-node visibility.
     *
     * Generated from protobuf field <code>.google.container.v1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;</code>
     * @return \Google\Cloud\Container\V1\IntraNodeVisibilityConfig|null
     */
    public function getDesiredIntraNodeVisibilityConfig()
    {
        return $this->desired_intra_node_visibility_config;
    }

    public function hasDesiredIntraNodeVisibilityConfig()
    {
        return isset($this->desired_intra_node_visibility_config);
    }

    public function clearDesiredIntraNodeVisibilityConfig()
    {
        unset($this->desired_intra_node_visibility_config);
    }

    /**
     * The desired config of Intra-node visibility.
     *
     * Generated from protobuf field <code>.google.container.v1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;</code>
     * @param \Google\Cloud\Container\V1\IntraNodeVisibilityConfig $var
     * @return $this
     */
    public function setDesiredIntraNodeVisibilityConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\IntraNodeVisibilityConfig::class);
        $this->desired_intra_node_visibility_config = $var;

        return $this;
    }

    /**
     * The desired status of whether to disable default sNAT for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     * @return \Google\Cloud\Container\V1\DefaultSnatStatus|null
     */
    public function getDesiredDefaultSnatStatus()
    {
        return $this->desired_default_snat_status;
    }

    public function hasDesiredDefaultSnatStatus()
    {
        return isset($this->desired_default_snat_status);
    }

    public function clearDesiredDefaultSnatStatus()
    {
        unset($this->desired_default_snat_status);
    }

    /**
     * The desired status of whether to disable default sNAT for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     * @param \Google\Cloud\Container\V1\DefaultSnatStatus $var
     * @return $this
     */
    public function setDesiredDefaultSnatStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\DefaultSnatStatus::class);
        $this->desired_default_snat_status = $var;

        return $this;
    }

    /**
     * The desired release channel configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ReleaseChannel desired_release_channel = 31;</code>
     * @return \Google\Cloud\Container\V1\ReleaseChannel|null
     */
    public function getDesiredReleaseChannel()
    {
        return $this->desired_release_channel;
    }

    public function hasDesiredReleaseChannel()
    {
        return isset($this->desired_release_channel);
    }

    public function clearDesiredReleaseChannel()
    {
        unset($this->desired_release_channel);
    }

    /**
     * The desired release channel configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ReleaseChannel desired_release_channel = 31;</code>
     * @param \Google\Cloud\Container\V1\ReleaseChannel $var
     * @return $this
     */
    public function setDesiredReleaseChannel($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ReleaseChannel::class);
        $this->desired_release_channel = $var;

        return $this;
    }

    /**
     * The desired L4 Internal Load Balancer Subsetting configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;</code>
     * @return \Google\Cloud\Container\V1\ILBSubsettingConfig|null
     */
    public function getDesiredL4IlbSubsettingConfig()
    {
        return $this->desired_l4ilb_subsetting_config;
    }

    public function hasDesiredL4IlbSubsettingConfig()
    {
        return isset($this->desired_l4ilb_subsetting_config);
    }

    public function clearDesiredL4IlbSubsettingConfig()
    {
        unset($this->desired_l4ilb_subsetting_config);
    }

    /**
     * The desired L4 Internal Load Balancer Subsetting configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;</code>
     * @param \Google\Cloud\Container\V1\ILBSubsettingConfig $var
     * @return $this
     */
    public function setDesiredL4IlbSubsettingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ILBSubsettingConfig::class);
        $this->desired_l4ilb_subsetting_config = $var;

        return $this;
    }

    /**
     * The desired datapath provider for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DatapathProvider desired_datapath_provider = 50;</code>
     * @return int
     */
    public function getDesiredDatapathProvider()
    {
        return $this->desired_datapath_provider;
    }

    /**
     * The desired datapath provider for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DatapathProvider desired_datapath_provider = 50;</code>
     * @param int $var
     * @return $this
     */
    public function setDesiredDatapathProvider($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Container\V1\DatapathProvider::class);
        $this->desired_datapath_provider = $var;

        return $this;
    }

    /**
     * The desired state of IPv6 connectivity to Google Services.
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateIPv6GoogleAccess desired_private_ipv6_google_access = 51;</code>
     * @return int
     */
    public function getDesiredPrivateIpv6GoogleAccess()
    {
        return $this->desired_private_ipv6_google_access;
    }

    /**
     * The desired state of IPv6 connectivity to Google Services.
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateIPv6GoogleAccess desired_private_ipv6_google_access = 51;</code>
     * @param int $var
     * @return $this
     */
    public function setDesiredPrivateIpv6GoogleAccess($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Container\V1\PrivateIPv6GoogleAccess::class);
        $this->desired_private_ipv6_google_access = $var;

        return $this;
    }

    /**
     * The desired notification configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.NotificationConfig desired_notification_config = 55;</code>
     * @return \Google\Cloud\Container\V1\NotificationConfig|null
     */
    public function getDesiredNotificationConfig()
    {
        return $this->desired_notification_config;
    }

    public function hasDesiredNotificationConfig()
    {
        return isset($this->desired_notification_config);
    }

    public function clearDesiredNotificationConfig()
    {
        unset($this->desired_notification_config);
    }

    /**
     * The desired notification configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.NotificationConfig desired_notification_config = 55;</code>
     * @param \Google\Cloud\Container\V1\NotificationConfig $var
     * @return $this
     */
    public function setDesiredNotificationConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NotificationConfig::class);
        $this->desired_notification_config = $var;

        return $this;
    }

    /**
     * The desired authenticator groups config for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;</code>
     * @return \Google\Cloud\Container\V1\AuthenticatorGroupsConfig|null
     */
    public function getDesiredAuthenticatorGroupsConfig()
    {
        return $this->desired_authenticator_groups_config;
    }

    public function hasDesiredAuthenticatorGroupsConfig()
    {
        return isset($this->desired_authenticator_groups_config);
    }

    public function clearDesiredAuthenticatorGroupsConfig()
    {
        unset($this->desired_authenticator_groups_config);
    }

    /**
     * The desired authenticator groups config for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;</code>
     * @param \Google\Cloud\Container\V1\AuthenticatorGroupsConfig $var
     * @return $this
     */
    public function setDesiredAuthenticatorGroupsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\AuthenticatorGroupsConfig::class);
        $this->desired_authenticator_groups_config = $var;

        return $this;
    }

    /**
     * The desired logging configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.LoggingConfig desired_logging_config = 64;</code>
     * @return \Google\Cloud\Container\V1\LoggingConfig|null
     */
    public function getDesiredLoggingConfig()
    {
        return $this->desired_logging_config;
    }

    public function hasDesiredLoggingConfig()
    {
        return isset($this->desired_logging_config);
    }

    public function clearDesiredLoggingConfig()
    {
        unset($this->desired_logging_config);
    }

    /**
     * The desired logging configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.LoggingConfig desired_logging_config = 64;</code>
     * @param \Google\Cloud\Container\V1\LoggingConfig $var
     * @return $this
     */
    public function setDesiredLoggingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\LoggingConfig::class);
        $this->desired_logging_config = $var;

        return $this;
    }

    /**
     * The desired monitoring configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.MonitoringConfig desired_monitoring_config = 65;</code>
     * @return \Google\Cloud\Container\V1\MonitoringConfig|null
     */
    public function getDesiredMonitoringConfig()
    {
        return $this->desired_monitoring_config;
    }

    public function hasDesiredMonitoringConfig()
    {
        return isset($this->desired_monitoring_config);
    }

    public function clearDesiredMonitoringConfig()
    {
        unset($this->desired_monitoring_config);
    }

    /**
     * The desired monitoring configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.MonitoringConfig desired_monitoring_config = 65;</code>
     * @param \Google\Cloud\Container\V1\MonitoringConfig $var
     * @return $this
     */
    public function setDesiredMonitoringConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\MonitoringConfig::class);
        $this->desired_monitoring_config = $var;

        return $this;
    }

    /**
     * The desired Identity Service component configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.IdentityServiceConfig desired_identity_service_config = 66;</code>
     * @return \Google\Cloud\Container\V1\IdentityServiceConfig|null
     */
    public function getDesiredIdentityServiceConfig()
    {
        return $this->desired_identity_service_config;
    }

    public function hasDesiredIdentityServiceConfig()
    {
        return isset($this->desired_identity_service_config);
    }

    public function clearDesiredIdentityServiceConfig()
    {
        unset($this->desired_identity_service_config);
    }

    /**
     * The desired Identity Service component configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.IdentityServiceConfig desired_identity_service_config = 66;</code>
     * @param \Google\Cloud\Container\V1\IdentityServiceConfig $var
     * @return $this
     */
    public function setDesiredIdentityServiceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\IdentityServiceConfig::class);
        $this->desired_identity_service_config = $var;

        return $this;
    }

    /**
     * ServiceExternalIPsConfig specifies the config for the use of Services with
     * ExternalIPs field.
     *
     * Generated from protobuf field <code>.google.container.v1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;</code>
     * @return \Google\Cloud\Container\V1\ServiceExternalIPsConfig|null
     */
    public function getDesiredServiceExternalIpsConfig()
    {
        return $this->desired_service_external_ips_config;
    }

    public function hasDesiredServiceExternalIpsConfig()
    {
        return isset($this->desired_service_external_ips_config);
    }

    public function clearDesiredServiceExternalIpsConfig()
    {
        unset($this->desired_service_external_ips_config);
    }

    /**
     * ServiceExternalIPsConfig specifies the config for the use of Services with
     * ExternalIPs field.
     *
     * Generated from protobuf field <code>.google.container.v1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;</code>
     * @param \Google\Cloud\Container\V1\ServiceExternalIPsConfig $var
     * @return $this
     */
    public function setDesiredServiceExternalIpsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ServiceExternalIPsConfig::class);
        $this->desired_service_external_ips_config = $var;

        return $this;
    }

    /**
     * Enable/Disable private endpoint for the cluster's master.
     *
     * Generated from protobuf field <code>optional bool desired_enable_private_endpoint = 71;</code>
     * @return bool
     */
    public function getDesiredEnablePrivateEndpoint()
    {
        return isset($this->desired_enable_private_endpoint) ? $this->desired_enable_private_endpoint : false;
    }

    public function hasDesiredEnablePrivateEndpoint()
    {
        return isset($this->desired_enable_private_endpoint);
    }

    public function clearDesiredEnablePrivateEndpoint()
    {
        unset($this->desired_enable_private_endpoint);
    }

    /**
     * Enable/Disable private endpoint for the cluster's master.
     *
     * Generated from protobuf field <code>optional bool desired_enable_private_endpoint = 71;</code>
     * @param bool $var
     * @return $this
     */
    public function setDesiredEnablePrivateEndpoint($var)
    {
        GPBUtil::checkBool($var);
        $this->desired_enable_private_endpoint = $var;

        return $this;
    }

    /**
     * The Kubernetes version to change the master to.
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     *
     * Generated from protobuf field <code>string desired_master_version = 100;</code>
     * @return string
     */
    public function getDesiredMasterVersion()
    {
        return $this->desired_master_version;
    }

    /**
     * The Kubernetes version to change the master to.
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     *
     * Generated from protobuf field <code>string desired_master_version = 100;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredMasterVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_master_version = $var;

        return $this;
    }

    /**
     * The desired GCFS config for the cluster
     *
     * Generated from protobuf field <code>.google.container.v1.GcfsConfig desired_gcfs_config = 109;</code>
     * @return \Google\Cloud\Container\V1\GcfsConfig|null
     */
    public function getDesiredGcfsConfig()
    {
        return $this->desired_gcfs_config;
    }

    public function hasDesiredGcfsConfig()
    {
        return isset($this->desired_gcfs_config);
    }

    public function clearDesiredGcfsConfig()
    {
        unset($this->desired_gcfs_config);
    }

    /**
     * The desired GCFS config for the cluster
     *
     * Generated from protobuf field <code>.google.container.v1.GcfsConfig desired_gcfs_config = 109;</code>
     * @param \Google\Cloud\Container\V1\GcfsConfig $var
     * @return $this
     */
    public function setDesiredGcfsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\GcfsConfig::class);
        $this->desired_gcfs_config = $var;

        return $this;
    }

    /**
     * The desired network tags that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkTags desired_node_pool_auto_config_network_tags = 110;</code>
     * @return \Google\Cloud\Container\V1\NetworkTags|null
     */
    public function getDesiredNodePoolAutoConfigNetworkTags()
    {
        return $this->desired_node_pool_auto_config_network_tags;
    }

    public function hasDesiredNodePoolAutoConfigNetworkTags()
    {
        return isset($this->desired_node_pool_auto_config_network_tags);
    }

    public function clearDesiredNodePoolAutoConfigNetworkTags()
    {
        unset($this->desired_node_pool_auto_config_network_tags);
    }

    /**
     * The desired network tags that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkTags desired_node_pool_auto_config_network_tags = 110;</code>
     * @param \Google\Cloud\Container\V1\NetworkTags $var
     * @return $this
     */
    public function setDesiredNodePoolAutoConfigNetworkTags($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NetworkTags::class);
        $this->desired_node_pool_auto_config_network_tags = $var;

        return $this;
    }

    /**
     * The desired config of Gateway API on this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
     * @return \Google\Cloud\Container\V1\GatewayAPIConfig|null
     */
    public function getDesiredGatewayApiConfig()
    {
        return $this->desired_gateway_api_config;
    }

    public function hasDesiredGatewayApiConfig()
    {
        return isset($this->desired_gateway_api_config);
    }

    public function clearDesiredGatewayApiConfig()
    {
        unset($this->desired_gateway_api_config);
    }

    /**
     * The desired config of Gateway API on this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
     * @param \Google\Cloud\Container\V1\GatewayAPIConfig $var
     * @return $this
     */
    public function setDesiredGatewayApiConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\GatewayAPIConfig::class);
        $this->desired_gateway_api_config = $var;

        return $this;
    }

    /**
     * The current etag of the cluster.
     * If an etag is provided and does not match the current etag of the cluster,
     * update will be blocked and an ABORTED error will be returned.
     *
     * Generated from protobuf field <code>string etag = 115;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * The current etag of the cluster.
     * If an etag is provided and does not match the current etag of the cluster,
     * update will be blocked and an ABORTED error will be returned.
     *
     * Generated from protobuf field <code>string etag = 115;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * The desired node pool logging configuration defaults for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;</code>
     * @return \Google\Cloud\Container\V1\NodePoolLoggingConfig|null
     */
    public function getDesiredNodePoolLoggingConfig()
    {
        return $this->desired_node_pool_logging_config;
    }

    public function hasDesiredNodePoolLoggingConfig()
    {
        return isset($this->desired_node_pool_logging_config);
    }

    public function clearDesiredNodePoolLoggingConfig()
    {
        unset($this->desired_node_pool_logging_config);
    }

    /**
     * The desired node pool logging configuration defaults for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;</code>
     * @param \Google\Cloud\Container\V1\NodePoolLoggingConfig $var
     * @return $this
     */
    public function setDesiredNodePoolLoggingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NodePoolLoggingConfig::class);
        $this->desired_node_pool_logging_config = $var;

        return $this;
    }

    /**
     * The desired fleet configuration for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.Fleet desired_fleet = 117;</code>
     * @return \Google\Cloud\Container\V1\Fleet|null
     */
    public function getDesiredFleet()
    {
        return $this->desired_fleet;
    }

    public function hasDesiredFleet()
    {
        return isset($this->desired_fleet);
    }

    public function clearDesiredFleet()
    {
        unset($this->desired_fleet);
    }

    /**
     * The desired fleet configuration for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.Fleet desired_fleet = 117;</code>
     * @param \Google\Cloud\Container\V1\Fleet $var
     * @return $this
     */
    public function setDesiredFleet($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\Fleet::class);
        $this->desired_fleet = $var;

        return $this;
    }

    /**
     * The desired stack type of the cluster.
     * If a stack type is provided and does not match the current stack type of
     * the cluster, update will attempt to change the stack type to the new type.
     *
     * Generated from protobuf field <code>.google.container.v1.StackType desired_stack_type = 119;</code>
     * @return int
     */
    public function getDesiredStackType()
    {
        return $this->desired_stack_type;
    }

    /**
     * The desired stack type of the cluster.
     * If a stack type is provided and does not match the current stack type of
     * the cluster, update will attempt to change the stack type to the new type.
     *
     * Generated from protobuf field <code>.google.container.v1.StackType desired_stack_type = 119;</code>
     * @param int $var
     * @return $this
     */
    public function setDesiredStackType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Container\V1\StackType::class);
        $this->desired_stack_type = $var;

        return $this;
    }

    /**
     * The additional pod ranges to be added to the cluster. These pod ranges
     * can be used by node pools to allocate pod IPs.
     *
     * Generated from protobuf field <code>.google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;</code>
     * @return \Google\Cloud\Container\V1\AdditionalPodRangesConfig|null
     */
    public function getAdditionalPodRangesConfig()
    {
        return $this->additional_pod_ranges_config;
    }

    public function hasAdditionalPodRangesConfig()
    {
        return isset($this->additional_pod_ranges_config);
    }

    public function clearAdditionalPodRangesConfig()
    {
        unset($this->additional_pod_ranges_config);
    }

    /**
     * The additional pod ranges to be added to the cluster. These pod ranges
     * can be used by node pools to allocate pod IPs.
     *
     * Generated from protobuf field <code>.google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;</code>
     * @param \Google\Cloud\Container\V1\AdditionalPodRangesConfig $var
     * @return $this
     */
    public function setAdditionalPodRangesConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\AdditionalPodRangesConfig::class);
        $this->additional_pod_ranges_config = $var;

        return $this;
    }

    /**
     * The additional pod ranges that are to be removed from the cluster.
     * The pod ranges specified here must have been specified earlier in the
     * 'additional_pod_ranges_config' argument.
     *
     * Generated from protobuf field <code>.google.container.v1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;</code>
     * @return \Google\Cloud\Container\V1\AdditionalPodRangesConfig|null
     */
    public function getRemovedAdditionalPodRangesConfig()
    {
        return $this->removed_additional_pod_ranges_config;
    }

    public function hasRemovedAdditionalPodRangesConfig()
    {
        return isset($this->removed_additional_pod_ranges_config);
    }

    public function clearRemovedAdditionalPodRangesConfig()
    {
        unset($this->removed_additional_pod_ranges_config);
    }

    /**
     * The additional pod ranges that are to be removed from the cluster.
     * The pod ranges specified here must have been specified earlier in the
     * 'additional_pod_ranges_config' argument.
     *
     * Generated from protobuf field <code>.google.container.v1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;</code>
     * @param \Google\Cloud\Container\V1\AdditionalPodRangesConfig $var
     * @return $this
     */
    public function setRemovedAdditionalPodRangesConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\AdditionalPodRangesConfig::class);
        $this->removed_additional_pod_ranges_config = $var;

        return $this;
    }

    /**
     * Kubernetes open source beta apis enabled on the cluster. Only beta apis
     *
     * Generated from protobuf field <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
     * @return \Google\Cloud\Container\V1\K8sBetaAPIConfig|null
     */
    public function getEnableK8SBetaApis()
    {
        return $this->enable_k8s_beta_apis;
    }

    public function hasEnableK8SBetaApis()
    {
        return isset($this->enable_k8s_beta_apis);
    }

    public function clearEnableK8SBetaApis()
    {
        unset($this->enable_k8s_beta_apis);
    }

    /**
     * Kubernetes open source beta apis enabled on the cluster. Only beta apis
     *
     * Generated from protobuf field <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
     * @param \Google\Cloud\Container\V1\K8sBetaAPIConfig $var
     * @return $this
     */
    public function setEnableK8SBetaApis($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\K8sBetaAPIConfig::class);
        $this->enable_k8s_beta_apis = $var;

        return $this;
    }

    /**
     * Enable/Disable Security Posture API features for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.SecurityPostureConfig desired_security_posture_config = 124;</code>
     * @return \Google\Cloud\Container\V1\SecurityPostureConfig|null
     */
    public function getDesiredSecurityPostureConfig()
    {
        return $this->desired_security_posture_config;
    }

    public function hasDesiredSecurityPostureConfig()
    {
        return isset($this->desired_security_posture_config);
    }

    public function clearDesiredSecurityPostureConfig()
    {
        unset($this->desired_security_posture_config);
    }

    /**
     * Enable/Disable Security Posture API features for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.SecurityPostureConfig desired_security_posture_config = 124;</code>
     * @param \Google\Cloud\Container\V1\SecurityPostureConfig $var
     * @return $this
     */
    public function setDesiredSecurityPostureConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\SecurityPostureConfig::class);
        $this->desired_security_posture_config = $var;

        return $this;
    }

    /**
     * The desired network performance config.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;</code>
     * @return \Google\Cloud\Container\V1\NetworkConfig\ClusterNetworkPerformanceConfig|null
     */
    public function getDesiredNetworkPerformanceConfig()
    {
        return $this->desired_network_performance_config;
    }

    public function hasDesiredNetworkPerformanceConfig()
    {
        return isset($this->desired_network_performance_config);
    }

    public function clearDesiredNetworkPerformanceConfig()
    {
        unset($this->desired_network_performance_config);
    }

    /**
     * The desired network performance config.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;</code>
     * @param \Google\Cloud\Container\V1\NetworkConfig\ClusterNetworkPerformanceConfig $var
     * @return $this
     */
    public function setDesiredNetworkPerformanceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NetworkConfig\ClusterNetworkPerformanceConfig::class);
        $this->desired_network_performance_config = $var;

        return $this;
    }

    /**
     * Enable/Disable FQDN Network Policy for the cluster.
     *
     * Generated from protobuf field <code>optional bool desired_enable_fqdn_network_policy = 126;</code>
     * @return bool
     */
    public function getDesiredEnableFqdnNetworkPolicy()
    {
        return isset($this->desired_enable_fqdn_network_policy) ? $this->desired_enable_fqdn_network_policy : false;
    }

    public function hasDesiredEnableFqdnNetworkPolicy()
    {
        return isset($this->desired_enable_fqdn_network_policy);
    }

    public function clearDesiredEnableFqdnNetworkPolicy()
    {
        unset($this->desired_enable_fqdn_network_policy);
    }

    /**
     * Enable/Disable FQDN Network Policy for the cluster.
     *
     * Generated from protobuf field <code>optional bool desired_enable_fqdn_network_policy = 126;</code>
     * @param bool $var
     * @return $this
     */
    public function setDesiredEnableFqdnNetworkPolicy($var)
    {
        GPBUtil::checkBool($var);
        $this->desired_enable_fqdn_network_policy = $var;

        return $this;
    }

    /**
     * The desired workload policy configuration for the autopilot cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;</code>
     * @return \Google\Cloud\Container\V1\WorkloadPolicyConfig|null
     */
    public function getDesiredAutopilotWorkloadPolicyConfig()
    {
        return $this->desired_autopilot_workload_policy_config;
    }

    public function hasDesiredAutopilotWorkloadPolicyConfig()
    {
        return isset($this->desired_autopilot_workload_policy_config);
    }

    public function clearDesiredAutopilotWorkloadPolicyConfig()
    {
        unset($this->desired_autopilot_workload_policy_config);
    }

    /**
     * The desired workload policy configuration for the autopilot cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;</code>
     * @param \Google\Cloud\Container\V1\WorkloadPolicyConfig $var
     * @return $this
     */
    public function setDesiredAutopilotWorkloadPolicyConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\WorkloadPolicyConfig::class);
        $this->desired_autopilot_workload_policy_config = $var;

        return $this;
    }

    /**
     * Desired Beta APIs to be enabled for cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
     * @return \Google\Cloud\Container\V1\K8sBetaAPIConfig|null
     */
    public function getDesiredK8SBetaApis()
    {
        return $this->desired_k8s_beta_apis;
    }

    public function hasDesiredK8SBetaApis()
    {
        return isset($this->desired_k8s_beta_apis);
    }

    public function clearDesiredK8SBetaApis()
    {
        unset($this->desired_k8s_beta_apis);
    }

    /**
     * Desired Beta APIs to be enabled for cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
     * @param \Google\Cloud\Container\V1\K8sBetaAPIConfig $var
     * @return $this
     */
    public function setDesiredK8SBetaApis($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\K8sBetaAPIConfig::class);
        $this->desired_k8s_beta_apis = $var;

        return $this;
    }

    /**
     * The desired containerd config for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.ContainerdConfig desired_containerd_config = 134;</code>
     * @return \Google\Cloud\Container\V1\ContainerdConfig|null
     */
    public function getDesiredContainerdConfig()
    {
        return $this->desired_containerd_config;
    }

    public function hasDesiredContainerdConfig()
    {
        return isset($this->desired_containerd_config);
    }

    public function clearDesiredContainerdConfig()
    {
        unset($this->desired_containerd_config);
    }

    /**
     * The desired containerd config for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.ContainerdConfig desired_containerd_config = 134;</code>
     * @param \Google\Cloud\Container\V1\ContainerdConfig $var
     * @return $this
     */
    public function setDesiredContainerdConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ContainerdConfig::class);
        $this->desired_containerd_config = $var;

        return $this;
    }

    /**
     * Enable/Disable Multi-Networking for the cluster
     *
     * Generated from protobuf field <code>optional bool desired_enable_multi_networking = 135;</code>
     * @return bool
     */
    public function getDesiredEnableMultiNetworking()
    {
        return isset($this->desired_enable_multi_networking) ? $this->desired_enable_multi_networking : false;
    }

    public function hasDesiredEnableMultiNetworking()
    {
        return isset($this->desired_enable_multi_networking);
    }

    public function clearDesiredEnableMultiNetworking()
    {
        unset($this->desired_enable_multi_networking);
    }

    /**
     * Enable/Disable Multi-Networking for the cluster
     *
     * Generated from protobuf field <code>optional bool desired_enable_multi_networking = 135;</code>
     * @param bool $var
     * @return $this
     */
    public function setDesiredEnableMultiNetworking($var)
    {
        GPBUtil::checkBool($var);
        $this->desired_enable_multi_networking = $var;

        return $this;
    }

    /**
     * The desired resource manager tags that apply to all auto-provisioned node
     * pools in autopilot clusters and node auto-provisioning enabled clusters.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;</code>
     * @return \Google\Cloud\Container\V1\ResourceManagerTags|null
     */
    public function getDesiredNodePoolAutoConfigResourceManagerTags()
    {
        return $this->desired_node_pool_auto_config_resource_manager_tags;
    }

    public function hasDesiredNodePoolAutoConfigResourceManagerTags()
    {
        return isset($this->desired_node_pool_auto_config_resource_manager_tags);
    }

    public function clearDesiredNodePoolAutoConfigResourceManagerTags()
    {
        unset($this->desired_node_pool_auto_config_resource_manager_tags);
    }

    /**
     * The desired resource manager tags that apply to all auto-provisioned node
     * pools in autopilot clusters and node auto-provisioning enabled clusters.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;</code>
     * @param \Google\Cloud\Container\V1\ResourceManagerTags $var
     * @return $this
     */
    public function setDesiredNodePoolAutoConfigResourceManagerTags($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ResourceManagerTags::class);
        $this->desired_node_pool_auto_config_resource_manager_tags = $var;

        return $this;
    }

    /**
     * Specify the details of in-transit encryption.
     *
     * Generated from protobuf field <code>optional .google.container.v1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;</code>
     * @return int
     */
    public function getDesiredInTransitEncryptionConfig()
    {
        return isset($this->desired_in_transit_encryption_config) ? $this->desired_in_transit_encryption_config : 0;
    }

    public function hasDesiredInTransitEncryptionConfig()
    {
        return isset($this->desired_in_transit_encryption_config);
    }

    public function clearDesiredInTransitEncryptionConfig()
    {
        unset($this->desired_in_transit_encryption_config);
    }

    /**
     * Specify the details of in-transit encryption.
     *
     * Generated from protobuf field <code>optional .google.container.v1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;</code>
     * @param int $var
     * @return $this
     */
    public function setDesiredInTransitEncryptionConfig($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Container\V1\InTransitEncryptionConfig::class);
        $this->desired_in_transit_encryption_config = $var;

        return $this;
    }

    /**
     * Enable/Disable Cilium Clusterwide Network Policy for the cluster.
     *
     * Generated from protobuf field <code>optional bool desired_enable_cilium_clusterwide_network_policy = 138;</code>
     * @return bool
     */
    public function getDesiredEnableCiliumClusterwideNetworkPolicy()
    {
        return isset($this->desired_enable_cilium_clusterwide_network_policy) ? $this->desired_enable_cilium_clusterwide_network_policy : false;
    }

    public function hasDesiredEnableCiliumClusterwideNetworkPolicy()
    {
        return isset($this->desired_enable_cilium_clusterwide_network_policy);
    }

    public function clearDesiredEnableCiliumClusterwideNetworkPolicy()
    {
        unset($this->desired_enable_cilium_clusterwide_network_policy);
    }

    /**
     * Enable/Disable Cilium Clusterwide Network Policy for the cluster.
     *
     * Generated from protobuf field <code>optional bool desired_enable_cilium_clusterwide_network_policy = 138;</code>
     * @param bool $var
     * @return $this
     */
    public function setDesiredEnableCiliumClusterwideNetworkPolicy($var)
    {
        GPBUtil::checkBool($var);
        $this->desired_enable_cilium_clusterwide_network_policy = $var;

        return $this;
    }

    /**
     * The desired node kubelet config for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
     * @return \Google\Cloud\Container\V1\NodeKubeletConfig|null
     */
    public function getDesiredNodeKubeletConfig()
    {
        return $this->desired_node_kubelet_config;
    }

    public function hasDesiredNodeKubeletConfig()
    {
        return isset($this->desired_node_kubelet_config);
    }

    public function clearDesiredNodeKubeletConfig()
    {
        unset($this->desired_node_kubelet_config);
    }

    /**
     * The desired node kubelet config for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
     * @param \Google\Cloud\Container\V1\NodeKubeletConfig $var
     * @return $this
     */
    public function setDesiredNodeKubeletConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NodeKubeletConfig::class);
        $this->desired_node_kubelet_config = $var;

        return $this;
    }

    /**
     * The desired node kubelet config for all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     *
     * Generated from protobuf field <code>.google.container.v1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;</code>
     * @return \Google\Cloud\Container\V1\NodeKubeletConfig|null
     */
    public function getDesiredNodePoolAutoConfigKubeletConfig()
    {
        return $this->desired_node_pool_auto_config_kubelet_config;
    }

    public function hasDesiredNodePoolAutoConfigKubeletConfig()
    {
        return isset($this->desired_node_pool_auto_config_kubelet_config);
    }

    public function clearDesiredNodePoolAutoConfigKubeletConfig()
    {
        unset($this->desired_node_pool_auto_config_kubelet_config);
    }

    /**
     * The desired node kubelet config for all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     *
     * Generated from protobuf field <code>.google.container.v1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;</code>
     * @param \Google\Cloud\Container\V1\NodeKubeletConfig $var
     * @return $this
     */
    public function setDesiredNodePoolAutoConfigKubeletConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NodeKubeletConfig::class);
        $this->desired_node_pool_auto_config_kubelet_config = $var;

        return $this;
    }

}

