<?php
/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/analytics/data/v1alpha/analytics_data_api.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Analytics\Data\V1alpha\Gapic;

use Google\Analytics\Data\V1alpha\AudienceList;
use Google\Analytics\Data\V1alpha\CreateAudienceListRequest;
use Google\Analytics\Data\V1alpha\CreateRecurringAudienceListRequest;
use Google\Analytics\Data\V1alpha\CreateReportTaskRequest;
use Google\Analytics\Data\V1alpha\DateRange;
use Google\Analytics\Data\V1alpha\FilterExpression;
use Google\Analytics\Data\V1alpha\Funnel;
use Google\Analytics\Data\V1alpha\FunnelBreakdown;
use Google\Analytics\Data\V1alpha\FunnelNextAction;
use Google\Analytics\Data\V1alpha\GetAudienceListRequest;
use Google\Analytics\Data\V1alpha\GetRecurringAudienceListRequest;
use Google\Analytics\Data\V1alpha\GetReportTaskRequest;
use Google\Analytics\Data\V1alpha\ListAudienceListsRequest;
use Google\Analytics\Data\V1alpha\ListAudienceListsResponse;
use Google\Analytics\Data\V1alpha\ListRecurringAudienceListsRequest;
use Google\Analytics\Data\V1alpha\ListRecurringAudienceListsResponse;
use Google\Analytics\Data\V1alpha\ListReportTasksRequest;
use Google\Analytics\Data\V1alpha\ListReportTasksResponse;
use Google\Analytics\Data\V1alpha\QueryAudienceListRequest;
use Google\Analytics\Data\V1alpha\QueryAudienceListResponse;
use Google\Analytics\Data\V1alpha\QueryReportTaskRequest;
use Google\Analytics\Data\V1alpha\QueryReportTaskResponse;
use Google\Analytics\Data\V1alpha\RecurringAudienceList;
use Google\Analytics\Data\V1alpha\ReportTask;
use Google\Analytics\Data\V1alpha\RunFunnelReportRequest;
use Google\Analytics\Data\V1alpha\RunFunnelReportResponse;
use Google\Analytics\Data\V1alpha\Segment;
use Google\Analytics\Data\V1alpha\SheetExportAudienceListRequest;
use Google\Analytics\Data\V1alpha\SheetExportAudienceListResponse;
use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\LongRunning\Operation;

/**
 * Service Description: Google Analytics reporting data service.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
 * try {
 *     $formattedParent = $alphaAnalyticsDataClient->propertyName('[PROPERTY]');
 *     $audienceList = new AudienceList();
 *     $operationResponse = $alphaAnalyticsDataClient->createAudienceList($formattedParent, $audienceList);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $alphaAnalyticsDataClient->createAudienceList($formattedParent, $audienceList);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $alphaAnalyticsDataClient->resumeOperation($operationName, 'createAudienceList');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $alphaAnalyticsDataClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 *
 * @deprecated Please use the new service client {@see \Google\Analytics\Data\V1alpha\Client\AlphaAnalyticsDataClient}.
 */
class AlphaAnalyticsDataGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.analytics.data.v1alpha.AlphaAnalyticsData';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'analyticsdata.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'analyticsdata.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/analytics',
        'https://www.googleapis.com/auth/analytics.readonly',
        'https://www.googleapis.com/auth/drive',
        'https://www.googleapis.com/auth/drive.file',
        'https://www.googleapis.com/auth/spreadsheets',
    ];

    private static $audienceListNameTemplate;

    private static $propertyNameTemplate;

    private static $recurringAudienceListNameTemplate;

    private static $reportTaskNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/alpha_analytics_data_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/alpha_analytics_data_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/alpha_analytics_data_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/alpha_analytics_data_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAudienceListNameTemplate()
    {
        if (self::$audienceListNameTemplate == null) {
            self::$audienceListNameTemplate = new PathTemplate(
                'properties/{property}/audienceLists/{audience_list}'
            );
        }

        return self::$audienceListNameTemplate;
    }

    private static function getPropertyNameTemplate()
    {
        if (self::$propertyNameTemplate == null) {
            self::$propertyNameTemplate = new PathTemplate(
                'properties/{property}'
            );
        }

        return self::$propertyNameTemplate;
    }

    private static function getRecurringAudienceListNameTemplate()
    {
        if (self::$recurringAudienceListNameTemplate == null) {
            self::$recurringAudienceListNameTemplate = new PathTemplate(
                'properties/{property}/recurringAudienceLists/{recurring_audience_list}'
            );
        }

        return self::$recurringAudienceListNameTemplate;
    }

    private static function getReportTaskNameTemplate()
    {
        if (self::$reportTaskNameTemplate == null) {
            self::$reportTaskNameTemplate = new PathTemplate(
                'properties/{property}/reportTasks/{report_task}'
            );
        }

        return self::$reportTaskNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'audienceList' => self::getAudienceListNameTemplate(),
                'property' => self::getPropertyNameTemplate(),
                'recurringAudienceList' => self::getRecurringAudienceListNameTemplate(),
                'reportTask' => self::getReportTaskNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * audience_list resource.
     *
     * @param string $property
     * @param string $audienceList
     *
     * @return string The formatted audience_list resource.
     *
     * @experimental
     */
    public static function audienceListName($property, $audienceList)
    {
        return self::getAudienceListNameTemplate()->render([
            'property' => $property,
            'audience_list' => $audienceList,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a property
     * resource.
     *
     * @param string $property
     *
     * @return string The formatted property resource.
     *
     * @experimental
     */
    public static function propertyName($property)
    {
        return self::getPropertyNameTemplate()->render([
            'property' => $property,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * recurring_audience_list resource.
     *
     * @param string $property
     * @param string $recurringAudienceList
     *
     * @return string The formatted recurring_audience_list resource.
     *
     * @experimental
     */
    public static function recurringAudienceListName(
        $property,
        $recurringAudienceList
    ) {
        return self::getRecurringAudienceListNameTemplate()->render([
            'property' => $property,
            'recurring_audience_list' => $recurringAudienceList,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a report_task
     * resource.
     *
     * @param string $property
     * @param string $reportTask
     *
     * @return string The formatted report_task resource.
     *
     * @experimental
     */
    public static function reportTaskName($property, $reportTask)
    {
        return self::getReportTaskNameTemplate()->render([
            'property' => $property,
            'report_task' => $reportTask,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - audienceList: properties/{property}/audienceLists/{audience_list}
     * - property: properties/{property}
     * - recurringAudienceList: properties/{property}/recurringAudienceLists/{recurring_audience_list}
     * - reportTask: properties/{property}/reportTasks/{report_task}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     *
     * @experimental
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     *
     * @experimental
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'analyticsdata.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates an audience list for later retrieval. This method quickly returns
     * the audience list's resource name and initiates a long running asynchronous
     * request to form an audience list. To list the users in an audience list,
     * first create the audience list through this method and then send the
     * audience resource name to the `QueryAudienceList` method.
     *
     * See [Creating an Audience
     * List](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
     * for an introduction to Audience Lists with examples.
     *
     * An audience list is a snapshot of the users currently in the audience at
     * the time of audience list creation. Creating audience lists for one
     * audience on different days will return different results as users enter and
     * exit the audience.
     *
     * Audiences in Google Analytics 4 allow you to segment your users in the ways
     * that are important to your business. To learn more, see
     * https://support.google.com/analytics/answer/9267572. Audience lists contain
     * the users in each audience.
     *
     * This method is available at beta stability at
     * [audienceExports.create](https://developers.google.com/analytics/devguides/reporting/data/v1/rest/v1beta/properties.audienceExports/create).
     * To give your feedback on this API, complete the [Google Analytics Audience
     * Export API Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $formattedParent = $alphaAnalyticsDataClient->propertyName('[PROPERTY]');
     *     $audienceList = new AudienceList();
     *     $operationResponse = $alphaAnalyticsDataClient->createAudienceList($formattedParent, $audienceList);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $alphaAnalyticsDataClient->createAudienceList($formattedParent, $audienceList);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $alphaAnalyticsDataClient->resumeOperation($operationName, 'createAudienceList');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param string       $parent       Required. The parent resource where this audience list will be created.
     *                                   Format: `properties/{property}`
     * @param AudienceList $audienceList Required. The audience list to create.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createAudienceList(
        $parent,
        $audienceList,
        array $optionalArgs = []
    ) {
        $request = new CreateAudienceListRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAudienceList($audienceList);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateAudienceList',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a recurring audience list. Recurring audience lists produces new
     * audience lists each day. Audience lists are users in an audience at the
     * time of the list's creation.
     *
     * A recurring audience list ensures that you have audience list based on the
     * most recent data available for use each day. If you manually create
     * audience list, you don't know when an audience list based on an additional
     * day's data is available. This recurring audience list automates the
     * creation of an audience list when an additional day's data is available.
     * You will consume fewer quota tokens by using recurring audience list versus
     * manually creating audience list at various times of day trying to guess
     * when an additional day's data is ready.
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $formattedParent = $alphaAnalyticsDataClient->propertyName('[PROPERTY]');
     *     $recurringAudienceList = new RecurringAudienceList();
     *     $response = $alphaAnalyticsDataClient->createRecurringAudienceList($formattedParent, $recurringAudienceList);
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param string                $parent                Required. The parent resource where this recurring audience list will be
     *                                                     created. Format: `properties/{property}`
     * @param RecurringAudienceList $recurringAudienceList Required. The recurring audience list to create.
     * @param array                 $optionalArgs          {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Data\V1alpha\RecurringAudienceList
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createRecurringAudienceList(
        $parent,
        $recurringAudienceList,
        array $optionalArgs = []
    ) {
        $request = new CreateRecurringAudienceListRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRecurringAudienceList($recurringAudienceList);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateRecurringAudienceList',
            RecurringAudienceList::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Initiates the creation of a report task. This method quickly
     * returns a report task and initiates a long running
     * asynchronous request to form a customized report of your Google Analytics
     * event data.
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $formattedParent = $alphaAnalyticsDataClient->propertyName('[PROPERTY]');
     *     $reportTask = new ReportTask();
     *     $operationResponse = $alphaAnalyticsDataClient->createReportTask($formattedParent, $reportTask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $alphaAnalyticsDataClient->createReportTask($formattedParent, $reportTask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $alphaAnalyticsDataClient->resumeOperation($operationName, 'createReportTask');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The parent resource where this report task will be created.
     *                                 Format: `properties/{propertyId}`
     * @param ReportTask $reportTask   Required. The report task configuration to create.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createReportTask(
        $parent,
        $reportTask,
        array $optionalArgs = []
    ) {
        $request = new CreateReportTaskRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setReportTask($reportTask);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateReportTask',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets configuration metadata about a specific audience list. This method
     * can be used to understand an audience list after it has been created.
     *
     * See [Creating an Audience
     * List](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
     * for an introduction to Audience Lists with examples.
     *
     * This method is available at beta stability at
     * [audienceExports.get](https://developers.google.com/analytics/devguides/reporting/data/v1/rest/v1beta/properties.audienceExports/get).
     * To give your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $formattedName = $alphaAnalyticsDataClient->audienceListName('[PROPERTY]', '[AUDIENCE_LIST]');
     *     $response = $alphaAnalyticsDataClient->getAudienceList($formattedName);
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The audience list resource name.
     *                             Format: `properties/{property}/audienceLists/{audience_list}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Data\V1alpha\AudienceList
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getAudienceList($name, array $optionalArgs = [])
    {
        $request = new GetAudienceListRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAudienceList',
            AudienceList::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets configuration metadata about a specific recurring audience list. This
     * method can be used to understand a recurring audience list's state after it
     * has been created. For example, a recurring audience list resource will
     * generate audience list instances for each day, and this method can be used
     * to get the resource name of the most recent audience list instance.
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $formattedName = $alphaAnalyticsDataClient->recurringAudienceListName('[PROPERTY]', '[RECURRING_AUDIENCE_LIST]');
     *     $response = $alphaAnalyticsDataClient->getRecurringAudienceList($formattedName);
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The recurring audience list resource name.
     *                             Format:
     *                             `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Data\V1alpha\RecurringAudienceList
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getRecurringAudienceList($name, array $optionalArgs = [])
    {
        $request = new GetRecurringAudienceListRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetRecurringAudienceList',
            RecurringAudienceList::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets report metadata about a specific report task. After creating a report
     * task, use this method to check its processing state or inspect its
     * report definition.
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $formattedName = $alphaAnalyticsDataClient->reportTaskName('[PROPERTY]', '[REPORT_TASK]');
     *     $response = $alphaAnalyticsDataClient->getReportTask($formattedName);
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The report task resource name.
     *                             Format: `properties/{property}/reportTasks/{report_task}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Data\V1alpha\ReportTask
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getReportTask($name, array $optionalArgs = [])
    {
        $request = new GetReportTaskRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetReportTask',
            ReportTask::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists all audience lists for a property. This method can be used for you to
     * find and reuse existing audience lists rather than creating unnecessary new
     * audience lists. The same audience can have multiple audience lists that
     * represent the list of users that were in an audience on different days.
     *
     * See [Creating an Audience
     * List](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
     * for an introduction to Audience Lists with examples.
     *
     * This method is available at beta stability at
     * [audienceExports.list](https://developers.google.com/analytics/devguides/reporting/data/v1/rest/v1beta/properties.audienceExports/list).
     * To give your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $formattedParent = $alphaAnalyticsDataClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $alphaAnalyticsDataClient->listAudienceLists($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $alphaAnalyticsDataClient->listAudienceLists($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. All audience lists for this property will be listed in the
     *                             response. Format: `properties/{property}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listAudienceLists($parent, array $optionalArgs = [])
    {
        $request = new ListAudienceListsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListAudienceLists',
            $optionalArgs,
            ListAudienceListsResponse::class,
            $request
        );
    }

    /**
     * Lists all recurring audience lists for a property. This method can be used
     * for you to find and reuse existing recurring audience lists rather than
     * creating unnecessary new recurring audience lists. The same audience can
     * have multiple recurring audience lists that represent different dimension
     * combinations; for example, just the dimension `deviceId` or both the
     * dimensions `deviceId` and `userId`.
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $formattedParent = $alphaAnalyticsDataClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $alphaAnalyticsDataClient->listRecurringAudienceLists($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $alphaAnalyticsDataClient->listRecurringAudienceLists($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. All recurring audience lists for this property will be listed in
     *                             the response. Format: `properties/{property}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listRecurringAudienceLists(
        $parent,
        array $optionalArgs = []
    ) {
        $request = new ListRecurringAudienceListsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListRecurringAudienceLists',
            $optionalArgs,
            ListRecurringAudienceListsResponse::class,
            $request
        );
    }

    /**
     * Lists all report tasks for a property.
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $formattedParent = $alphaAnalyticsDataClient->propertyName('[PROPERTY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $alphaAnalyticsDataClient->listReportTasks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $alphaAnalyticsDataClient->listReportTasks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. All report tasks for this property will be listed in the
     *                             response. Format: `properties/{property}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listReportTasks($parent, array $optionalArgs = [])
    {
        $request = new ListReportTasksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListReportTasks',
            $optionalArgs,
            ListReportTasksResponse::class,
            $request
        );
    }

    /**
     * Retrieves an audience list of users. After creating an audience, the users
     * are not immediately available for listing. First, a request to
     * `CreateAudienceList` is necessary to create an audience list of users, and
     * then second, this method is used to retrieve the users in the audience
     * list.
     *
     * See [Creating an Audience
     * List](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
     * for an introduction to Audience Lists with examples.
     *
     * Audiences in Google Analytics 4 allow you to segment your users in the ways
     * that are important to your business. To learn more, see
     * https://support.google.com/analytics/answer/9267572.
     *
     * This method is available at beta stability at
     * [audienceExports.query](https://developers.google.com/analytics/devguides/reporting/data/v1/rest/v1beta/properties.audienceExports/query).
     * To give your feedback on this API, complete the [Google Analytics Audience
     * Export API Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $name = 'name';
     *     $response = $alphaAnalyticsDataClient->queryAudienceList($name);
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the audience list to retrieve users from.
     *                             Format: `properties/{property}/audienceLists/{audience_list}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $offset
     *           Optional. The row count of the start row. The first row is counted as row
     *           0.
     *
     *           When paging, the first request does not specify offset; or equivalently,
     *           sets offset to 0; the first request returns the first `limit` of rows. The
     *           second request sets offset to the `limit` of the first request; the second
     *           request returns the second `limit` of rows.
     *
     *           To learn more about this pagination parameter, see
     *           [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     *     @type int $limit
     *           Optional. The number of rows to return. If unspecified, 10,000 rows are
     *           returned. The API returns a maximum of 250,000 rows per request, no matter
     *           how many you ask for. `limit` must be positive.
     *
     *           The API can also return fewer rows than the requested `limit`, if there
     *           aren't as many dimension values as the `limit`.
     *
     *           To learn more about this pagination parameter, see
     *           [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Data\V1alpha\QueryAudienceListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function queryAudienceList($name, array $optionalArgs = [])
    {
        $request = new QueryAudienceListRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['offset'])) {
            $request->setOffset($optionalArgs['offset']);
        }

        if (isset($optionalArgs['limit'])) {
            $request->setLimit($optionalArgs['limit']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'QueryAudienceList',
            QueryAudienceListResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a report task's content. After requesting the `CreateReportTask`,
     * you are able to retrieve the report content once the report is
     * ACTIVE. This method will return an error if the report task's state is not
     * `ACTIVE`. A query response will return the tabular row & column values of
     * the report.
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $name = 'name';
     *     $response = $alphaAnalyticsDataClient->queryReportTask($name);
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The report source name.
     *                             Format: `properties/{property}/reportTasks/{report}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $offset
     *           Optional. The row count of the start row in the report. The first row is
     *           counted as row 0.
     *
     *           When paging, the first request does not specify offset; or equivalently,
     *           sets offset to 0; the first request returns the first `limit` of rows. The
     *           second request sets offset to the `limit` of the first request; the second
     *           request returns the second `limit` of rows.
     *
     *           To learn more about this pagination parameter, see
     *           [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     *     @type int $limit
     *           Optional. The number of rows to return from the report. If unspecified,
     *           10,000 rows are returned. The API returns a maximum of 250,000 rows per
     *           request, no matter how many you ask for. `limit` must be positive.
     *
     *           The API can also return fewer rows than the requested `limit`, if there
     *           aren't as many dimension values as the `limit`. The number of rows
     *           available to a QueryReportTaskRequest is further limited by the limit of
     *           the associated ReportTask. A query can retrieve at most ReportTask.limit
     *           rows. For example, if the ReportTask has a limit of 1,000, then a
     *           QueryReportTask request with offset=900 and limit=500 will return at most
     *           100 rows.
     *
     *           To learn more about this pagination parameter, see
     *           [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Data\V1alpha\QueryReportTaskResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function queryReportTask($name, array $optionalArgs = [])
    {
        $request = new QueryReportTaskRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['offset'])) {
            $request->setOffset($optionalArgs['offset']);
        }

        if (isset($optionalArgs['limit'])) {
            $request->setLimit($optionalArgs['limit']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'QueryReportTask',
            QueryReportTaskResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns a customized funnel report of your Google Analytics event data. The
     * data returned from the API is as a table with columns for the requested
     * dimensions and metrics.
     *
     * Funnel exploration lets you visualize the steps your users take to complete
     * a task and quickly see how well they are succeeding or failing at each
     * step. For example, how do prospects become shoppers and then become buyers?
     * How do one time buyers become repeat buyers? With this information, you can
     * improve inefficient or abandoned customer journeys. To learn more, see [GA4
     * Funnel Explorations](https://support.google.com/analytics/answer/9327974).
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the [Google Analytics Data API Funnel
     * Reporting
     * Feedback](https://docs.google.com/forms/d/e/1FAIpQLSdwOlQDJAUoBiIgUZZ3S_Lwi8gr7Bb0k1jhvc-DEg7Rol3UjA/viewform).
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $response = $alphaAnalyticsDataClient->runFunnelReport();
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $property
     *           Optional. A Google Analytics GA4 property identifier whose events are
     *           tracked. Specified in the URL path and not the body. To learn more, see
     *           [where to find your Property
     *           ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *           Within a batch request, this property should either be unspecified or
     *           consistent with the batch-level property.
     *
     *           Example: properties/1234
     *     @type DateRange[] $dateRanges
     *           Optional. Date ranges of data to read. If multiple date ranges are
     *           requested, each response row will contain a zero based date range index. If
     *           two date ranges overlap, the event data for the overlapping days is
     *           included in the response rows for both date ranges.
     *     @type Funnel $funnel
     *           Optional. The configuration of this request's funnel. This funnel
     *           configuration is required.
     *     @type FunnelBreakdown $funnelBreakdown
     *           Optional. If specified, this breakdown adds a dimension to the funnel table
     *           sub report response. This breakdown dimension expands each funnel step to
     *           the unique values of the breakdown dimension. For example, a breakdown by
     *           the `deviceCategory` dimension will create rows for `mobile`, `tablet`,
     *           `desktop`, and the total.
     *     @type FunnelNextAction $funnelNextAction
     *           Optional. If specified, next action adds a dimension to the funnel
     *           visualization sub report response. This next action dimension expands each
     *           funnel step to the unique values of the next action. For example a next
     *           action of the `eventName` dimension will create rows for several events
     *           (for example `session_start` & `click`) and the total.
     *
     *           Next action only supports `eventName` and most Page / Screen dimensions
     *           like `pageTitle` and `pagePath`.
     *     @type int $funnelVisualizationType
     *           Optional. The funnel visualization type controls the dimensions present in
     *           the funnel visualization sub report response. If not specified,
     *           `STANDARD_FUNNEL` is used.
     *           For allowed values, use constants defined on {@see \Google\Analytics\Data\V1alpha\RunFunnelReportRequest\FunnelVisualizationType}
     *     @type Segment[] $segments
     *           Optional. The configurations of segments. Segments are subsets of a
     *           property's data. In a funnel report with segments, the funnel is evaluated
     *           in each segment.
     *
     *           Each segment specified in this request
     *           produces a separate row in the response; in the response, each segment
     *           identified by its name.
     *
     *           The segments parameter is optional. Requests are limited to 4 segments.
     *     @type int $limit
     *           Optional. The number of rows to return. If unspecified, 10,000 rows are
     *           returned. The API returns a maximum of 250,000 rows per request, no matter
     *           how many you ask for. `limit` must be positive.
     *
     *           The API can also return fewer rows than the requested `limit`, if there
     *           aren't as many dimension values as the `limit`.
     *     @type FilterExpression $dimensionFilter
     *           Optional. Dimension filters allow you to ask for only specific dimension
     *           values in the report. To learn more, see [Creating a Report: Dimension
     *           Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     *           for examples. Metrics cannot be used in this filter.
     *     @type bool $returnPropertyQuota
     *           Optional. Toggles whether to return the current state of this Analytics
     *           Property's quota. Quota is returned in [PropertyQuota](#PropertyQuota).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Data\V1alpha\RunFunnelReportResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function runFunnelReport(array $optionalArgs = [])
    {
        $request = new RunFunnelReportRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['property'])) {
            $request->setProperty($optionalArgs['property']);
            $requestParamHeaders['property'] = $optionalArgs['property'];
        }

        if (isset($optionalArgs['dateRanges'])) {
            $request->setDateRanges($optionalArgs['dateRanges']);
        }

        if (isset($optionalArgs['funnel'])) {
            $request->setFunnel($optionalArgs['funnel']);
        }

        if (isset($optionalArgs['funnelBreakdown'])) {
            $request->setFunnelBreakdown($optionalArgs['funnelBreakdown']);
        }

        if (isset($optionalArgs['funnelNextAction'])) {
            $request->setFunnelNextAction($optionalArgs['funnelNextAction']);
        }

        if (isset($optionalArgs['funnelVisualizationType'])) {
            $request->setFunnelVisualizationType(
                $optionalArgs['funnelVisualizationType']
            );
        }

        if (isset($optionalArgs['segments'])) {
            $request->setSegments($optionalArgs['segments']);
        }

        if (isset($optionalArgs['limit'])) {
            $request->setLimit($optionalArgs['limit']);
        }

        if (isset($optionalArgs['dimensionFilter'])) {
            $request->setDimensionFilter($optionalArgs['dimensionFilter']);
        }

        if (isset($optionalArgs['returnPropertyQuota'])) {
            $request->setReturnPropertyQuota(
                $optionalArgs['returnPropertyQuota']
            );
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RunFunnelReport',
            RunFunnelReportResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Exports an audience list of users to a Google Sheet. After creating an
     * audience, the users are not immediately available for listing. First, a
     * request to `CreateAudienceList` is necessary to create an audience list of
     * users, and then second, this method is used to export those users in the
     * audience list to a Google Sheet.
     *
     * See [Creating an Audience
     * List](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
     * for an introduction to Audience Lists with examples.
     *
     * Audiences in Google Analytics 4 allow you to segment your users in the ways
     * that are important to your business. To learn more, see
     * https://support.google.com/analytics/answer/9267572.
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * Sample code:
     * ```
     * $alphaAnalyticsDataClient = new AlphaAnalyticsDataClient();
     * try {
     *     $formattedName = $alphaAnalyticsDataClient->audienceListName('[PROPERTY]', '[AUDIENCE_LIST]');
     *     $response = $alphaAnalyticsDataClient->sheetExportAudienceList($formattedName);
     * } finally {
     *     $alphaAnalyticsDataClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the audience list to retrieve users from.
     *                             Format: `properties/{property}/audienceLists/{audience_list}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $offset
     *           Optional. The row count of the start row. The first row is counted as row
     *           0.
     *
     *           When paging, the first request does not specify offset; or equivalently,
     *           sets offset to 0; the first request returns the first `limit` of rows. The
     *           second request sets offset to the `limit` of the first request; the second
     *           request returns the second `limit` of rows.
     *
     *           To learn more about this pagination parameter, see
     *           [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     *     @type int $limit
     *           Optional. The number of rows to return. If unspecified, 10,000 rows are
     *           returned. The API returns a maximum of 250,000 rows per request, no matter
     *           how many you ask for. `limit` must be positive.
     *
     *           The API can also return fewer rows than the requested `limit`, if there
     *           aren't as many dimension values as the `limit`.
     *
     *           To learn more about this pagination parameter, see
     *           [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Analytics\Data\V1alpha\SheetExportAudienceListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function sheetExportAudienceList($name, array $optionalArgs = [])
    {
        $request = new SheetExportAudienceListRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['offset'])) {
            $request->setOffset($optionalArgs['offset']);
        }

        if (isset($optionalArgs['limit'])) {
            $request->setLimit($optionalArgs['limit']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SheetExportAudienceList',
            SheetExportAudienceListResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }
}
