<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/support/v2/case.proto

namespace Google\Cloud\Support\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Case is an object that contains the details of a support case. It
 * contains fields for the time it was created, its priority, its
 * classification, and more. Cases can also have comments and attachments that
 * get added over time.
 * A case is parented by a Google Cloud organization or project.
 * Organizations are identified by a number, so the name of a case parented by
 * an organization would look like this:
 * ```
 * organizations/123/cases/456
 * ```
 * Projects have two unique identifiers, an ID and a number, and they look like
 * this:
 * ```
 * projects/abc/cases/456
 * ```
 * ```
 * projects/123/cases/456
 * ```
 * You can use either of them when calling the API. To learn more
 * about project identifiers, see [AIP-2510](https://google.aip.dev/cloud/2510).
 *
 * Generated from protobuf message <code>google.cloud.support.v2.Case</code>
 */
class PBCase extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name for the case.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * The short summary of the issue reported in this case.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     */
    protected $display_name = '';
    /**
     * A broad description of the issue.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     */
    protected $description = '';
    /**
     * The issue classification applicable to this case.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2.CaseClassification classification = 4;</code>
     */
    protected $classification = null;
    /**
     * The timezone of the user who created the support case.
     * It should be in a format IANA recognizes: https://www.iana.org/time-zones.
     * There is no additional validation done by the API.
     *
     * Generated from protobuf field <code>string time_zone = 8;</code>
     */
    protected $time_zone = '';
    /**
     * The email addresses to receive updates on this case.
     *
     * Generated from protobuf field <code>repeated string subscriber_email_addresses = 9;</code>
     */
    private $subscriber_email_addresses;
    /**
     * Output only. The current status of the support case.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2.Case.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The time this case was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time this case was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * The user who created the case.
     * Note: The name and email will be obfuscated if the case was created by
     * Google Support.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2.Actor creator = 15;</code>
     */
    protected $creator = null;
    /**
     * A user-supplied email address to send case update notifications for. This
     * should only be used in BYOID flows, where we cannot infer the user's email
     * address directly from their EUCs.
     *
     * Generated from protobuf field <code>string contact_email = 35;</code>
     */
    protected $contact_email = '';
    /**
     * Whether the case is currently escalated.
     *
     * Generated from protobuf field <code>bool escalated = 17;</code>
     */
    protected $escalated = false;
    /**
     * Whether this case was created for internal API testing and should not be
     * acted on by the support team.
     *
     * Generated from protobuf field <code>bool test_case = 19;</code>
     */
    protected $test_case = false;
    /**
     * The language the user has requested to receive support in. This should be a
     * BCP 47 language code (e.g., `"en"`, `"zh-CN"`, `"zh-TW"`, `"ja"`, `"ko"`).
     * If no language or an unsupported language is specified, this field defaults
     * to English (en).
     * Language selection during case creation may affect your available support
     * options. For a list of supported languages and their support working hours,
     * see: https://cloud.google.com/support/docs/language-working-hours
     *
     * Generated from protobuf field <code>string language_code = 23;</code>
     */
    protected $language_code = '';
    /**
     * The priority of this case.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2.Case.Priority priority = 32;</code>
     */
    protected $priority = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name for the case.
     *     @type string $display_name
     *           The short summary of the issue reported in this case.
     *     @type string $description
     *           A broad description of the issue.
     *     @type \Google\Cloud\Support\V2\CaseClassification $classification
     *           The issue classification applicable to this case.
     *     @type string $time_zone
     *           The timezone of the user who created the support case.
     *           It should be in a format IANA recognizes: https://www.iana.org/time-zones.
     *           There is no additional validation done by the API.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $subscriber_email_addresses
     *           The email addresses to receive updates on this case.
     *     @type int $state
     *           Output only. The current status of the support case.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time this case was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time this case was last updated.
     *     @type \Google\Cloud\Support\V2\Actor $creator
     *           The user who created the case.
     *           Note: The name and email will be obfuscated if the case was created by
     *           Google Support.
     *     @type string $contact_email
     *           A user-supplied email address to send case update notifications for. This
     *           should only be used in BYOID flows, where we cannot infer the user's email
     *           address directly from their EUCs.
     *     @type bool $escalated
     *           Whether the case is currently escalated.
     *     @type bool $test_case
     *           Whether this case was created for internal API testing and should not be
     *           acted on by the support team.
     *     @type string $language_code
     *           The language the user has requested to receive support in. This should be a
     *           BCP 47 language code (e.g., `"en"`, `"zh-CN"`, `"zh-TW"`, `"ja"`, `"ko"`).
     *           If no language or an unsupported language is specified, this field defaults
     *           to English (en).
     *           Language selection during case creation may affect your available support
     *           options. For a list of supported languages and their support working hours,
     *           see: https://cloud.google.com/support/docs/language-working-hours
     *     @type int $priority
     *           The priority of this case.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Support\V2\PBCase::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name for the case.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name for the case.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The short summary of the issue reported in this case.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * The short summary of the issue reported in this case.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * A broad description of the issue.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * A broad description of the issue.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * The issue classification applicable to this case.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2.CaseClassification classification = 4;</code>
     * @return \Google\Cloud\Support\V2\CaseClassification|null
     */
    public function getClassification()
    {
        return $this->classification;
    }

    public function hasClassification()
    {
        return isset($this->classification);
    }

    public function clearClassification()
    {
        unset($this->classification);
    }

    /**
     * The issue classification applicable to this case.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2.CaseClassification classification = 4;</code>
     * @param \Google\Cloud\Support\V2\CaseClassification $var
     * @return $this
     */
    public function setClassification($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Support\V2\CaseClassification::class);
        $this->classification = $var;

        return $this;
    }

    /**
     * The timezone of the user who created the support case.
     * It should be in a format IANA recognizes: https://www.iana.org/time-zones.
     * There is no additional validation done by the API.
     *
     * Generated from protobuf field <code>string time_zone = 8;</code>
     * @return string
     */
    public function getTimeZone()
    {
        return $this->time_zone;
    }

    /**
     * The timezone of the user who created the support case.
     * It should be in a format IANA recognizes: https://www.iana.org/time-zones.
     * There is no additional validation done by the API.
     *
     * Generated from protobuf field <code>string time_zone = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->time_zone = $var;

        return $this;
    }

    /**
     * The email addresses to receive updates on this case.
     *
     * Generated from protobuf field <code>repeated string subscriber_email_addresses = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSubscriberEmailAddresses()
    {
        return $this->subscriber_email_addresses;
    }

    /**
     * The email addresses to receive updates on this case.
     *
     * Generated from protobuf field <code>repeated string subscriber_email_addresses = 9;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSubscriberEmailAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->subscriber_email_addresses = $arr;

        return $this;
    }

    /**
     * Output only. The current status of the support case.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2.Case.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current status of the support case.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2.Case.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Support\V2\PBCase\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The time this case was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time this case was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time this case was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time this case was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * The user who created the case.
     * Note: The name and email will be obfuscated if the case was created by
     * Google Support.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2.Actor creator = 15;</code>
     * @return \Google\Cloud\Support\V2\Actor|null
     */
    public function getCreator()
    {
        return $this->creator;
    }

    public function hasCreator()
    {
        return isset($this->creator);
    }

    public function clearCreator()
    {
        unset($this->creator);
    }

    /**
     * The user who created the case.
     * Note: The name and email will be obfuscated if the case was created by
     * Google Support.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2.Actor creator = 15;</code>
     * @param \Google\Cloud\Support\V2\Actor $var
     * @return $this
     */
    public function setCreator($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Support\V2\Actor::class);
        $this->creator = $var;

        return $this;
    }

    /**
     * A user-supplied email address to send case update notifications for. This
     * should only be used in BYOID flows, where we cannot infer the user's email
     * address directly from their EUCs.
     *
     * Generated from protobuf field <code>string contact_email = 35;</code>
     * @return string
     */
    public function getContactEmail()
    {
        return $this->contact_email;
    }

    /**
     * A user-supplied email address to send case update notifications for. This
     * should only be used in BYOID flows, where we cannot infer the user's email
     * address directly from their EUCs.
     *
     * Generated from protobuf field <code>string contact_email = 35;</code>
     * @param string $var
     * @return $this
     */
    public function setContactEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->contact_email = $var;

        return $this;
    }

    /**
     * Whether the case is currently escalated.
     *
     * Generated from protobuf field <code>bool escalated = 17;</code>
     * @return bool
     */
    public function getEscalated()
    {
        return $this->escalated;
    }

    /**
     * Whether the case is currently escalated.
     *
     * Generated from protobuf field <code>bool escalated = 17;</code>
     * @param bool $var
     * @return $this
     */
    public function setEscalated($var)
    {
        GPBUtil::checkBool($var);
        $this->escalated = $var;

        return $this;
    }

    /**
     * Whether this case was created for internal API testing and should not be
     * acted on by the support team.
     *
     * Generated from protobuf field <code>bool test_case = 19;</code>
     * @return bool
     */
    public function getTestCase()
    {
        return $this->test_case;
    }

    /**
     * Whether this case was created for internal API testing and should not be
     * acted on by the support team.
     *
     * Generated from protobuf field <code>bool test_case = 19;</code>
     * @param bool $var
     * @return $this
     */
    public function setTestCase($var)
    {
        GPBUtil::checkBool($var);
        $this->test_case = $var;

        return $this;
    }

    /**
     * The language the user has requested to receive support in. This should be a
     * BCP 47 language code (e.g., `"en"`, `"zh-CN"`, `"zh-TW"`, `"ja"`, `"ko"`).
     * If no language or an unsupported language is specified, this field defaults
     * to English (en).
     * Language selection during case creation may affect your available support
     * options. For a list of supported languages and their support working hours,
     * see: https://cloud.google.com/support/docs/language-working-hours
     *
     * Generated from protobuf field <code>string language_code = 23;</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * The language the user has requested to receive support in. This should be a
     * BCP 47 language code (e.g., `"en"`, `"zh-CN"`, `"zh-TW"`, `"ja"`, `"ko"`).
     * If no language or an unsupported language is specified, this field defaults
     * to English (en).
     * Language selection during case creation may affect your available support
     * options. For a list of supported languages and their support working hours,
     * see: https://cloud.google.com/support/docs/language-working-hours
     *
     * Generated from protobuf field <code>string language_code = 23;</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

    /**
     * The priority of this case.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2.Case.Priority priority = 32;</code>
     * @return int
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * The priority of this case.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2.Case.Priority priority = 32;</code>
     * @param int $var
     * @return $this
     */
    public function setPriority($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Support\V2\PBCase\Priority::class);
        $this->priority = $var;

        return $this;
    }

}

