<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1/serving_config.proto

namespace Google\Cloud\DiscoveryEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configures metadata that is used to generate serving time results (e.g.
 * search results or recommendation predictions).
 * The ServingConfig is passed in the search and predict request and generates
 * results.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1.ServingConfig</code>
 */
class ServingConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. Fully qualified name
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $name = '';
    /**
     * Required. The human readable serving config display name. Used in Discovery
     * UI.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Required. Immutable. Specifies the solution type that a serving config can
     * be associated with.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SolutionType solution_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $solution_type = 0;
    /**
     * The id of the model to use at serving time.
     * Currently only RecommendationModels are supported.
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     * Required when [SolutionType][google.cloud.discoveryengine.v1.SolutionType]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string model_id = 4;</code>
     */
    protected $model_id = '';
    /**
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string diversity_level = 5;</code>
     */
    protected $diversity_level = '';
    /**
     * The ranking expression controls the customized ranking on retrieval
     * documents. To leverage this, document embedding is required. The ranking
     * expression setting in ServingConfig applies to all search requests served
     * by the serving config. However, if `SearchRequest.ranking_expression` is
     * specified, it overrides the ServingConfig ranking expression.
     * The ranking expression is a single function or multiple functions that are
     * joined by "+".
     *   * ranking_expression = function, { " + ", function };
     * Supported functions:
     *   * double * relevance_score
     *   * double * dotProduct(embedding_field_path)
     * Function variables:
     *   * `relevance_score`: pre-defined keywords, used for measure relevance
     *   between query and document.
     *   * `embedding_field_path`: the document embedding field
     *   used with query embedding vector.
     *   * `dotProduct`: embedding function between embedding_field_path and query
     *   embedding vector.
     *  Example ranking expression:
     *    If document has an embedding field doc_embedding, the ranking expression
     *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     *
     * Generated from protobuf field <code>string ranking_expression = 21;</code>
     */
    protected $ranking_expression = '';
    /**
     * Output only. ServingConfig created timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. ServingConfig updated timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Filter controls to use in serving path.
     * All triggered filter controls will be applied.
     * Filter controls must be in the same data store as the serving config.
     * Maximum of 20 filter controls.
     *
     * Generated from protobuf field <code>repeated string filter_control_ids = 11;</code>
     */
    private $filter_control_ids;
    /**
     * Boost controls to use in serving path.
     * All triggered boost controls will be applied.
     * Boost controls must be in the same data store as the serving config.
     * Maximum of 20 boost controls.
     *
     * Generated from protobuf field <code>repeated string boost_control_ids = 12;</code>
     */
    private $boost_control_ids;
    /**
     * IDs of the redirect controls. Only the first triggered redirect
     * action is applied, even if multiple apply. Maximum number of
     * specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string redirect_control_ids = 14;</code>
     */
    private $redirect_control_ids;
    /**
     * Condition synonyms specifications. If multiple synonyms conditions
     * match, all matching synonyms controls in the list will execute.
     * Maximum number of specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string synonyms_control_ids = 15;</code>
     */
    private $synonyms_control_ids;
    /**
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list
     * will execute. Maximum number of specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string oneway_synonyms_control_ids = 16;</code>
     */
    private $oneway_synonyms_control_ids;
    /**
     * Condition do not associate specifications. If multiple do not
     * associate conditions match, all matching do not associate controls in
     * the list will execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string dissociate_control_ids = 17;</code>
     */
    private $dissociate_control_ids;
    /**
     * Condition replacement specifications.
     * Applied according to the order in the list.
     * A previously replaced term can not be re-replaced.
     * Maximum number of specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string replacement_control_ids = 18;</code>
     */
    private $replacement_control_ids;
    /**
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     *
     * Generated from protobuf field <code>repeated string ignore_control_ids = 19;</code>
     */
    private $ignore_control_ids;
    /**
     * Condition promote specifications.
     * Maximum number of specifications is 100.
     *
     * Generated from protobuf field <code>repeated string promote_control_ids = 26;</code>
     */
    private $promote_control_ids;
    protected $vertical_config;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\DiscoveryEngine\V1\ServingConfig\MediaConfig $media_config
     *           The MediaConfig of the serving configuration.
     *     @type \Google\Cloud\DiscoveryEngine\V1\ServingConfig\GenericConfig $generic_config
     *           The GenericConfig of the serving configuration.
     *     @type string $name
     *           Immutable. Fully qualified name
     *           `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
     *     @type string $display_name
     *           Required. The human readable serving config display name. Used in Discovery
     *           UI.
     *           This field must be a UTF-8 encoded string with a length limit of 128
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type int $solution_type
     *           Required. Immutable. Specifies the solution type that a serving config can
     *           be associated with.
     *     @type string $model_id
     *           The id of the model to use at serving time.
     *           Currently only RecommendationModels are supported.
     *           Can be changed but only to a compatible model (e.g.
     *           others-you-may-like CTR to others-you-may-like CVR).
     *           Required when [SolutionType][google.cloud.discoveryengine.v1.SolutionType]
     *           is
     *           [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *     @type string $diversity_level
     *           How much diversity to use in recommendation model results e.g.
     *           `medium-diversity` or `high-diversity`. Currently supported values:
     *           * `no-diversity`
     *           * `low-diversity`
     *           * `medium-diversity`
     *           * `high-diversity`
     *           * `auto-diversity`
     *           If not specified, we choose default based on recommendation model
     *           type. Default value: `no-diversity`.
     *           Can only be set if
     *           [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     *           [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *     @type string $ranking_expression
     *           The ranking expression controls the customized ranking on retrieval
     *           documents. To leverage this, document embedding is required. The ranking
     *           expression setting in ServingConfig applies to all search requests served
     *           by the serving config. However, if `SearchRequest.ranking_expression` is
     *           specified, it overrides the ServingConfig ranking expression.
     *           The ranking expression is a single function or multiple functions that are
     *           joined by "+".
     *             * ranking_expression = function, { " + ", function };
     *           Supported functions:
     *             * double * relevance_score
     *             * double * dotProduct(embedding_field_path)
     *           Function variables:
     *             * `relevance_score`: pre-defined keywords, used for measure relevance
     *             between query and document.
     *             * `embedding_field_path`: the document embedding field
     *             used with query embedding vector.
     *             * `dotProduct`: embedding function between embedding_field_path and query
     *             embedding vector.
     *            Example ranking expression:
     *              If document has an embedding field doc_embedding, the ranking expression
     *              could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. ServingConfig created timestamp.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. ServingConfig updated timestamp.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $filter_control_ids
     *           Filter controls to use in serving path.
     *           All triggered filter controls will be applied.
     *           Filter controls must be in the same data store as the serving config.
     *           Maximum of 20 filter controls.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $boost_control_ids
     *           Boost controls to use in serving path.
     *           All triggered boost controls will be applied.
     *           Boost controls must be in the same data store as the serving config.
     *           Maximum of 20 boost controls.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $redirect_control_ids
     *           IDs of the redirect controls. Only the first triggered redirect
     *           action is applied, even if multiple apply. Maximum number of
     *           specifications is 100.
     *           Can only be set if
     *           [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $synonyms_control_ids
     *           Condition synonyms specifications. If multiple synonyms conditions
     *           match, all matching synonyms controls in the list will execute.
     *           Maximum number of specifications is 100.
     *           Can only be set if
     *           [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $oneway_synonyms_control_ids
     *           Condition oneway synonyms specifications. If multiple oneway synonyms
     *           conditions match, all matching oneway synonyms controls in the list
     *           will execute. Maximum number of specifications is 100.
     *           Can only be set if
     *           [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $dissociate_control_ids
     *           Condition do not associate specifications. If multiple do not
     *           associate conditions match, all matching do not associate controls in
     *           the list will execute.
     *           Order does not matter.
     *           Maximum number of specifications is 100.
     *           Can only be set if
     *           [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $replacement_control_ids
     *           Condition replacement specifications.
     *           Applied according to the order in the list.
     *           A previously replaced term can not be re-replaced.
     *           Maximum number of specifications is 100.
     *           Can only be set if
     *           [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $ignore_control_ids
     *           Condition ignore specifications. If multiple ignore
     *           conditions match, all matching ignore controls in the list will
     *           execute.
     *           Order does not matter.
     *           Maximum number of specifications is 100.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $promote_control_ids
     *           Condition promote specifications.
     *           Maximum number of specifications is 100.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1\ServingConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * The MediaConfig of the serving configuration.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.ServingConfig.MediaConfig media_config = 7;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\ServingConfig\MediaConfig|null
     */
    public function getMediaConfig()
    {
        return $this->readOneof(7);
    }

    public function hasMediaConfig()
    {
        return $this->hasOneof(7);
    }

    /**
     * The MediaConfig of the serving configuration.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.ServingConfig.MediaConfig media_config = 7;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\ServingConfig\MediaConfig $var
     * @return $this
     */
    public function setMediaConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\ServingConfig\MediaConfig::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * The GenericConfig of the serving configuration.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.ServingConfig.GenericConfig generic_config = 10;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\ServingConfig\GenericConfig|null
     */
    public function getGenericConfig()
    {
        return $this->readOneof(10);
    }

    public function hasGenericConfig()
    {
        return $this->hasOneof(10);
    }

    /**
     * The GenericConfig of the serving configuration.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.ServingConfig.GenericConfig generic_config = 10;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\ServingConfig\GenericConfig $var
     * @return $this
     */
    public function setGenericConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\ServingConfig\GenericConfig::class);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * Immutable. Fully qualified name
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Immutable. Fully qualified name
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The human readable serving config display name. Used in Discovery
     * UI.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The human readable serving config display name. Used in Discovery
     * UI.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Required. Immutable. Specifies the solution type that a serving config can
     * be associated with.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SolutionType solution_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getSolutionType()
    {
        return $this->solution_type;
    }

    /**
     * Required. Immutable. Specifies the solution type that a serving config can
     * be associated with.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SolutionType solution_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setSolutionType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DiscoveryEngine\V1\SolutionType::class);
        $this->solution_type = $var;

        return $this;
    }

    /**
     * The id of the model to use at serving time.
     * Currently only RecommendationModels are supported.
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     * Required when [SolutionType][google.cloud.discoveryengine.v1.SolutionType]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string model_id = 4;</code>
     * @return string
     */
    public function getModelId()
    {
        return $this->model_id;
    }

    /**
     * The id of the model to use at serving time.
     * Currently only RecommendationModels are supported.
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     * Required when [SolutionType][google.cloud.discoveryengine.v1.SolutionType]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string model_id = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setModelId($var)
    {
        GPBUtil::checkString($var, True);
        $this->model_id = $var;

        return $this;
    }

    /**
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string diversity_level = 5;</code>
     * @return string
     */
    public function getDiversityLevel()
    {
        return $this->diversity_level;
    }

    /**
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string diversity_level = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDiversityLevel($var)
    {
        GPBUtil::checkString($var, True);
        $this->diversity_level = $var;

        return $this;
    }

    /**
     * The ranking expression controls the customized ranking on retrieval
     * documents. To leverage this, document embedding is required. The ranking
     * expression setting in ServingConfig applies to all search requests served
     * by the serving config. However, if `SearchRequest.ranking_expression` is
     * specified, it overrides the ServingConfig ranking expression.
     * The ranking expression is a single function or multiple functions that are
     * joined by "+".
     *   * ranking_expression = function, { " + ", function };
     * Supported functions:
     *   * double * relevance_score
     *   * double * dotProduct(embedding_field_path)
     * Function variables:
     *   * `relevance_score`: pre-defined keywords, used for measure relevance
     *   between query and document.
     *   * `embedding_field_path`: the document embedding field
     *   used with query embedding vector.
     *   * `dotProduct`: embedding function between embedding_field_path and query
     *   embedding vector.
     *  Example ranking expression:
     *    If document has an embedding field doc_embedding, the ranking expression
     *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     *
     * Generated from protobuf field <code>string ranking_expression = 21;</code>
     * @return string
     */
    public function getRankingExpression()
    {
        return $this->ranking_expression;
    }

    /**
     * The ranking expression controls the customized ranking on retrieval
     * documents. To leverage this, document embedding is required. The ranking
     * expression setting in ServingConfig applies to all search requests served
     * by the serving config. However, if `SearchRequest.ranking_expression` is
     * specified, it overrides the ServingConfig ranking expression.
     * The ranking expression is a single function or multiple functions that are
     * joined by "+".
     *   * ranking_expression = function, { " + ", function };
     * Supported functions:
     *   * double * relevance_score
     *   * double * dotProduct(embedding_field_path)
     * Function variables:
     *   * `relevance_score`: pre-defined keywords, used for measure relevance
     *   between query and document.
     *   * `embedding_field_path`: the document embedding field
     *   used with query embedding vector.
     *   * `dotProduct`: embedding function between embedding_field_path and query
     *   embedding vector.
     *  Example ranking expression:
     *    If document has an embedding field doc_embedding, the ranking expression
     *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     *
     * Generated from protobuf field <code>string ranking_expression = 21;</code>
     * @param string $var
     * @return $this
     */
    public function setRankingExpression($var)
    {
        GPBUtil::checkString($var, True);
        $this->ranking_expression = $var;

        return $this;
    }

    /**
     * Output only. ServingConfig created timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. ServingConfig created timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. ServingConfig updated timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. ServingConfig updated timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Filter controls to use in serving path.
     * All triggered filter controls will be applied.
     * Filter controls must be in the same data store as the serving config.
     * Maximum of 20 filter controls.
     *
     * Generated from protobuf field <code>repeated string filter_control_ids = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFilterControlIds()
    {
        return $this->filter_control_ids;
    }

    /**
     * Filter controls to use in serving path.
     * All triggered filter controls will be applied.
     * Filter controls must be in the same data store as the serving config.
     * Maximum of 20 filter controls.
     *
     * Generated from protobuf field <code>repeated string filter_control_ids = 11;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFilterControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->filter_control_ids = $arr;

        return $this;
    }

    /**
     * Boost controls to use in serving path.
     * All triggered boost controls will be applied.
     * Boost controls must be in the same data store as the serving config.
     * Maximum of 20 boost controls.
     *
     * Generated from protobuf field <code>repeated string boost_control_ids = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBoostControlIds()
    {
        return $this->boost_control_ids;
    }

    /**
     * Boost controls to use in serving path.
     * All triggered boost controls will be applied.
     * Boost controls must be in the same data store as the serving config.
     * Maximum of 20 boost controls.
     *
     * Generated from protobuf field <code>repeated string boost_control_ids = 12;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBoostControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->boost_control_ids = $arr;

        return $this;
    }

    /**
     * IDs of the redirect controls. Only the first triggered redirect
     * action is applied, even if multiple apply. Maximum number of
     * specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string redirect_control_ids = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRedirectControlIds()
    {
        return $this->redirect_control_ids;
    }

    /**
     * IDs of the redirect controls. Only the first triggered redirect
     * action is applied, even if multiple apply. Maximum number of
     * specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string redirect_control_ids = 14;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRedirectControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->redirect_control_ids = $arr;

        return $this;
    }

    /**
     * Condition synonyms specifications. If multiple synonyms conditions
     * match, all matching synonyms controls in the list will execute.
     * Maximum number of specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string synonyms_control_ids = 15;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSynonymsControlIds()
    {
        return $this->synonyms_control_ids;
    }

    /**
     * Condition synonyms specifications. If multiple synonyms conditions
     * match, all matching synonyms controls in the list will execute.
     * Maximum number of specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string synonyms_control_ids = 15;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSynonymsControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->synonyms_control_ids = $arr;

        return $this;
    }

    /**
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list
     * will execute. Maximum number of specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string oneway_synonyms_control_ids = 16;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOnewaySynonymsControlIds()
    {
        return $this->oneway_synonyms_control_ids;
    }

    /**
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list
     * will execute. Maximum number of specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string oneway_synonyms_control_ids = 16;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOnewaySynonymsControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->oneway_synonyms_control_ids = $arr;

        return $this;
    }

    /**
     * Condition do not associate specifications. If multiple do not
     * associate conditions match, all matching do not associate controls in
     * the list will execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string dissociate_control_ids = 17;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDissociateControlIds()
    {
        return $this->dissociate_control_ids;
    }

    /**
     * Condition do not associate specifications. If multiple do not
     * associate conditions match, all matching do not associate controls in
     * the list will execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string dissociate_control_ids = 17;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDissociateControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->dissociate_control_ids = $arr;

        return $this;
    }

    /**
     * Condition replacement specifications.
     * Applied according to the order in the list.
     * A previously replaced term can not be re-replaced.
     * Maximum number of specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string replacement_control_ids = 18;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReplacementControlIds()
    {
        return $this->replacement_control_ids;
    }

    /**
     * Condition replacement specifications.
     * Applied according to the order in the list.
     * A previously replaced term can not be re-replaced.
     * Maximum number of specifications is 100.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string replacement_control_ids = 18;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReplacementControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->replacement_control_ids = $arr;

        return $this;
    }

    /**
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     *
     * Generated from protobuf field <code>repeated string ignore_control_ids = 19;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIgnoreControlIds()
    {
        return $this->ignore_control_ids;
    }

    /**
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     *
     * Generated from protobuf field <code>repeated string ignore_control_ids = 19;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIgnoreControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->ignore_control_ids = $arr;

        return $this;
    }

    /**
     * Condition promote specifications.
     * Maximum number of specifications is 100.
     *
     * Generated from protobuf field <code>repeated string promote_control_ids = 26;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPromoteControlIds()
    {
        return $this->promote_control_ids;
    }

    /**
     * Condition promote specifications.
     * Maximum number of specifications is 100.
     *
     * Generated from protobuf field <code>repeated string promote_control_ids = 26;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPromoteControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->promote_control_ids = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getVerticalConfig()
    {
        return $this->whichOneof("vertical_config");
    }

}

