<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/chronicle/v1/rule.proto

namespace Google\Cloud\Chronicle\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The Rule resource represents a user-created rule.
 * NEXT TAG: 21
 *
 * Generated from protobuf message <code>google.cloud.chronicle.v1.Rule</code>
 */
class Rule extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. Full resource name for the rule.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The revision ID of the rule.
     * A new revision is created whenever the rule text is changed in any way.
     * Format: `v_{10 digits}_{9 digits}`
     * Populated in REVISION_METADATA_ONLY view and FULL view.
     *
     * Generated from protobuf field <code>string revision_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $revision_id = '';
    /**
     * Output only. Display name of the rule.
     * Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $display_name = '';
    /**
     * The YARA-L content of the rule.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>string text = 4;</code>
     */
    protected $text = '';
    /**
     * Output only. The author of the rule. Extracted from the meta section of
     * text. Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>string author = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $author = '';
    /**
     * Output only. The severity of the rule as specified in the meta section of
     * text. Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.Severity severity = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $severity = null;
    /**
     * Output only. Additional metadata specified in the meta section of text.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $metadata;
    /**
     * Output only. The timestamp of when the rule was created.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp of when the rule revision was created.
     * Populated in FULL, REVISION_METADATA_ONLY views.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp revision_create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $revision_create_time = null;
    /**
     * Output only. The current compilation state of the rule.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.Rule.CompilationState compilation_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $compilation_state = 0;
    /**
     * Output only. User-facing type of the rule. Extracted from the events
     * section of rule text. Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.RuleType type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $type = 0;
    /**
     * Output only. Resource names of the reference lists used in this rule.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>repeated string reference_lists = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $reference_lists;
    /**
     * Output only. The run frequencies that are allowed for the rule.
     * Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.RunFrequency allowed_run_frequencies = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $allowed_run_frequencies;
    /**
     * The etag for this rule.
     * If this is provided on update, the request will succeed if and only if it
     * matches the server-computed value, and will fail with an ABORTED error
     * otherwise.
     * Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>string etag = 15;</code>
     */
    protected $etag = '';
    /**
     * Resource name of the DataAccessScope bound to this rule.
     * Populated in BASIC view and FULL view.
     * If reference lists are used in the rule, validations will be performed
     * against this scope to ensure that the reference lists are compatible with
     * both the user's and the rule's scopes.
     * The scope should be in the format:
     * `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope}`.
     *
     * Generated from protobuf field <code>string scope = 16 [(.google.api.resource_reference) = {</code>
     */
    protected $scope = '';
    /**
     * Output only. A list of a rule's corresponding compilation diagnostic
     * messages such as compilation errors and compilation warnings. Populated in
     * FULL view.
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.CompilationDiagnostic compilation_diagnostics = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $compilation_diagnostics;
    /**
     * Output only. Indicate the rule can run in near real time live rule.
     * If this is true, the rule uses the near real time live rule when the run
     * frequency is set to LIVE.
     *
     * Generated from protobuf field <code>bool near_real_time_live_rule_eligible = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $near_real_time_live_rule_eligible = false;
    /**
     * Output only. The set of inputs used in the rule. For example, if the rule
     * uses $e.principal.hostname, then the uses_udm field will be true.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.InputsUsed inputs_used = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $inputs_used = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. Full resource name for the rule.
     *           Format:
     *           `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
     *     @type string $revision_id
     *           Output only. The revision ID of the rule.
     *           A new revision is created whenever the rule text is changed in any way.
     *           Format: `v_{10 digits}_{9 digits}`
     *           Populated in REVISION_METADATA_ONLY view and FULL view.
     *     @type string $display_name
     *           Output only. Display name of the rule.
     *           Populated in BASIC view and FULL view.
     *     @type string $text
     *           The YARA-L content of the rule.
     *           Populated in FULL view.
     *     @type string $author
     *           Output only. The author of the rule. Extracted from the meta section of
     *           text. Populated in BASIC view and FULL view.
     *     @type \Google\Cloud\Chronicle\V1\Severity $severity
     *           Output only. The severity of the rule as specified in the meta section of
     *           text. Populated in BASIC view and FULL view.
     *     @type array|\Google\Protobuf\Internal\MapField $metadata
     *           Output only. Additional metadata specified in the meta section of text.
     *           Populated in FULL view.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp of when the rule was created.
     *           Populated in FULL view.
     *     @type \Google\Protobuf\Timestamp $revision_create_time
     *           Output only. The timestamp of when the rule revision was created.
     *           Populated in FULL, REVISION_METADATA_ONLY views.
     *     @type int $compilation_state
     *           Output only. The current compilation state of the rule.
     *           Populated in FULL view.
     *     @type int $type
     *           Output only. User-facing type of the rule. Extracted from the events
     *           section of rule text. Populated in BASIC view and FULL view.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $reference_lists
     *           Output only. Resource names of the reference lists used in this rule.
     *           Populated in FULL view.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $allowed_run_frequencies
     *           Output only. The run frequencies that are allowed for the rule.
     *           Populated in BASIC view and FULL view.
     *     @type string $etag
     *           The etag for this rule.
     *           If this is provided on update, the request will succeed if and only if it
     *           matches the server-computed value, and will fail with an ABORTED error
     *           otherwise.
     *           Populated in BASIC view and FULL view.
     *     @type string $scope
     *           Resource name of the DataAccessScope bound to this rule.
     *           Populated in BASIC view and FULL view.
     *           If reference lists are used in the rule, validations will be performed
     *           against this scope to ensure that the reference lists are compatible with
     *           both the user's and the rule's scopes.
     *           The scope should be in the format:
     *           `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope}`.
     *     @type array<\Google\Cloud\Chronicle\V1\CompilationDiagnostic>|\Google\Protobuf\Internal\RepeatedField $compilation_diagnostics
     *           Output only. A list of a rule's corresponding compilation diagnostic
     *           messages such as compilation errors and compilation warnings. Populated in
     *           FULL view.
     *     @type bool $near_real_time_live_rule_eligible
     *           Output only. Indicate the rule can run in near real time live rule.
     *           If this is true, the rule uses the near real time live rule when the run
     *           frequency is set to LIVE.
     *     @type \Google\Cloud\Chronicle\V1\InputsUsed $inputs_used
     *           Output only. The set of inputs used in the rule. For example, if the rule
     *           uses $e.principal.hostname, then the uses_udm field will be true.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Chronicle\V1\Rule::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. Full resource name for the rule.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. Full resource name for the rule.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The revision ID of the rule.
     * A new revision is created whenever the rule text is changed in any way.
     * Format: `v_{10 digits}_{9 digits}`
     * Populated in REVISION_METADATA_ONLY view and FULL view.
     *
     * Generated from protobuf field <code>string revision_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getRevisionId()
    {
        return $this->revision_id;
    }

    /**
     * Output only. The revision ID of the rule.
     * A new revision is created whenever the rule text is changed in any way.
     * Format: `v_{10 digits}_{9 digits}`
     * Populated in REVISION_METADATA_ONLY view and FULL view.
     *
     * Generated from protobuf field <code>string revision_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setRevisionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->revision_id = $var;

        return $this;
    }

    /**
     * Output only. Display name of the rule.
     * Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Output only. Display name of the rule.
     * Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The YARA-L content of the rule.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>string text = 4;</code>
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }

    /**
     * The YARA-L content of the rule.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>string text = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setText($var)
    {
        GPBUtil::checkString($var, True);
        $this->text = $var;

        return $this;
    }

    /**
     * Output only. The author of the rule. Extracted from the meta section of
     * text. Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>string author = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getAuthor()
    {
        return $this->author;
    }

    /**
     * Output only. The author of the rule. Extracted from the meta section of
     * text. Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>string author = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setAuthor($var)
    {
        GPBUtil::checkString($var, True);
        $this->author = $var;

        return $this;
    }

    /**
     * Output only. The severity of the rule as specified in the meta section of
     * text. Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.Severity severity = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Chronicle\V1\Severity|null
     */
    public function getSeverity()
    {
        return $this->severity;
    }

    public function hasSeverity()
    {
        return isset($this->severity);
    }

    public function clearSeverity()
    {
        unset($this->severity);
    }

    /**
     * Output only. The severity of the rule as specified in the meta section of
     * text. Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.Severity severity = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Chronicle\V1\Severity $var
     * @return $this
     */
    public function setSeverity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Chronicle\V1\Severity::class);
        $this->severity = $var;

        return $this;
    }

    /**
     * Output only. Additional metadata specified in the meta section of text.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * Output only. Additional metadata specified in the meta section of text.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setMetadata($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->metadata = $arr;

        return $this;
    }

    /**
     * Output only. The timestamp of when the rule was created.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp of when the rule was created.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp of when the rule revision was created.
     * Populated in FULL, REVISION_METADATA_ONLY views.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp revision_create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getRevisionCreateTime()
    {
        return $this->revision_create_time;
    }

    public function hasRevisionCreateTime()
    {
        return isset($this->revision_create_time);
    }

    public function clearRevisionCreateTime()
    {
        unset($this->revision_create_time);
    }

    /**
     * Output only. The timestamp of when the rule revision was created.
     * Populated in FULL, REVISION_METADATA_ONLY views.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp revision_create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setRevisionCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->revision_create_time = $var;

        return $this;
    }

    /**
     * Output only. The current compilation state of the rule.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.Rule.CompilationState compilation_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getCompilationState()
    {
        return $this->compilation_state;
    }

    /**
     * Output only. The current compilation state of the rule.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.Rule.CompilationState compilation_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setCompilationState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Chronicle\V1\Rule\CompilationState::class);
        $this->compilation_state = $var;

        return $this;
    }

    /**
     * Output only. User-facing type of the rule. Extracted from the events
     * section of rule text. Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.RuleType type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Output only. User-facing type of the rule. Extracted from the events
     * section of rule text. Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.RuleType type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Chronicle\V1\RuleType::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Output only. Resource names of the reference lists used in this rule.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>repeated string reference_lists = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReferenceLists()
    {
        return $this->reference_lists;
    }

    /**
     * Output only. Resource names of the reference lists used in this rule.
     * Populated in FULL view.
     *
     * Generated from protobuf field <code>repeated string reference_lists = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReferenceLists($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->reference_lists = $arr;

        return $this;
    }

    /**
     * Output only. The run frequencies that are allowed for the rule.
     * Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.RunFrequency allowed_run_frequencies = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowedRunFrequencies()
    {
        return $this->allowed_run_frequencies;
    }

    /**
     * Output only. The run frequencies that are allowed for the rule.
     * Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.RunFrequency allowed_run_frequencies = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowedRunFrequencies($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Chronicle\V1\RunFrequency::class);
        $this->allowed_run_frequencies = $arr;

        return $this;
    }

    /**
     * The etag for this rule.
     * If this is provided on update, the request will succeed if and only if it
     * matches the server-computed value, and will fail with an ABORTED error
     * otherwise.
     * Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>string etag = 15;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * The etag for this rule.
     * If this is provided on update, the request will succeed if and only if it
     * matches the server-computed value, and will fail with an ABORTED error
     * otherwise.
     * Populated in BASIC view and FULL view.
     *
     * Generated from protobuf field <code>string etag = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Resource name of the DataAccessScope bound to this rule.
     * Populated in BASIC view and FULL view.
     * If reference lists are used in the rule, validations will be performed
     * against this scope to ensure that the reference lists are compatible with
     * both the user's and the rule's scopes.
     * The scope should be in the format:
     * `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope}`.
     *
     * Generated from protobuf field <code>string scope = 16 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * Resource name of the DataAccessScope bound to this rule.
     * Populated in BASIC view and FULL view.
     * If reference lists are used in the rule, validations will be performed
     * against this scope to ensure that the reference lists are compatible with
     * both the user's and the rule's scopes.
     * The scope should be in the format:
     * `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope}`.
     *
     * Generated from protobuf field <code>string scope = 16 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkString($var, True);
        $this->scope = $var;

        return $this;
    }

    /**
     * Output only. A list of a rule's corresponding compilation diagnostic
     * messages such as compilation errors and compilation warnings. Populated in
     * FULL view.
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.CompilationDiagnostic compilation_diagnostics = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCompilationDiagnostics()
    {
        return $this->compilation_diagnostics;
    }

    /**
     * Output only. A list of a rule's corresponding compilation diagnostic
     * messages such as compilation errors and compilation warnings. Populated in
     * FULL view.
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.CompilationDiagnostic compilation_diagnostics = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Chronicle\V1\CompilationDiagnostic>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCompilationDiagnostics($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Chronicle\V1\CompilationDiagnostic::class);
        $this->compilation_diagnostics = $arr;

        return $this;
    }

    /**
     * Output only. Indicate the rule can run in near real time live rule.
     * If this is true, the rule uses the near real time live rule when the run
     * frequency is set to LIVE.
     *
     * Generated from protobuf field <code>bool near_real_time_live_rule_eligible = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getNearRealTimeLiveRuleEligible()
    {
        return $this->near_real_time_live_rule_eligible;
    }

    /**
     * Output only. Indicate the rule can run in near real time live rule.
     * If this is true, the rule uses the near real time live rule when the run
     * frequency is set to LIVE.
     *
     * Generated from protobuf field <code>bool near_real_time_live_rule_eligible = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setNearRealTimeLiveRuleEligible($var)
    {
        GPBUtil::checkBool($var);
        $this->near_real_time_live_rule_eligible = $var;

        return $this;
    }

    /**
     * Output only. The set of inputs used in the rule. For example, if the rule
     * uses $e.principal.hostname, then the uses_udm field will be true.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.InputsUsed inputs_used = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Chronicle\V1\InputsUsed|null
     */
    public function getInputsUsed()
    {
        return $this->inputs_used;
    }

    public function hasInputsUsed()
    {
        return isset($this->inputs_used);
    }

    public function clearInputsUsed()
    {
        unset($this->inputs_used);
    }

    /**
     * Output only. The set of inputs used in the rule. For example, if the rule
     * uses $e.principal.hostname, then the uses_udm field will be true.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.InputsUsed inputs_used = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Chronicle\V1\InputsUsed $var
     * @return $this
     */
    public function setInputsUsed($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Chronicle\V1\InputsUsed::class);
        $this->inputs_used = $var;

        return $this;
    }

}

