<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/spanner.proto

namespace Google\Cloud\Spanner\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The DirectedReadOptions can be used to indicate which replicas or regions
 * should be used for non-transactional reads or queries.
 * DirectedReadOptions may only be specified for a read-only transaction,
 * otherwise the API will return an `INVALID_ARGUMENT` error.
 *
 * Generated from protobuf message <code>google.spanner.v1.DirectedReadOptions</code>
 */
class DirectedReadOptions extends \Google\Protobuf\Internal\Message
{
    protected $replicas;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Spanner\V1\DirectedReadOptions\IncludeReplicas $include_replicas
     *           Include_replicas indicates the order of replicas (as they appear in
     *           this list) to process the request. If auto_failover_disabled is set to
     *           true and all replicas are exhausted without finding a healthy replica,
     *           Spanner will wait for a replica in the list to become available, requests
     *           may fail due to `DEADLINE_EXCEEDED` errors.
     *     @type \Google\Cloud\Spanner\V1\DirectedReadOptions\ExcludeReplicas $exclude_replicas
     *           Exclude_replicas indicates that specified replicas should be excluded
     *           from serving requests. Spanner will not route requests to the replicas
     *           in this list.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Spanner::initOnce();
        parent::__construct($data);
    }

    /**
     * Include_replicas indicates the order of replicas (as they appear in
     * this list) to process the request. If auto_failover_disabled is set to
     * true and all replicas are exhausted without finding a healthy replica,
     * Spanner will wait for a replica in the list to become available, requests
     * may fail due to `DEADLINE_EXCEEDED` errors.
     *
     * Generated from protobuf field <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
     * @return \Google\Cloud\Spanner\V1\DirectedReadOptions\IncludeReplicas|null
     */
    public function getIncludeReplicas()
    {
        return $this->readOneof(1);
    }

    public function hasIncludeReplicas()
    {
        return $this->hasOneof(1);
    }

    /**
     * Include_replicas indicates the order of replicas (as they appear in
     * this list) to process the request. If auto_failover_disabled is set to
     * true and all replicas are exhausted without finding a healthy replica,
     * Spanner will wait for a replica in the list to become available, requests
     * may fail due to `DEADLINE_EXCEEDED` errors.
     *
     * Generated from protobuf field <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
     * @param \Google\Cloud\Spanner\V1\DirectedReadOptions\IncludeReplicas $var
     * @return $this
     */
    public function setIncludeReplicas($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\DirectedReadOptions\IncludeReplicas::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Exclude_replicas indicates that specified replicas should be excluded
     * from serving requests. Spanner will not route requests to the replicas
     * in this list.
     *
     * Generated from protobuf field <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
     * @return \Google\Cloud\Spanner\V1\DirectedReadOptions\ExcludeReplicas|null
     */
    public function getExcludeReplicas()
    {
        return $this->readOneof(2);
    }

    public function hasExcludeReplicas()
    {
        return $this->hasOneof(2);
    }

    /**
     * Exclude_replicas indicates that specified replicas should be excluded
     * from serving requests. Spanner will not route requests to the replicas
     * in this list.
     *
     * Generated from protobuf field <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
     * @param \Google\Cloud\Spanner\V1\DirectedReadOptions\ExcludeReplicas $var
     * @return $this
     */
    public function setExcludeReplicas($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\DirectedReadOptions\ExcludeReplicas::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getReplicas()
    {
        return $this->whichOneof("replicas");
    }

}

