<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/financialservices/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\FinancialServices\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\FinancialServices\V1\BacktestResult;
use Google\Cloud\FinancialServices\V1\CreateBacktestResultRequest;
use Google\Cloud\FinancialServices\V1\CreateDatasetRequest;
use Google\Cloud\FinancialServices\V1\CreateEngineConfigRequest;
use Google\Cloud\FinancialServices\V1\CreateInstanceRequest;
use Google\Cloud\FinancialServices\V1\CreateModelRequest;
use Google\Cloud\FinancialServices\V1\CreatePredictionResultRequest;
use Google\Cloud\FinancialServices\V1\Dataset;
use Google\Cloud\FinancialServices\V1\DeleteBacktestResultRequest;
use Google\Cloud\FinancialServices\V1\DeleteDatasetRequest;
use Google\Cloud\FinancialServices\V1\DeleteEngineConfigRequest;
use Google\Cloud\FinancialServices\V1\DeleteInstanceRequest;
use Google\Cloud\FinancialServices\V1\DeleteModelRequest;
use Google\Cloud\FinancialServices\V1\DeletePredictionResultRequest;
use Google\Cloud\FinancialServices\V1\EngineConfig;
use Google\Cloud\FinancialServices\V1\EngineVersion;
use Google\Cloud\FinancialServices\V1\ExportBacktestResultMetadataRequest;
use Google\Cloud\FinancialServices\V1\ExportEngineConfigMetadataRequest;
use Google\Cloud\FinancialServices\V1\ExportModelMetadataRequest;
use Google\Cloud\FinancialServices\V1\ExportPredictionResultMetadataRequest;
use Google\Cloud\FinancialServices\V1\ExportRegisteredPartiesRequest;
use Google\Cloud\FinancialServices\V1\GetBacktestResultRequest;
use Google\Cloud\FinancialServices\V1\GetDatasetRequest;
use Google\Cloud\FinancialServices\V1\GetEngineConfigRequest;
use Google\Cloud\FinancialServices\V1\GetEngineVersionRequest;
use Google\Cloud\FinancialServices\V1\GetInstanceRequest;
use Google\Cloud\FinancialServices\V1\GetModelRequest;
use Google\Cloud\FinancialServices\V1\GetPredictionResultRequest;
use Google\Cloud\FinancialServices\V1\ImportRegisteredPartiesRequest;
use Google\Cloud\FinancialServices\V1\Instance;
use Google\Cloud\FinancialServices\V1\ListBacktestResultsRequest;
use Google\Cloud\FinancialServices\V1\ListDatasetsRequest;
use Google\Cloud\FinancialServices\V1\ListEngineConfigsRequest;
use Google\Cloud\FinancialServices\V1\ListEngineVersionsRequest;
use Google\Cloud\FinancialServices\V1\ListInstancesRequest;
use Google\Cloud\FinancialServices\V1\ListModelsRequest;
use Google\Cloud\FinancialServices\V1\ListPredictionResultsRequest;
use Google\Cloud\FinancialServices\V1\Model;
use Google\Cloud\FinancialServices\V1\PredictionResult;
use Google\Cloud\FinancialServices\V1\UpdateBacktestResultRequest;
use Google\Cloud\FinancialServices\V1\UpdateDatasetRequest;
use Google\Cloud\FinancialServices\V1\UpdateEngineConfigRequest;
use Google\Cloud\FinancialServices\V1\UpdateInstanceRequest;
use Google\Cloud\FinancialServices\V1\UpdateModelRequest;
use Google\Cloud\FinancialServices\V1\UpdatePredictionResultRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The AML (Anti Money Laundering) service allows users to perform REST
 * operations on aml.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createBacktestResultAsync(CreateBacktestResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createDatasetAsync(CreateDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createEngineConfigAsync(CreateEngineConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createInstanceAsync(CreateInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createModelAsync(CreateModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createPredictionResultAsync(CreatePredictionResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteBacktestResultAsync(DeleteBacktestResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteDatasetAsync(DeleteDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteEngineConfigAsync(DeleteEngineConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteInstanceAsync(DeleteInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteModelAsync(DeleteModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deletePredictionResultAsync(DeletePredictionResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> exportBacktestResultMetadataAsync(ExportBacktestResultMetadataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> exportEngineConfigMetadataAsync(ExportEngineConfigMetadataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> exportModelMetadataAsync(ExportModelMetadataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> exportPredictionResultMetadataAsync(ExportPredictionResultMetadataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> exportRegisteredPartiesAsync(ExportRegisteredPartiesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BacktestResult> getBacktestResultAsync(GetBacktestResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Dataset> getDatasetAsync(GetDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EngineConfig> getEngineConfigAsync(GetEngineConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EngineVersion> getEngineVersionAsync(GetEngineVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Instance> getInstanceAsync(GetInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Model> getModelAsync(GetModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PredictionResult> getPredictionResultAsync(GetPredictionResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> importRegisteredPartiesAsync(ImportRegisteredPartiesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBacktestResultsAsync(ListBacktestResultsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDatasetsAsync(ListDatasetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEngineConfigsAsync(ListEngineConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEngineVersionsAsync(ListEngineVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listInstancesAsync(ListInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listModelsAsync(ListModelsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listPredictionResultsAsync(ListPredictionResultsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateBacktestResultAsync(UpdateBacktestResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateDatasetAsync(UpdateDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateEngineConfigAsync(UpdateEngineConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateInstanceAsync(UpdateInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateModelAsync(UpdateModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updatePredictionResultAsync(UpdatePredictionResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class AMLClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.financialservices.v1.AML';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'financialservices.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'financialservices.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/aml_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/aml_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/aml_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/aml_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * backtest_result resource.
     *
     * @param string $projectNum
     * @param string $location
     * @param string $instance
     * @param string $backtestResult
     *
     * @return string The formatted backtest_result resource.
     */
    public static function backtestResultName(
        string $projectNum,
        string $location,
        string $instance,
        string $backtestResult
    ): string {
        return self::getPathTemplate('backtestResult')->render([
            'project_num' => $projectNum,
            'location' => $location,
            'instance' => $instance,
            'backtest_result' => $backtestResult,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a dataset
     * resource.
     *
     * @param string $projectNum
     * @param string $location
     * @param string $instance
     * @param string $dataset
     *
     * @return string The formatted dataset resource.
     */
    public static function datasetName(string $projectNum, string $location, string $instance, string $dataset): string
    {
        return self::getPathTemplate('dataset')->render([
            'project_num' => $projectNum,
            'location' => $location,
            'instance' => $instance,
            'dataset' => $dataset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * engine_config resource.
     *
     * @param string $projectNum
     * @param string $location
     * @param string $instance
     * @param string $engineConfig
     *
     * @return string The formatted engine_config resource.
     */
    public static function engineConfigName(
        string $projectNum,
        string $location,
        string $instance,
        string $engineConfig
    ): string {
        return self::getPathTemplate('engineConfig')->render([
            'project_num' => $projectNum,
            'location' => $location,
            'instance' => $instance,
            'engine_config' => $engineConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * engine_version resource.
     *
     * @param string $projectNum
     * @param string $location
     * @param string $instance
     * @param string $engineVersion
     *
     * @return string The formatted engine_version resource.
     */
    public static function engineVersionName(
        string $projectNum,
        string $location,
        string $instance,
        string $engineVersion
    ): string {
        return self::getPathTemplate('engineVersion')->render([
            'project_num' => $projectNum,
            'location' => $location,
            'instance' => $instance,
            'engine_version' => $engineVersion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $location, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a model
     * resource.
     *
     * @param string $projectNum
     * @param string $location
     * @param string $instance
     * @param string $model
     *
     * @return string The formatted model resource.
     */
    public static function modelName(string $projectNum, string $location, string $instance, string $model): string
    {
        return self::getPathTemplate('model')->render([
            'project_num' => $projectNum,
            'location' => $location,
            'instance' => $instance,
            'model' => $model,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * prediction_result resource.
     *
     * @param string $projectNum
     * @param string $location
     * @param string $instance
     * @param string $predictionResult
     *
     * @return string The formatted prediction_result resource.
     */
    public static function predictionResultName(
        string $projectNum,
        string $location,
        string $instance,
        string $predictionResult
    ): string {
        return self::getPathTemplate('predictionResult')->render([
            'project_num' => $projectNum,
            'location' => $location,
            'instance' => $instance,
            'prediction_result' => $predictionResult,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - backtestResult: projects/{project_num}/locations/{location}/instances/{instance}/backtestResults/{backtest_result}
     * - dataset: projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}
     * - engineConfig: projects/{project_num}/locations/{location}/instances/{instance}/engineConfigs/{engine_config}
     * - engineVersion: projects/{project_num}/locations/{location}/instances/{instance}/engineVersions/{engine_version}
     * - instance: projects/{project}/locations/{location}/instances/{instance}
     * - location: projects/{project}/locations/{location}
     * - model: projects/{project_num}/locations/{location}/instances/{instance}/models/{model}
     * - predictionResult: projects/{project_num}/locations/{location}/instances/{instance}/predictionResults/{prediction_result}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'financialservices.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Create a BacktestResult.
     *
     * The async variant is {@see AMLClient::createBacktestResultAsync()} .
     *
     * @example samples/V1/AMLClient/create_backtest_result.php
     *
     * @param CreateBacktestResultRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBacktestResult(
        CreateBacktestResultRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateBacktestResult', $request, $callOptions)->wait();
    }

    /**
     * Creates a dataset.
     *
     * The async variant is {@see AMLClient::createDatasetAsync()} .
     *
     * @example samples/V1/AMLClient/create_dataset.php
     *
     * @param CreateDatasetRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDataset(CreateDatasetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateDataset', $request, $callOptions)->wait();
    }

    /**
     * Creates an engine config.
     *
     * The async variant is {@see AMLClient::createEngineConfigAsync()} .
     *
     * @example samples/V1/AMLClient/create_engine_config.php
     *
     * @param CreateEngineConfigRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEngineConfig(CreateEngineConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateEngineConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates an instance.
     *
     * The async variant is {@see AMLClient::createInstanceAsync()} .
     *
     * @example samples/V1/AMLClient/create_instance.php
     *
     * @param CreateInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createInstance(CreateInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateInstance', $request, $callOptions)->wait();
    }

    /**
     * Creates a model.
     *
     * The async variant is {@see AMLClient::createModelAsync()} .
     *
     * @example samples/V1/AMLClient/create_model.php
     *
     * @param CreateModelRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createModel(CreateModelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateModel', $request, $callOptions)->wait();
    }

    /**
     * Create a PredictionResult.
     *
     * The async variant is {@see AMLClient::createPredictionResultAsync()} .
     *
     * @example samples/V1/AMLClient/create_prediction_result.php
     *
     * @param CreatePredictionResultRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPredictionResult(
        CreatePredictionResultRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreatePredictionResult', $request, $callOptions)->wait();
    }

    /**
     * Deletes a BacktestResult.
     *
     * The async variant is {@see AMLClient::deleteBacktestResultAsync()} .
     *
     * @example samples/V1/AMLClient/delete_backtest_result.php
     *
     * @param DeleteBacktestResultRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBacktestResult(
        DeleteBacktestResultRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteBacktestResult', $request, $callOptions)->wait();
    }

    /**
     * Deletes a dataset.
     *
     * The async variant is {@see AMLClient::deleteDatasetAsync()} .
     *
     * @example samples/V1/AMLClient/delete_dataset.php
     *
     * @param DeleteDatasetRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDataset(DeleteDatasetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteDataset', $request, $callOptions)->wait();
    }

    /**
     * Deletes an engine config.
     *
     * The async variant is {@see AMLClient::deleteEngineConfigAsync()} .
     *
     * @example samples/V1/AMLClient/delete_engine_config.php
     *
     * @param DeleteEngineConfigRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEngineConfig(DeleteEngineConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteEngineConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes an instance.
     *
     * The async variant is {@see AMLClient::deleteInstanceAsync()} .
     *
     * @example samples/V1/AMLClient/delete_instance.php
     *
     * @param DeleteInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteInstance(DeleteInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteInstance', $request, $callOptions)->wait();
    }

    /**
     * Deletes a model.
     *
     * The async variant is {@see AMLClient::deleteModelAsync()} .
     *
     * @example samples/V1/AMLClient/delete_model.php
     *
     * @param DeleteModelRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteModel(DeleteModelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteModel', $request, $callOptions)->wait();
    }

    /**
     * Deletes a PredictionResult.
     *
     * The async variant is {@see AMLClient::deletePredictionResultAsync()} .
     *
     * @example samples/V1/AMLClient/delete_prediction_result.php
     *
     * @param DeletePredictionResultRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePredictionResult(
        DeletePredictionResultRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeletePredictionResult', $request, $callOptions)->wait();
    }

    /**
     * Export governance information for a BacktestResult resource. For
     * information on the exported fields, see
     * [AML output data
     * model](https://cloud.google.com/financial-services/anti-money-laundering/docs/reference/schemas/aml-output-data-model#backtest-results).
     *
     * The async variant is {@see AMLClient::exportBacktestResultMetadataAsync()} .
     *
     * @example samples/V1/AMLClient/export_backtest_result_metadata.php
     *
     * @param ExportBacktestResultMetadataRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportBacktestResultMetadata(
        ExportBacktestResultMetadataRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('ExportBacktestResultMetadata', $request, $callOptions)->wait();
    }

    /**
     * Export governance information for an EngineConfig resource. For
     * information on the exported fields, see
     * [AML output data
     * model](https://cloud.google.com/financial-services/anti-money-laundering/docs/reference/schemas/aml-output-data-model#engine-config).
     *
     * The async variant is {@see AMLClient::exportEngineConfigMetadataAsync()} .
     *
     * @example samples/V1/AMLClient/export_engine_config_metadata.php
     *
     * @param ExportEngineConfigMetadataRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportEngineConfigMetadata(
        ExportEngineConfigMetadataRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('ExportEngineConfigMetadata', $request, $callOptions)->wait();
    }

    /**
     * Export governance information for a Model resource. For
     * information on the exported fields, see
     * [AML output data
     * model](https://cloud.google.com/financial-services/anti-money-laundering/docs/reference/schemas/aml-output-data-model#model).
     *
     * The async variant is {@see AMLClient::exportModelMetadataAsync()} .
     *
     * @example samples/V1/AMLClient/export_model_metadata.php
     *
     * @param ExportModelMetadataRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportModelMetadata(ExportModelMetadataRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ExportModelMetadata', $request, $callOptions)->wait();
    }

    /**
     * Export governance information for a PredictionResult resource. For
     * information on the exported fields, see
     * [AML output data
     * model](https://cloud.google.com/financial-services/anti-money-laundering/docs/reference/schemas/aml-output-data-model#prediction-results).
     *
     * The async variant is {@see AMLClient::exportPredictionResultMetadataAsync()} .
     *
     * @example samples/V1/AMLClient/export_prediction_result_metadata.php
     *
     * @param ExportPredictionResultMetadataRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportPredictionResultMetadata(
        ExportPredictionResultMetadataRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('ExportPredictionResultMetadata', $request, $callOptions)->wait();
    }

    /**
     * Exports the list of registered parties. See
     * [Create and manage
     * instances](https://cloud.google.com/financial-services/anti-money-laundering/docs/create-and-manage-instances#export-registered-parties)
     * for information on the output schema for this method.
     *
     * The async variant is {@see AMLClient::exportRegisteredPartiesAsync()} .
     *
     * @example samples/V1/AMLClient/export_registered_parties.php
     *
     * @param ExportRegisteredPartiesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportRegisteredParties(
        ExportRegisteredPartiesRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('ExportRegisteredParties', $request, $callOptions)->wait();
    }

    /**
     * Gets a BacktestResult.
     *
     * The async variant is {@see AMLClient::getBacktestResultAsync()} .
     *
     * @example samples/V1/AMLClient/get_backtest_result.php
     *
     * @param GetBacktestResultRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BacktestResult
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBacktestResult(GetBacktestResultRequest $request, array $callOptions = []): BacktestResult
    {
        return $this->startApiCall('GetBacktestResult', $request, $callOptions)->wait();
    }

    /**
     * Gets a dataset.
     *
     * The async variant is {@see AMLClient::getDatasetAsync()} .
     *
     * @example samples/V1/AMLClient/get_dataset.php
     *
     * @param GetDatasetRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Dataset
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDataset(GetDatasetRequest $request, array $callOptions = []): Dataset
    {
        return $this->startApiCall('GetDataset', $request, $callOptions)->wait();
    }

    /**
     * Gets an engine config.
     *
     * The async variant is {@see AMLClient::getEngineConfigAsync()} .
     *
     * @example samples/V1/AMLClient/get_engine_config.php
     *
     * @param GetEngineConfigRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EngineConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEngineConfig(GetEngineConfigRequest $request, array $callOptions = []): EngineConfig
    {
        return $this->startApiCall('GetEngineConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets a single EngineVersion.
     *
     * The async variant is {@see AMLClient::getEngineVersionAsync()} .
     *
     * @example samples/V1/AMLClient/get_engine_version.php
     *
     * @param GetEngineVersionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EngineVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEngineVersion(GetEngineVersionRequest $request, array $callOptions = []): EngineVersion
    {
        return $this->startApiCall('GetEngineVersion', $request, $callOptions)->wait();
    }

    /**
     * Gets an instance.
     *
     * The async variant is {@see AMLClient::getInstanceAsync()} .
     *
     * @example samples/V1/AMLClient/get_instance.php
     *
     * @param GetInstanceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Instance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInstance(GetInstanceRequest $request, array $callOptions = []): Instance
    {
        return $this->startApiCall('GetInstance', $request, $callOptions)->wait();
    }

    /**
     * Gets a model.
     *
     * The async variant is {@see AMLClient::getModelAsync()} .
     *
     * @example samples/V1/AMLClient/get_model.php
     *
     * @param GetModelRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Model
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getModel(GetModelRequest $request, array $callOptions = []): Model
    {
        return $this->startApiCall('GetModel', $request, $callOptions)->wait();
    }

    /**
     * Gets a PredictionResult.
     *
     * The async variant is {@see AMLClient::getPredictionResultAsync()} .
     *
     * @example samples/V1/AMLClient/get_prediction_result.php
     *
     * @param GetPredictionResultRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PredictionResult
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPredictionResult(GetPredictionResultRequest $request, array $callOptions = []): PredictionResult
    {
        return $this->startApiCall('GetPredictionResult', $request, $callOptions)->wait();
    }

    /**
     * Imports the list of registered parties. See
     * [Create and manage
     * instances](https://cloud.google.com/financial-services/anti-money-laundering/docs/create-and-manage-instances#import-registered-parties)
     * for information on the input schema and response for this method.
     *
     * The async variant is {@see AMLClient::importRegisteredPartiesAsync()} .
     *
     * @example samples/V1/AMLClient/import_registered_parties.php
     *
     * @param ImportRegisteredPartiesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importRegisteredParties(
        ImportRegisteredPartiesRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('ImportRegisteredParties', $request, $callOptions)->wait();
    }

    /**
     * List BacktestResults.
     *
     * The async variant is {@see AMLClient::listBacktestResultsAsync()} .
     *
     * @example samples/V1/AMLClient/list_backtest_results.php
     *
     * @param ListBacktestResultsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBacktestResults(ListBacktestResultsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBacktestResults', $request, $callOptions);
    }

    /**
     * Lists datasets.
     *
     * The async variant is {@see AMLClient::listDatasetsAsync()} .
     *
     * @example samples/V1/AMLClient/list_datasets.php
     *
     * @param ListDatasetsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDatasets(ListDatasetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDatasets', $request, $callOptions);
    }

    /**
     * Lists engine configs.
     *
     * The async variant is {@see AMLClient::listEngineConfigsAsync()} .
     *
     * @example samples/V1/AMLClient/list_engine_configs.php
     *
     * @param ListEngineConfigsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEngineConfigs(ListEngineConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEngineConfigs', $request, $callOptions);
    }

    /**
     * Lists EngineVersions for given location.
     *
     * The async variant is {@see AMLClient::listEngineVersionsAsync()} .
     *
     * @example samples/V1/AMLClient/list_engine_versions.php
     *
     * @param ListEngineVersionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEngineVersions(ListEngineVersionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEngineVersions', $request, $callOptions);
    }

    /**
     * Lists instances.
     *
     * The async variant is {@see AMLClient::listInstancesAsync()} .
     *
     * @example samples/V1/AMLClient/list_instances.php
     *
     * @param ListInstancesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listInstances(ListInstancesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListInstances', $request, $callOptions);
    }

    /**
     * Lists models.
     *
     * The async variant is {@see AMLClient::listModelsAsync()} .
     *
     * @example samples/V1/AMLClient/list_models.php
     *
     * @param ListModelsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listModels(ListModelsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListModels', $request, $callOptions);
    }

    /**
     * List PredictionResults.
     *
     * The async variant is {@see AMLClient::listPredictionResultsAsync()} .
     *
     * @example samples/V1/AMLClient/list_prediction_results.php
     *
     * @param ListPredictionResultsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPredictionResults(
        ListPredictionResultsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListPredictionResults', $request, $callOptions);
    }

    /**
     * Updates the parameters of a single BacktestResult.
     *
     * The async variant is {@see AMLClient::updateBacktestResultAsync()} .
     *
     * @example samples/V1/AMLClient/update_backtest_result.php
     *
     * @param UpdateBacktestResultRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBacktestResult(
        UpdateBacktestResultRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateBacktestResult', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Dataset.
     *
     * The async variant is {@see AMLClient::updateDatasetAsync()} .
     *
     * @example samples/V1/AMLClient/update_dataset.php
     *
     * @param UpdateDatasetRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDataset(UpdateDatasetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateDataset', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single EngineConfig.
     *
     * The async variant is {@see AMLClient::updateEngineConfigAsync()} .
     *
     * @example samples/V1/AMLClient/update_engine_config.php
     *
     * @param UpdateEngineConfigRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEngineConfig(UpdateEngineConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateEngineConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Instance.
     *
     * The async variant is {@see AMLClient::updateInstanceAsync()} .
     *
     * @example samples/V1/AMLClient/update_instance.php
     *
     * @param UpdateInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateInstance(UpdateInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateInstance', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Model.
     *
     * The async variant is {@see AMLClient::updateModelAsync()} .
     *
     * @example samples/V1/AMLClient/update_model.php
     *
     * @param UpdateModelRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateModel(UpdateModelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateModel', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single PredictionResult.
     *
     * The async variant is {@see AMLClient::updatePredictionResultAsync()} .
     *
     * @example samples/V1/AMLClient/update_prediction_result.php
     *
     * @param UpdatePredictionResultRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePredictionResult(
        UpdatePredictionResultRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdatePredictionResult', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see AMLClient::getLocationAsync()} .
     *
     * @example samples/V1/AMLClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see AMLClient::listLocationsAsync()} .
     *
     * @example samples/V1/AMLClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
