<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_DLP_RedactContentRequest extends Google_Collection
{
  protected $collection_key = 'replaceConfigs';
  protected $inspectConfigType = 'Google_Service_DLP_InspectConfig';
  protected $inspectConfigDataType = '';
  protected $itemsType = 'Google_Service_DLP_ContentItem';
  protected $itemsDataType = 'array';
  protected $replaceConfigsType = 'Google_Service_DLP_ReplaceConfig';
  protected $replaceConfigsDataType = 'array';

  public function setInspectConfig(Google_Service_DLP_InspectConfig $inspectConfig)
  {
    $this->inspectConfig = $inspectConfig;
  }
  public function getInspectConfig()
  {
    return $this->inspectConfig;
  }
  public function setItems($items)
  {
    $this->items = $items;
  }
  public function getItems()
  {
    return $this->items;
  }
  public function setReplaceConfigs($replaceConfigs)
  {
    $this->replaceConfigs = $replaceConfigs;
  }
  public function getReplaceConfigs()
  {
    return $this->replaceConfigs;
  }
}
