<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Batch;

class CloudLoggingOption extends \Google\Model
{
  /**
   * Optional. Set this field to `true` to change the [monitored resource
   * type](https://cloud.google.com/monitoring/api/resources) for Cloud Logging
   * logs generated by this Batch job from the [`batch.googleapis.com/Job`](http
   * s://cloud.google.com/monitoring/api/resources#tag_batch.googleapis.com/Job)
   * type to the formerly used [`generic_task`](https://cloud.google.com/monitor
   * ing/api/resources#tag_generic_task) type.
   *
   * @var bool
   */
  public $useGenericTaskMonitoredResource;

  /**
   * Optional. Set this field to `true` to change the [monitored resource
   * type](https://cloud.google.com/monitoring/api/resources) for Cloud Logging
   * logs generated by this Batch job from the [`batch.googleapis.com/Job`](http
   * s://cloud.google.com/monitoring/api/resources#tag_batch.googleapis.com/Job)
   * type to the formerly used [`generic_task`](https://cloud.google.com/monitor
   * ing/api/resources#tag_generic_task) type.
   *
   * @param bool $useGenericTaskMonitoredResource
   */
  public function setUseGenericTaskMonitoredResource($useGenericTaskMonitoredResource)
  {
    $this->useGenericTaskMonitoredResource = $useGenericTaskMonitoredResource;
  }
  /**
   * @return bool
   */
  public function getUseGenericTaskMonitoredResource()
  {
    return $this->useGenericTaskMonitoredResource;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CloudLoggingOption::class, 'Google_Service_Batch_CloudLoggingOption');
