<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRun;

class GoogleCloudRunV2SecretVolumeSource extends \Google\Collection
{
  protected $collection_key = 'items';
  /**
   * @var int
   */
  public $defaultMode;
  /**
   * @var GoogleCloudRunV2VersionToPath[]
   */
  public $items;
  protected $itemsType = GoogleCloudRunV2VersionToPath::class;
  protected $itemsDataType = 'array';
  /**
   * @var string
   */
  public $secret;

  /**
   * @param int
   */
  public function setDefaultMode($defaultMode)
  {
    $this->defaultMode = $defaultMode;
  }
  /**
   * @return int
   */
  public function getDefaultMode()
  {
    return $this->defaultMode;
  }
  /**
   * @param GoogleCloudRunV2VersionToPath[]
   */
  public function setItems($items)
  {
    $this->items = $items;
  }
  /**
   * @return GoogleCloudRunV2VersionToPath[]
   */
  public function getItems()
  {
    return $this->items;
  }
  /**
   * @param string
   */
  public function setSecret($secret)
  {
    $this->secret = $secret;
  }
  /**
   * @return string
   */
  public function getSecret()
  {
    return $this->secret;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudRunV2SecretVolumeSource::class, 'Google_Service_CloudRun_GoogleCloudRunV2SecretVolumeSource');
