<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class TargetPool extends \Google\Collection
{
  /**
   * 2-tuple hash on packet's source and destination IP addresses. Connections
   * from the same source IP address to the same destination IP address will be
   * served by the same backend VM while that VM remains healthy.
   */
  public const SESSION_AFFINITY_CLIENT_IP = 'CLIENT_IP';
  /**
   * 1-tuple hash only on packet's source IP address. Connections from the same
   * source IP address will be served by the same backend VM while that VM
   * remains healthy. This option can only be used for Internal TCP/UDP Load
   * Balancing.
   */
  public const SESSION_AFFINITY_CLIENT_IP_NO_DESTINATION = 'CLIENT_IP_NO_DESTINATION';
  /**
   * 5-tuple hash on packet's source and destination IP addresses, IP protocol,
   * and source and destination ports. Connections for the same IP protocol from
   * the same source IP address and port to the same destination IP address and
   * port will be served by the same backend VM while that VM remains healthy.
   * This option cannot be used for HTTP(S) load balancing.
   */
  public const SESSION_AFFINITY_CLIENT_IP_PORT_PROTO = 'CLIENT_IP_PORT_PROTO';
  /**
   * 3-tuple hash on packet's source and destination IP addresses, and IP
   * protocol. Connections for the same IP protocol from the same source IP
   * address to the same destination IP address will be served by the same
   * backend VM while that VM remains healthy. This option cannot be used for
   * HTTP(S) load balancing.
   */
  public const SESSION_AFFINITY_CLIENT_IP_PROTO = 'CLIENT_IP_PROTO';
  /**
   * Hash based on a cookie generated by the L7 loadbalancer. Only valid for
   * HTTP(S) load balancing.
   */
  public const SESSION_AFFINITY_GENERATED_COOKIE = 'GENERATED_COOKIE';
  /**
   * The hash is based on a user specified header field.
   */
  public const SESSION_AFFINITY_HEADER_FIELD = 'HEADER_FIELD';
  /**
   * The hash is based on a user provided cookie.
   */
  public const SESSION_AFFINITY_HTTP_COOKIE = 'HTTP_COOKIE';
  /**
   * No session affinity. Connections from the same client IP may go to any
   * instance in the pool.
   */
  public const SESSION_AFFINITY_NONE = 'NONE';
  /**
   * Strong cookie-based affinity. Connections bearing the same cookie will be
   * served by the same backend VM while that VM remains healthy, as long as the
   * cookie has not expired.
   */
  public const SESSION_AFFINITY_STRONG_COOKIE_AFFINITY = 'STRONG_COOKIE_AFFINITY';
  protected $collection_key = 'instances';
  /**
   * The server-defined URL for the resource. This field is applicable only when
   * the containing target pool is serving a forwarding rule as the primary
   * pool, and its failoverRatio field is properly set to a value between [0,
   * 1].backupPool and failoverRatio together define the fallback behavior of
   * the primary target pool: if the ratio of the healthy instances in the
   * primary pool is at or belowfailoverRatio, traffic arriving at the load-
   * balanced IP will be directed to the backup pool.
   *
   * In case where failoverRatio and backupPool are not set, or all the
   * instances in the backup pool are unhealthy, the traffic will be directed
   * back to the primary pool in the "force" mode, where traffic will be spread
   * to the healthy instances with the best effort, or to all instances when no
   * instance is healthy.
   *
   * @var string
   */
  public $backupPool;
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  /**
   * This field is applicable only when the containing target pool is serving a
   * forwarding rule as the primary pool (i.e., not as a backup pool to some
   * other target pool). The value of the field must be in [0, 1].
   *
   * If set, backupPool must also be set. They together define the fallback
   * behavior of the primary target pool: if the ratio of the healthy instances
   * in the primary pool is at or below this number, traffic arriving at the
   * load-balanced IP will be directed to the backup pool.
   *
   * In case where failoverRatio is not set or all the instances in the backup
   * pool are unhealthy, the traffic will be directed back to the primary pool
   * in the "force" mode, where traffic will be spread to the healthy instances
   * with the best effort, or to all instances when no instance is healthy.
   *
   * @var float
   */
  public $failoverRatio;
  /**
   * The URL of the HttpHealthCheck resource. A member instance in this pool is
   * considered healthy if and only if the health checks pass. Only legacy
   * HttpHealthChecks are supported. Only one health check may be specified.
   *
   * @var string[]
   */
  public $healthChecks;
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @var string
   */
  public $id;
  /**
   * A list of resource URLs to the virtual machine instances serving this pool.
   * They must live in zones contained in the same region as this pool.
   *
   * @var string[]
   */
  public $instances;
  /**
   * [Output Only] Type of the resource. Always compute#targetPool for target
   * pools.
   *
   * @var string
   */
  public $kind;
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  /**
   * [Output Only] URL of the region where the target pool resides.
   *
   * @var string
   */
  public $region;
  /**
   * [Output Only] The resource URL for the security policy associated with this
   * target pool.
   *
   * @var string
   */
  public $securityPolicy;
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @var string
   */
  public $selfLink;
  /**
   * Session affinity option, must be one of the following values: NONE:
   * Connections from the same client IP may go to any     instance in the pool.
   * CLIENT_IP: Connections from the same client IP will go     to the same
   * instance in     the pool while that instance remains healthy.
   * CLIENT_IP_PROTO: Connections from the same client IP     with the same IP
   * protocol will go to the same instance in the     pool while that instance
   * remains healthy.
   *
   * @var string
   */
  public $sessionAffinity;

  /**
   * The server-defined URL for the resource. This field is applicable only when
   * the containing target pool is serving a forwarding rule as the primary
   * pool, and its failoverRatio field is properly set to a value between [0,
   * 1].backupPool and failoverRatio together define the fallback behavior of
   * the primary target pool: if the ratio of the healthy instances in the
   * primary pool is at or belowfailoverRatio, traffic arriving at the load-
   * balanced IP will be directed to the backup pool.
   *
   * In case where failoverRatio and backupPool are not set, or all the
   * instances in the backup pool are unhealthy, the traffic will be directed
   * back to the primary pool in the "force" mode, where traffic will be spread
   * to the healthy instances with the best effort, or to all instances when no
   * instance is healthy.
   *
   * @param string $backupPool
   */
  public function setBackupPool($backupPool)
  {
    $this->backupPool = $backupPool;
  }
  /**
   * @return string
   */
  public function getBackupPool()
  {
    return $this->backupPool;
  }
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * This field is applicable only when the containing target pool is serving a
   * forwarding rule as the primary pool (i.e., not as a backup pool to some
   * other target pool). The value of the field must be in [0, 1].
   *
   * If set, backupPool must also be set. They together define the fallback
   * behavior of the primary target pool: if the ratio of the healthy instances
   * in the primary pool is at or below this number, traffic arriving at the
   * load-balanced IP will be directed to the backup pool.
   *
   * In case where failoverRatio is not set or all the instances in the backup
   * pool are unhealthy, the traffic will be directed back to the primary pool
   * in the "force" mode, where traffic will be spread to the healthy instances
   * with the best effort, or to all instances when no instance is healthy.
   *
   * @param float $failoverRatio
   */
  public function setFailoverRatio($failoverRatio)
  {
    $this->failoverRatio = $failoverRatio;
  }
  /**
   * @return float
   */
  public function getFailoverRatio()
  {
    return $this->failoverRatio;
  }
  /**
   * The URL of the HttpHealthCheck resource. A member instance in this pool is
   * considered healthy if and only if the health checks pass. Only legacy
   * HttpHealthChecks are supported. Only one health check may be specified.
   *
   * @param string[] $healthChecks
   */
  public function setHealthChecks($healthChecks)
  {
    $this->healthChecks = $healthChecks;
  }
  /**
   * @return string[]
   */
  public function getHealthChecks()
  {
    return $this->healthChecks;
  }
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * A list of resource URLs to the virtual machine instances serving this pool.
   * They must live in zones contained in the same region as this pool.
   *
   * @param string[] $instances
   */
  public function setInstances($instances)
  {
    $this->instances = $instances;
  }
  /**
   * @return string[]
   */
  public function getInstances()
  {
    return $this->instances;
  }
  /**
   * [Output Only] Type of the resource. Always compute#targetPool for target
   * pools.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * [Output Only] URL of the region where the target pool resides.
   *
   * @param string $region
   */
  public function setRegion($region)
  {
    $this->region = $region;
  }
  /**
   * @return string
   */
  public function getRegion()
  {
    return $this->region;
  }
  /**
   * [Output Only] The resource URL for the security policy associated with this
   * target pool.
   *
   * @param string $securityPolicy
   */
  public function setSecurityPolicy($securityPolicy)
  {
    $this->securityPolicy = $securityPolicy;
  }
  /**
   * @return string
   */
  public function getSecurityPolicy()
  {
    return $this->securityPolicy;
  }
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * Session affinity option, must be one of the following values: NONE:
   * Connections from the same client IP may go to any     instance in the pool.
   * CLIENT_IP: Connections from the same client IP will go     to the same
   * instance in     the pool while that instance remains healthy.
   * CLIENT_IP_PROTO: Connections from the same client IP     with the same IP
   * protocol will go to the same instance in the     pool while that instance
   * remains healthy.
   *
   * Accepted values: CLIENT_IP, CLIENT_IP_NO_DESTINATION, CLIENT_IP_PORT_PROTO,
   * CLIENT_IP_PROTO, GENERATED_COOKIE, HEADER_FIELD, HTTP_COOKIE, NONE,
   * STRONG_COOKIE_AFFINITY
   *
   * @param self::SESSION_AFFINITY_* $sessionAffinity
   */
  public function setSessionAffinity($sessionAffinity)
  {
    $this->sessionAffinity = $sessionAffinity;
  }
  /**
   * @return self::SESSION_AFFINITY_*
   */
  public function getSessionAffinity()
  {
    return $this->sessionAffinity;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TargetPool::class, 'Google_Service_Compute_TargetPool');
