<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AppHub;

class Environment extends \Google\Model
{
  /**
   * Unspecified type.
   */
  public const TYPE_TYPE_UNSPECIFIED = 'TYPE_UNSPECIFIED';
  /**
   * Production environment.
   */
  public const TYPE_PRODUCTION = 'PRODUCTION';
  /**
   * Staging environment.
   */
  public const TYPE_STAGING = 'STAGING';
  /**
   * Test environment.
   */
  public const TYPE_TEST = 'TEST';
  /**
   * Development environment.
   */
  public const TYPE_DEVELOPMENT = 'DEVELOPMENT';
  /**
   * Required. Environment Type.
   *
   * @var string
   */
  public $type;

  /**
   * Required. Environment Type.
   *
   * Accepted values: TYPE_UNSPECIFIED, PRODUCTION, STAGING, TEST, DEVELOPMENT
   *
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Environment::class, 'Google_Service_AppHub_Environment');
