<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Apigee;

class GoogleCloudApigeeV1Metric extends \Google\Collection
{
  protected $collection_key = 'values';
  /**
   * Metric name.
   *
   * @var string
   */
  public $name;
  /**
   * List of metric values. Possible value formats include: `"values":["39.0"]`
   * or `"values":[ { "value": "39.0", "timestamp": 1232434354} ]`
   *
   * @var array[]
   */
  public $values;

  /**
   * Metric name.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * List of metric values. Possible value formats include: `"values":["39.0"]`
   * or `"values":[ { "value": "39.0", "timestamp": 1232434354} ]`
   *
   * @param array[] $values
   */
  public function setValues($values)
  {
    $this->values = $values;
  }
  /**
   * @return array[]
   */
  public function getValues()
  {
    return $this->values;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApigeeV1Metric::class, 'Google_Service_Apigee_GoogleCloudApigeeV1Metric');
