<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata extends \Google\Collection
{
  protected $collection_key = 'partialResults';
  protected $genericMetadataType = GoogleCloudAiplatformV1GenericOperationMetadata::class;
  protected $genericMetadataDataType = '';
  protected $partialResultsType = GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult::class;
  protected $partialResultsDataType = 'array';

  /**
   * The common part of the operation metadata.
   *
   * @param GoogleCloudAiplatformV1GenericOperationMetadata $genericMetadata
   */
  public function setGenericMetadata(GoogleCloudAiplatformV1GenericOperationMetadata $genericMetadata)
  {
    $this->genericMetadata = $genericMetadata;
  }
  /**
   * @return GoogleCloudAiplatformV1GenericOperationMetadata
   */
  public function getGenericMetadata()
  {
    return $this->genericMetadata;
  }
  /**
   * Partial results that reflect the latest migration operation progress.
   *
   * @param GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult[] $partialResults
   */
  public function setPartialResults($partialResults)
  {
    $this->partialResults = $partialResults;
  }
  /**
   * @return GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult[]
   */
  public function getPartialResults()
  {
    return $this->partialResults;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata::class, 'Google_Service_Aiplatform_GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata');
