<?php
/*
 * Copyright 2016 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * The "namespaces" collection of methods.
 * Typical usage is:
 *  <code>
 *   $proximitybeaconService = new Google_Service_Proximitybeacon(...);
 *   $namespaces = $proximitybeaconService->namespaces;
 *  </code>
 */
class Google_Service_Proximitybeacon_NamespacesResource extends Google_Service_Resource
{
  /**
   * Lists all attachment namespaces owned by your Google Developers Console
   * project. Attachment data associated with a beacon must include a namespaced
   * type, and the namespace must be owned by your project.
   * (namespaces.listNamespaces)
   *
   * @param array $optParams Optional parameters.
   * @return Google_Service_ListNamespacesResponse
   */
  public function listNamespaces($optParams = array())
  {
    $params = array();
    $params = array_merge($params, $optParams);
    return $this->call('list', array($params), "Google_Service_Proximitybeacon_ListNamespacesResponse");
  }
}
