<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Reports;

class UsageReportsWarnings extends \Google\Collection
{
  protected $collection_key = 'data';
  /**
   * Machine readable code or warning type. The warning code value is `200`.
   *
   * @var string
   */
  public $code;
  protected $dataType = UsageReportsWarningsData::class;
  protected $dataDataType = 'array';
  /**
   * The human readable messages for a warning are: - Data is not available
   * warning - Sorry, data for date yyyy-mm-dd for application "`application
   * name`" is not available. - Partial data is available warning - Data for
   * date yyyy-mm-dd for application "`application name`" is not available right
   * now, please try again after a few hours.
   *
   * @var string
   */
  public $message;

  /**
   * Machine readable code or warning type. The warning code value is `200`.
   *
   * @param string $code
   */
  public function setCode($code)
  {
    $this->code = $code;
  }
  /**
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }
  /**
   * Key-value pairs to give detailed information on the warning.
   *
   * @param UsageReportsWarningsData[] $data
   */
  public function setData($data)
  {
    $this->data = $data;
  }
  /**
   * @return UsageReportsWarningsData[]
   */
  public function getData()
  {
    return $this->data;
  }
  /**
   * The human readable messages for a warning are: - Data is not available
   * warning - Sorry, data for date yyyy-mm-dd for application "`application
   * name`" is not available. - Partial data is available warning - Data for
   * date yyyy-mm-dd for application "`application name`" is not available right
   * now, please try again after a few hours.
   *
   * @param string $message
   */
  public function setMessage($message)
  {
    $this->message = $message;
  }
  /**
   * @return string
   */
  public function getMessage()
  {
    return $this->message;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UsageReportsWarnings::class, 'Google_Service_Reports_UsageReportsWarnings');
