<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Monitoring;

class BasicService extends \Google\Model
{
  /**
   * Labels that specify the resource that emits the monitoring data which is
   * used for SLO reporting of this Service. Documentation and valid values for
   * given service types here
   * (https://cloud.google.com/stackdriver/docs/solutions/slo-
   * monitoring/api/api-structures#basic-svc-w-basic-sli).
   *
   * @var string[]
   */
  public $serviceLabels;
  /**
   * The type of service that this basic service defines, e.g. APP_ENGINE
   * service type. Documentation and valid values here
   * (https://cloud.google.com/stackdriver/docs/solutions/slo-
   * monitoring/api/api-structures#basic-svc-w-basic-sli).
   *
   * @var string
   */
  public $serviceType;

  /**
   * Labels that specify the resource that emits the monitoring data which is
   * used for SLO reporting of this Service. Documentation and valid values for
   * given service types here
   * (https://cloud.google.com/stackdriver/docs/solutions/slo-
   * monitoring/api/api-structures#basic-svc-w-basic-sli).
   *
   * @param string[] $serviceLabels
   */
  public function setServiceLabels($serviceLabels)
  {
    $this->serviceLabels = $serviceLabels;
  }
  /**
   * @return string[]
   */
  public function getServiceLabels()
  {
    return $this->serviceLabels;
  }
  /**
   * The type of service that this basic service defines, e.g. APP_ENGINE
   * service type. Documentation and valid values here
   * (https://cloud.google.com/stackdriver/docs/solutions/slo-
   * monitoring/api/api-structures#basic-svc-w-basic-sli).
   *
   * @param string $serviceType
   */
  public function setServiceType($serviceType)
  {
    $this->serviceType = $serviceType;
  }
  /**
   * @return string
   */
  public function getServiceType()
  {
    return $this->serviceType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BasicService::class, 'Google_Service_Monitoring_BasicService');
