<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MigrationCenterAPI;

class ImportDataFile extends \Google\Model
{
  /**
   * Default value.
   */
  public const FORMAT_IMPORT_JOB_FORMAT_UNSPECIFIED = 'IMPORT_JOB_FORMAT_UNSPECIFIED';
  /**
   * RVTools format (XLSX).
   */
  public const FORMAT_IMPORT_JOB_FORMAT_RVTOOLS_XLSX = 'IMPORT_JOB_FORMAT_RVTOOLS_XLSX';
  /**
   * RVTools format (CSV).
   */
  public const FORMAT_IMPORT_JOB_FORMAT_RVTOOLS_CSV = 'IMPORT_JOB_FORMAT_RVTOOLS_CSV';
  /**
   * CSV format exported from AWS using the AWS collection script.
   */
  public const FORMAT_IMPORT_JOB_FORMAT_EXPORTED_AWS_CSV = 'IMPORT_JOB_FORMAT_EXPORTED_AWS_CSV';
  /**
   * CSV format exported from Azure using the Azure collection script.
   */
  public const FORMAT_IMPORT_JOB_FORMAT_EXPORTED_AZURE_CSV = 'IMPORT_JOB_FORMAT_EXPORTED_AZURE_CSV';
  /**
   * CSV format created manually and following the StratoZone format. For more
   * information, see Manually create and upload data tables.
   */
  public const FORMAT_IMPORT_JOB_FORMAT_STRATOZONE_CSV = 'IMPORT_JOB_FORMAT_STRATOZONE_CSV';
  /**
   * ZIP file with nested CSV files generated by a database collector.
   */
  public const FORMAT_IMPORT_JOB_FORMAT_DATABASE_ZIP = 'IMPORT_JOB_FORMAT_DATABASE_ZIP';
  /**
   * Default value.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * The data file is being created.
   */
  public const STATE_CREATING = 'CREATING';
  /**
   * The data file completed initialization.
   */
  public const STATE_ACTIVE = 'ACTIVE';
  /**
   * Output only. The timestamp when the file was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * User-friendly display name. Maximum length is 63 characters.
   *
   * @var string
   */
  public $displayName;
  /**
   * Required. The payload format.
   *
   * @var string
   */
  public $format;
  /**
   * Output only. The name of the file.
   *
   * @var string
   */
  public $name;
  /**
   * Output only. The state of the import data file.
   *
   * @var string
   */
  public $state;
  protected $uploadFileInfoType = UploadFileInfo::class;
  protected $uploadFileInfoDataType = '';

  /**
   * Output only. The timestamp when the file was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * User-friendly display name. Maximum length is 63 characters.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Required. The payload format.
   *
   * Accepted values: IMPORT_JOB_FORMAT_UNSPECIFIED,
   * IMPORT_JOB_FORMAT_RVTOOLS_XLSX, IMPORT_JOB_FORMAT_RVTOOLS_CSV,
   * IMPORT_JOB_FORMAT_EXPORTED_AWS_CSV, IMPORT_JOB_FORMAT_EXPORTED_AZURE_CSV,
   * IMPORT_JOB_FORMAT_STRATOZONE_CSV, IMPORT_JOB_FORMAT_DATABASE_ZIP
   *
   * @param self::FORMAT_* $format
   */
  public function setFormat($format)
  {
    $this->format = $format;
  }
  /**
   * @return self::FORMAT_*
   */
  public function getFormat()
  {
    return $this->format;
  }
  /**
   * Output only. The name of the file.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. The state of the import data file.
   *
   * Accepted values: STATE_UNSPECIFIED, CREATING, ACTIVE
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * Information about a file that is uploaded to a storage service.
   *
   * @param UploadFileInfo $uploadFileInfo
   */
  public function setUploadFileInfo(UploadFileInfo $uploadFileInfo)
  {
    $this->uploadFileInfo = $uploadFileInfo;
  }
  /**
   * @return UploadFileInfo
   */
  public function getUploadFileInfo()
  {
    return $this->uploadFileInfo;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ImportDataFile::class, 'Google_Service_MigrationCenterAPI_ImportDataFile');
