<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DeploymentManager;

class DeploymentsCancelPreviewRequest extends \Google\Model
{
  /**
   * Specifies a fingerprint for `cancelPreview()` requests. A fingerprint is a
   * randomly generated value that must be provided in `cancelPreview()`
   * requests to perform optimistic locking. This ensures optimistic concurrency
   * so that the deployment does not have conflicting requests (e.g. if someone
   * attempts to make a new update request while another user attempts to cancel
   * a preview, this would prevent one of the requests). The fingerprint is
   * initially generated by Deployment Manager and changes after every request
   * to modify a deployment. To get the latest fingerprint value, perform a
   * `get()` request on the deployment.
   *
   * @var string
   */
  public $fingerprint;

  /**
   * Specifies a fingerprint for `cancelPreview()` requests. A fingerprint is a
   * randomly generated value that must be provided in `cancelPreview()`
   * requests to perform optimistic locking. This ensures optimistic concurrency
   * so that the deployment does not have conflicting requests (e.g. if someone
   * attempts to make a new update request while another user attempts to cancel
   * a preview, this would prevent one of the requests). The fingerprint is
   * initially generated by Deployment Manager and changes after every request
   * to modify a deployment. To get the latest fingerprint value, perform a
   * `get()` request on the deployment.
   *
   * @param string $fingerprint
   */
  public function setFingerprint($fingerprint)
  {
    $this->fingerprint = $fingerprint;
  }
  /**
   * @return string
   */
  public function getFingerprint()
  {
    return $this->fingerprint;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DeploymentsCancelPreviewRequest::class, 'Google_Service_DeploymentManager_DeploymentsCancelPreviewRequest');
