<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataproc;

class StartClusterRequest extends \Google\Model
{
  /**
   * Optional. Specifying the cluster_uuid means the RPC will fail (with error
   * NOT_FOUND) if a cluster with the specified UUID does not exist.
   *
   * @var string
   */
  public $clusterUuid;
  /**
   * Optional. A unique ID used to identify the request. If the server receives
   * two StartClusterRequest (https://cloud.google.com/dataproc/docs/reference/r
   * pc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.StartClusterRequest)s
   * with the same id, then the second request will be ignored and the first
   * google.longrunning.Operation created and stored in the backend is
   * returned.Recommendation: Set this value to a UUID
   * (https://en.wikipedia.org/wiki/Universally_unique_identifier).The ID must
   * contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and
   * hyphens (-). The maximum length is 40 characters.
   *
   * @var string
   */
  public $requestId;

  /**
   * Optional. Specifying the cluster_uuid means the RPC will fail (with error
   * NOT_FOUND) if a cluster with the specified UUID does not exist.
   *
   * @param string $clusterUuid
   */
  public function setClusterUuid($clusterUuid)
  {
    $this->clusterUuid = $clusterUuid;
  }
  /**
   * @return string
   */
  public function getClusterUuid()
  {
    return $this->clusterUuid;
  }
  /**
   * Optional. A unique ID used to identify the request. If the server receives
   * two StartClusterRequest (https://cloud.google.com/dataproc/docs/reference/r
   * pc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.StartClusterRequest)s
   * with the same id, then the second request will be ignored and the first
   * google.longrunning.Operation created and stored in the backend is
   * returned.Recommendation: Set this value to a UUID
   * (https://en.wikipedia.org/wiki/Universally_unique_identifier).The ID must
   * contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and
   * hyphens (-). The maximum length is 40 characters.
   *
   * @param string $requestId
   */
  public function setRequestId($requestId)
  {
    $this->requestId = $requestId;
  }
  /**
   * @return string
   */
  public function getRequestId()
  {
    return $this->requestId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(StartClusterRequest::class, 'Google_Service_Dataproc_StartClusterRequest');
