<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class Snapshot extends \Google\Collection
{
  /**
   * Default value indicating Architecture is not set.
   */
  public const ARCHITECTURE_ARCHITECTURE_UNSPECIFIED = 'ARCHITECTURE_UNSPECIFIED';
  /**
   * Machines with architecture ARM64
   */
  public const ARCHITECTURE_ARM64 = 'ARM64';
  /**
   * Machines with architecture X86_64
   */
  public const ARCHITECTURE_X86_64 = 'X86_64';
  public const SNAPSHOT_TYPE_ARCHIVE = 'ARCHIVE';
  public const SNAPSHOT_TYPE_STANDARD = 'STANDARD';
  /**
   * Snapshot creation is in progress.
   */
  public const STATUS_CREATING = 'CREATING';
  /**
   * Snapshot is currently being deleted.
   */
  public const STATUS_DELETING = 'DELETING';
  /**
   * Snapshot creation failed.
   */
  public const STATUS_FAILED = 'FAILED';
  /**
   * Snapshot has been created successfully.
   */
  public const STATUS_READY = 'READY';
  /**
   * Snapshot is being uploaded.
   */
  public const STATUS_UPLOADING = 'UPLOADING';
  public const STORAGE_BYTES_STATUS_UPDATING = 'UPDATING';
  public const STORAGE_BYTES_STATUS_UP_TO_DATE = 'UP_TO_DATE';
  protected $collection_key = 'storageLocations';
  /**
   * [Output Only] The architecture of the snapshot. Valid values are ARM64 or
   * X86_64.
   *
   * @var string
   */
  public $architecture;
  /**
   * [Output Only] Set to true if snapshots are automatically created by
   * applying resource policy on the target disk.
   *
   * @var bool
   */
  public $autoCreated;
  /**
   * Creates the new snapshot in the snapshot chain labeled with the specified
   * name. The chain name must be 1-63 characters long and comply with RFC1035.
   * This is an uncommon option only for advanced service owners who needs to
   * create separate snapshot chains, for example, for chargeback tracking. When
   * you describe your snapshot resource, this field is visible only if it has a
   * non-empty value.
   *
   * @var string
   */
  public $chainName;
  /**
   * [Output Only] Size in bytes of the snapshot at creation time.
   *
   * @var string
   */
  public $creationSizeBytes;
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  /**
   * [Output Only] Size of the source disk, specified in GB.
   *
   * @var string
   */
  public $diskSizeGb;
  /**
   * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
   *
   * @var string
   */
  public $downloadBytes;
  /**
   * Whether this snapshot is created from a confidential compute mode disk.
   * [Output Only]: This field is not set by user, but from source disk.
   *
   * @var bool
   */
  public $enableConfidentialCompute;
  /**
   * [Input Only] Whether to attempt an application consistent snapshot by
   * informing the OS to prepare for the snapshot process.
   *
   * @var bool
   */
  public $guestFlush;
  protected $guestOsFeaturesType = GuestOsFeature::class;
  protected $guestOsFeaturesDataType = 'array';
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @var string
   */
  public $id;
  /**
   * [Output Only] Type of the resource. Always compute#snapshot for Snapshot
   * resources.
   *
   * @var string
   */
  public $kind;
  /**
   * A fingerprint for the labels being applied to this snapshot, which is
   * essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a snapshot.
   *
   * @var string
   */
  public $labelFingerprint;
  /**
   * Labels to apply to this snapshot. These can be later modified by the
   * setLabels method. Label values may be empty.
   *
   * @var string[]
   */
  public $labels;
  /**
   * [Output Only] Integer license codes indicating which licenses are attached
   * to this snapshot.
   *
   * @var string[]
   */
  public $licenseCodes;
  /**
   * [Output Only] A list of public visible licenses that apply to this
   * snapshot. This can be because the original image had licenses attached
   * (such as a Windows image).
   *
   * @var string[]
   */
  public $licenses;
  /**
   * An opaque location hint used to place the snapshot close to other
   * resources. This field is for use by internal tools that use the public API.
   *
   * @var string
   */
  public $locationHint;
  /**
   * Name of the resource; provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  protected $paramsType = SnapshotParams::class;
  protected $paramsDataType = '';
  /**
   * Output only. Reserved for future use.
   *
   * @var bool
   */
  public $satisfiesPzi;
  /**
   * [Output Only] Reserved for future use.
   *
   * @var bool
   */
  public $satisfiesPzs;
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @var string
   */
  public $selfLink;
  protected $snapshotEncryptionKeyType = CustomerEncryptionKey::class;
  protected $snapshotEncryptionKeyDataType = '';
  /**
   * Indicates the type of the snapshot.
   *
   * @var string
   */
  public $snapshotType;
  /**
   * The source disk used to create this snapshot.
   *
   * @var string
   */
  public $sourceDisk;
  protected $sourceDiskEncryptionKeyType = CustomerEncryptionKey::class;
  protected $sourceDiskEncryptionKeyDataType = '';
  /**
   * The source disk whose recovery checkpoint will be used to create this
   * snapshot.
   *
   * @var string
   */
  public $sourceDiskForRecoveryCheckpoint;
  /**
   * [Output Only] The ID value of the disk used to create this snapshot. This
   * value may be used to determine whether the snapshot was taken from the
   * current or a previous instance of a given disk name.
   *
   * @var string
   */
  public $sourceDiskId;
  /**
   * The source instant snapshot used to create this snapshot. You can provide
   * this as a partial or full URL to the resource. For example, the following
   * are valid values:              - https://www.googleapis.com/compute/v1/proj
   * ects/project/zones/zone/instantSnapshots/instantSnapshot      -
   * projects/project/zones/zone/instantSnapshots/instantSnapshot     -
   * zones/zone/instantSnapshots/instantSnapshot
   *
   * @var string
   */
  public $sourceInstantSnapshot;
  protected $sourceInstantSnapshotEncryptionKeyType = CustomerEncryptionKey::class;
  protected $sourceInstantSnapshotEncryptionKeyDataType = '';
  /**
   * [Output Only] The unique ID of the instant snapshot used to create this
   * snapshot. This value identifies the exact instant snapshot that was used to
   * create this snapshot. For example, if you created the snapshot from an
   * instant snapshot that was later deleted and recreated under the same name,
   * the source instant snapshot ID would identify the exact instant snapshot
   * that was used.
   *
   * @var string
   */
  public $sourceInstantSnapshotId;
  /**
   * [Output Only] URL of the resource policy which created this scheduled
   * snapshot.
   *
   * @var string
   */
  public $sourceSnapshotSchedulePolicy;
  /**
   * [Output Only] ID of the resource policy which created this scheduled
   * snapshot.
   *
   * @var string
   */
  public $sourceSnapshotSchedulePolicyId;
  /**
   * [Output Only] The status of the snapshot. This can beCREATING, DELETING,
   * FAILED,READY, or UPLOADING.
   *
   * @var string
   */
  public $status;
  /**
   * [Output Only] A size of the storage used by the snapshot. As snapshots
   * share storage, this number is expected to change with snapshot
   * creation/deletion.
   *
   * @var string
   */
  public $storageBytes;
  /**
   * [Output Only] An indicator whether storageBytes is in a stable state or it
   * is being adjusted as a result of shared storage reallocation. This status
   * can either be UPDATING, meaning the size of the snapshot is being updated,
   * or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
   *
   * @var string
   */
  public $storageBytesStatus;
  /**
   * Cloud Storage bucket storage location of the snapshot (regional or multi-
   * regional).
   *
   * @var string[]
   */
  public $storageLocations;

  /**
   * [Output Only] The architecture of the snapshot. Valid values are ARM64 or
   * X86_64.
   *
   * Accepted values: ARCHITECTURE_UNSPECIFIED, ARM64, X86_64
   *
   * @param self::ARCHITECTURE_* $architecture
   */
  public function setArchitecture($architecture)
  {
    $this->architecture = $architecture;
  }
  /**
   * @return self::ARCHITECTURE_*
   */
  public function getArchitecture()
  {
    return $this->architecture;
  }
  /**
   * [Output Only] Set to true if snapshots are automatically created by
   * applying resource policy on the target disk.
   *
   * @param bool $autoCreated
   */
  public function setAutoCreated($autoCreated)
  {
    $this->autoCreated = $autoCreated;
  }
  /**
   * @return bool
   */
  public function getAutoCreated()
  {
    return $this->autoCreated;
  }
  /**
   * Creates the new snapshot in the snapshot chain labeled with the specified
   * name. The chain name must be 1-63 characters long and comply with RFC1035.
   * This is an uncommon option only for advanced service owners who needs to
   * create separate snapshot chains, for example, for chargeback tracking. When
   * you describe your snapshot resource, this field is visible only if it has a
   * non-empty value.
   *
   * @param string $chainName
   */
  public function setChainName($chainName)
  {
    $this->chainName = $chainName;
  }
  /**
   * @return string
   */
  public function getChainName()
  {
    return $this->chainName;
  }
  /**
   * [Output Only] Size in bytes of the snapshot at creation time.
   *
   * @param string $creationSizeBytes
   */
  public function setCreationSizeBytes($creationSizeBytes)
  {
    $this->creationSizeBytes = $creationSizeBytes;
  }
  /**
   * @return string
   */
  public function getCreationSizeBytes()
  {
    return $this->creationSizeBytes;
  }
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * [Output Only] Size of the source disk, specified in GB.
   *
   * @param string $diskSizeGb
   */
  public function setDiskSizeGb($diskSizeGb)
  {
    $this->diskSizeGb = $diskSizeGb;
  }
  /**
   * @return string
   */
  public function getDiskSizeGb()
  {
    return $this->diskSizeGb;
  }
  /**
   * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
   *
   * @param string $downloadBytes
   */
  public function setDownloadBytes($downloadBytes)
  {
    $this->downloadBytes = $downloadBytes;
  }
  /**
   * @return string
   */
  public function getDownloadBytes()
  {
    return $this->downloadBytes;
  }
  /**
   * Whether this snapshot is created from a confidential compute mode disk.
   * [Output Only]: This field is not set by user, but from source disk.
   *
   * @param bool $enableConfidentialCompute
   */
  public function setEnableConfidentialCompute($enableConfidentialCompute)
  {
    $this->enableConfidentialCompute = $enableConfidentialCompute;
  }
  /**
   * @return bool
   */
  public function getEnableConfidentialCompute()
  {
    return $this->enableConfidentialCompute;
  }
  /**
   * [Input Only] Whether to attempt an application consistent snapshot by
   * informing the OS to prepare for the snapshot process.
   *
   * @param bool $guestFlush
   */
  public function setGuestFlush($guestFlush)
  {
    $this->guestFlush = $guestFlush;
  }
  /**
   * @return bool
   */
  public function getGuestFlush()
  {
    return $this->guestFlush;
  }
  /**
   * [Output Only] A list of features to enable on the guest operating system.
   * Applicable only for bootable images. Read  Enabling guest operating system
   * features to see a list of available options.
   *
   * @param GuestOsFeature[] $guestOsFeatures
   */
  public function setGuestOsFeatures($guestOsFeatures)
  {
    $this->guestOsFeatures = $guestOsFeatures;
  }
  /**
   * @return GuestOsFeature[]
   */
  public function getGuestOsFeatures()
  {
    return $this->guestOsFeatures;
  }
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * [Output Only] Type of the resource. Always compute#snapshot for Snapshot
   * resources.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A fingerprint for the labels being applied to this snapshot, which is
   * essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a snapshot.
   *
   * @param string $labelFingerprint
   */
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  /**
   * @return string
   */
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  /**
   * Labels to apply to this snapshot. These can be later modified by the
   * setLabels method. Label values may be empty.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * [Output Only] Integer license codes indicating which licenses are attached
   * to this snapshot.
   *
   * @param string[] $licenseCodes
   */
  public function setLicenseCodes($licenseCodes)
  {
    $this->licenseCodes = $licenseCodes;
  }
  /**
   * @return string[]
   */
  public function getLicenseCodes()
  {
    return $this->licenseCodes;
  }
  /**
   * [Output Only] A list of public visible licenses that apply to this
   * snapshot. This can be because the original image had licenses attached
   * (such as a Windows image).
   *
   * @param string[] $licenses
   */
  public function setLicenses($licenses)
  {
    $this->licenses = $licenses;
  }
  /**
   * @return string[]
   */
  public function getLicenses()
  {
    return $this->licenses;
  }
  /**
   * An opaque location hint used to place the snapshot close to other
   * resources. This field is for use by internal tools that use the public API.
   *
   * @param string $locationHint
   */
  public function setLocationHint($locationHint)
  {
    $this->locationHint = $locationHint;
  }
  /**
   * @return string
   */
  public function getLocationHint()
  {
    return $this->locationHint;
  }
  /**
   * Name of the resource; provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Input only. [Input Only] Additional params passed with the request, but not
   * persisted as part of resource payload.
   *
   * @param SnapshotParams $params
   */
  public function setParams(SnapshotParams $params)
  {
    $this->params = $params;
  }
  /**
   * @return SnapshotParams
   */
  public function getParams()
  {
    return $this->params;
  }
  /**
   * Output only. Reserved for future use.
   *
   * @param bool $satisfiesPzi
   */
  public function setSatisfiesPzi($satisfiesPzi)
  {
    $this->satisfiesPzi = $satisfiesPzi;
  }
  /**
   * @return bool
   */
  public function getSatisfiesPzi()
  {
    return $this->satisfiesPzi;
  }
  /**
   * [Output Only] Reserved for future use.
   *
   * @param bool $satisfiesPzs
   */
  public function setSatisfiesPzs($satisfiesPzs)
  {
    $this->satisfiesPzs = $satisfiesPzs;
  }
  /**
   * @return bool
   */
  public function getSatisfiesPzs()
  {
    return $this->satisfiesPzs;
  }
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * Encrypts the snapshot using acustomer-supplied encryption key.
   *
   * After you encrypt a snapshot using a customer-supplied key, you must
   * provide the same key if you use the snapshot later. For example, you must
   * provide the encryption key when you create a disk from the encrypted
   * snapshot in a future request.
   *
   * Customer-supplied encryption keys do not protect access to metadata of the
   * snapshot.
   *
   * If you do not provide an encryption key when creating the snapshot, then
   * the snapshot will be encrypted using an automatically generated key and you
   * do not need to provide a key to use the snapshot later.
   *
   * @param CustomerEncryptionKey $snapshotEncryptionKey
   */
  public function setSnapshotEncryptionKey(CustomerEncryptionKey $snapshotEncryptionKey)
  {
    $this->snapshotEncryptionKey = $snapshotEncryptionKey;
  }
  /**
   * @return CustomerEncryptionKey
   */
  public function getSnapshotEncryptionKey()
  {
    return $this->snapshotEncryptionKey;
  }
  /**
   * Indicates the type of the snapshot.
   *
   * Accepted values: ARCHIVE, STANDARD
   *
   * @param self::SNAPSHOT_TYPE_* $snapshotType
   */
  public function setSnapshotType($snapshotType)
  {
    $this->snapshotType = $snapshotType;
  }
  /**
   * @return self::SNAPSHOT_TYPE_*
   */
  public function getSnapshotType()
  {
    return $this->snapshotType;
  }
  /**
   * The source disk used to create this snapshot.
   *
   * @param string $sourceDisk
   */
  public function setSourceDisk($sourceDisk)
  {
    $this->sourceDisk = $sourceDisk;
  }
  /**
   * @return string
   */
  public function getSourceDisk()
  {
    return $this->sourceDisk;
  }
  /**
   * The customer-supplied encryption key of the source disk. Required if the
   * source disk is protected by a customer-supplied encryption key.
   *
   * @param CustomerEncryptionKey $sourceDiskEncryptionKey
   */
  public function setSourceDiskEncryptionKey(CustomerEncryptionKey $sourceDiskEncryptionKey)
  {
    $this->sourceDiskEncryptionKey = $sourceDiskEncryptionKey;
  }
  /**
   * @return CustomerEncryptionKey
   */
  public function getSourceDiskEncryptionKey()
  {
    return $this->sourceDiskEncryptionKey;
  }
  /**
   * The source disk whose recovery checkpoint will be used to create this
   * snapshot.
   *
   * @param string $sourceDiskForRecoveryCheckpoint
   */
  public function setSourceDiskForRecoveryCheckpoint($sourceDiskForRecoveryCheckpoint)
  {
    $this->sourceDiskForRecoveryCheckpoint = $sourceDiskForRecoveryCheckpoint;
  }
  /**
   * @return string
   */
  public function getSourceDiskForRecoveryCheckpoint()
  {
    return $this->sourceDiskForRecoveryCheckpoint;
  }
  /**
   * [Output Only] The ID value of the disk used to create this snapshot. This
   * value may be used to determine whether the snapshot was taken from the
   * current or a previous instance of a given disk name.
   *
   * @param string $sourceDiskId
   */
  public function setSourceDiskId($sourceDiskId)
  {
    $this->sourceDiskId = $sourceDiskId;
  }
  /**
   * @return string
   */
  public function getSourceDiskId()
  {
    return $this->sourceDiskId;
  }
  /**
   * The source instant snapshot used to create this snapshot. You can provide
   * this as a partial or full URL to the resource. For example, the following
   * are valid values:              - https://www.googleapis.com/compute/v1/proj
   * ects/project/zones/zone/instantSnapshots/instantSnapshot      -
   * projects/project/zones/zone/instantSnapshots/instantSnapshot     -
   * zones/zone/instantSnapshots/instantSnapshot
   *
   * @param string $sourceInstantSnapshot
   */
  public function setSourceInstantSnapshot($sourceInstantSnapshot)
  {
    $this->sourceInstantSnapshot = $sourceInstantSnapshot;
  }
  /**
   * @return string
   */
  public function getSourceInstantSnapshot()
  {
    return $this->sourceInstantSnapshot;
  }
  /**
   * Customer provided encryption key when creating Snapshot from Instant
   * Snapshot.
   *
   * @param CustomerEncryptionKey $sourceInstantSnapshotEncryptionKey
   */
  public function setSourceInstantSnapshotEncryptionKey(CustomerEncryptionKey $sourceInstantSnapshotEncryptionKey)
  {
    $this->sourceInstantSnapshotEncryptionKey = $sourceInstantSnapshotEncryptionKey;
  }
  /**
   * @return CustomerEncryptionKey
   */
  public function getSourceInstantSnapshotEncryptionKey()
  {
    return $this->sourceInstantSnapshotEncryptionKey;
  }
  /**
   * [Output Only] The unique ID of the instant snapshot used to create this
   * snapshot. This value identifies the exact instant snapshot that was used to
   * create this snapshot. For example, if you created the snapshot from an
   * instant snapshot that was later deleted and recreated under the same name,
   * the source instant snapshot ID would identify the exact instant snapshot
   * that was used.
   *
   * @param string $sourceInstantSnapshotId
   */
  public function setSourceInstantSnapshotId($sourceInstantSnapshotId)
  {
    $this->sourceInstantSnapshotId = $sourceInstantSnapshotId;
  }
  /**
   * @return string
   */
  public function getSourceInstantSnapshotId()
  {
    return $this->sourceInstantSnapshotId;
  }
  /**
   * [Output Only] URL of the resource policy which created this scheduled
   * snapshot.
   *
   * @param string $sourceSnapshotSchedulePolicy
   */
  public function setSourceSnapshotSchedulePolicy($sourceSnapshotSchedulePolicy)
  {
    $this->sourceSnapshotSchedulePolicy = $sourceSnapshotSchedulePolicy;
  }
  /**
   * @return string
   */
  public function getSourceSnapshotSchedulePolicy()
  {
    return $this->sourceSnapshotSchedulePolicy;
  }
  /**
   * [Output Only] ID of the resource policy which created this scheduled
   * snapshot.
   *
   * @param string $sourceSnapshotSchedulePolicyId
   */
  public function setSourceSnapshotSchedulePolicyId($sourceSnapshotSchedulePolicyId)
  {
    $this->sourceSnapshotSchedulePolicyId = $sourceSnapshotSchedulePolicyId;
  }
  /**
   * @return string
   */
  public function getSourceSnapshotSchedulePolicyId()
  {
    return $this->sourceSnapshotSchedulePolicyId;
  }
  /**
   * [Output Only] The status of the snapshot. This can beCREATING, DELETING,
   * FAILED,READY, or UPLOADING.
   *
   * Accepted values: CREATING, DELETING, FAILED, READY, UPLOADING
   *
   * @param self::STATUS_* $status
   */
  public function setStatus($status)
  {
    $this->status = $status;
  }
  /**
   * @return self::STATUS_*
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * [Output Only] A size of the storage used by the snapshot. As snapshots
   * share storage, this number is expected to change with snapshot
   * creation/deletion.
   *
   * @param string $storageBytes
   */
  public function setStorageBytes($storageBytes)
  {
    $this->storageBytes = $storageBytes;
  }
  /**
   * @return string
   */
  public function getStorageBytes()
  {
    return $this->storageBytes;
  }
  /**
   * [Output Only] An indicator whether storageBytes is in a stable state or it
   * is being adjusted as a result of shared storage reallocation. This status
   * can either be UPDATING, meaning the size of the snapshot is being updated,
   * or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
   *
   * Accepted values: UPDATING, UP_TO_DATE
   *
   * @param self::STORAGE_BYTES_STATUS_* $storageBytesStatus
   */
  public function setStorageBytesStatus($storageBytesStatus)
  {
    $this->storageBytesStatus = $storageBytesStatus;
  }
  /**
   * @return self::STORAGE_BYTES_STATUS_*
   */
  public function getStorageBytesStatus()
  {
    return $this->storageBytesStatus;
  }
  /**
   * Cloud Storage bucket storage location of the snapshot (regional or multi-
   * regional).
   *
   * @param string[] $storageLocations
   */
  public function setStorageLocations($storageLocations)
  {
    $this->storageLocations = $storageLocations;
  }
  /**
   * @return string[]
   */
  public function getStorageLocations()
  {
    return $this->storageLocations;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Snapshot::class, 'Google_Service_Compute_Snapshot');
