<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class ExternalVpnGateway extends \Google\Collection
{
  /**
   * The external VPN gateway has four public IP addresses; at the time of
   * writing this API, the AWS virtual private gateway is an example which has
   * four public IP addresses for high availability connections; there should be
   * two VPN connections in the AWS virtual private gateway , each AWS VPN
   * connection has two public IP addresses;  please make sure to put two public
   * IP addresses from one AWS VPN connection into interfaces 0 and 1 of this
   * external VPN gateway, and put the other two public IP addresses from
   * another AWS VPN connection into interfaces 2 and 3 of this external VPN
   * gateway. When displaying highly available configuration status for the VPN
   * tunnels connected to FOUR_IPS_REDUNDANCY external VPN gateway, Google will
   * always detect whether interfaces 0 and 1 are connected on one interface of
   * HA Cloud VPN gateway, and detect whether interfaces 2 and 3 are connected
   * to another interface of the HA Cloud VPN gateway.
   */
  public const REDUNDANCY_TYPE_FOUR_IPS_REDUNDANCY = 'FOUR_IPS_REDUNDANCY';
  /**
   * The external VPN gateway has only one public IP address which internally
   * provide redundancy or failover.
   */
  public const REDUNDANCY_TYPE_SINGLE_IP_INTERNALLY_REDUNDANT = 'SINGLE_IP_INTERNALLY_REDUNDANT';
  /**
   * The external VPN gateway has two public IP addresses which are redundant
   * with each other, the following two types of setup on your on-premises side
   * would have this type of redundancy: (1) Two separate on-premises gateways,
   * each with one public IP address,     the two on-premises gateways are
   * redundant with each other. (2) A single on-premise gateway with two public
   * IP addresses that are     redundant with eatch other.
   */
  public const REDUNDANCY_TYPE_TWO_IPS_REDUNDANCY = 'TWO_IPS_REDUNDANCY';
  protected $collection_key = 'interfaces';
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @var string
   */
  public $id;
  protected $interfacesType = ExternalVpnGatewayInterface::class;
  protected $interfacesDataType = 'array';
  /**
   * [Output Only] Type of the resource. Alwayscompute#externalVpnGateway for
   * externalVpnGateways.
   *
   * @var string
   */
  public $kind;
  /**
   * A fingerprint for the labels being applied to this ExternalVpnGateway,
   * which is essentially a hash of the labels set used for optimistic locking.
   * The fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve an
   * ExternalVpnGateway.
   *
   * @var string
   */
  public $labelFingerprint;
  /**
   * Labels for this resource. These can only be added or modified by
   * thesetLabels method. Each label key/value pair must comply withRFC1035.
   * Label values may be empty.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  /**
   * Indicates the user-supplied redundancy type of this external VPN gateway.
   *
   * @var string
   */
  public $redundancyType;
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @var string
   */
  public $selfLink;

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * A list of interfaces for this external VPN gateway.
   *
   * If your peer-side gateway is an on-premises gateway and non-AWS cloud
   * providers' gateway, at most two interfaces can be provided for an external
   * VPN gateway. If your peer side is an AWS virtual private gateway, four
   * interfaces should be provided for an external VPN gateway.
   *
   * @param ExternalVpnGatewayInterface[] $interfaces
   */
  public function setInterfaces($interfaces)
  {
    $this->interfaces = $interfaces;
  }
  /**
   * @return ExternalVpnGatewayInterface[]
   */
  public function getInterfaces()
  {
    return $this->interfaces;
  }
  /**
   * [Output Only] Type of the resource. Alwayscompute#externalVpnGateway for
   * externalVpnGateways.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A fingerprint for the labels being applied to this ExternalVpnGateway,
   * which is essentially a hash of the labels set used for optimistic locking.
   * The fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve an
   * ExternalVpnGateway.
   *
   * @param string $labelFingerprint
   */
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  /**
   * @return string
   */
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  /**
   * Labels for this resource. These can only be added or modified by
   * thesetLabels method. Each label key/value pair must comply withRFC1035.
   * Label values may be empty.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Indicates the user-supplied redundancy type of this external VPN gateway.
   *
   * Accepted values: FOUR_IPS_REDUNDANCY, SINGLE_IP_INTERNALLY_REDUNDANT,
   * TWO_IPS_REDUNDANCY
   *
   * @param self::REDUNDANCY_TYPE_* $redundancyType
   */
  public function setRedundancyType($redundancyType)
  {
    $this->redundancyType = $redundancyType;
  }
  /**
   * @return self::REDUNDANCY_TYPE_*
   */
  public function getRedundancyType()
  {
    return $this->redundancyType;
  }
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ExternalVpnGateway::class, 'Google_Service_Compute_ExternalVpnGateway');
