<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudTalentSolution;

class JobEvent extends \Google\Collection
{
  /**
   * The event is unspecified by other provided values.
   */
  public const TYPE_JOB_EVENT_TYPE_UNSPECIFIED = 'JOB_EVENT_TYPE_UNSPECIFIED';
  /**
   * The job seeker or other entity interacting with the service has had a job
   * rendered in their view, such as in a list of search results in a compressed
   * or clipped format. This event is typically associated with the viewing of a
   * jobs list on a single page by a job seeker.
   */
  public const TYPE_IMPRESSION = 'IMPRESSION';
  /**
   * The job seeker, or other entity interacting with the service, has viewed
   * the details of a job, including the full description. This event doesn't
   * apply to the viewing a snippet of a job appearing as a part of the job
   * search results. Viewing a snippet is associated with an impression).
   */
  public const TYPE_VIEW = 'VIEW';
  /**
   * The job seeker or other entity interacting with the service performed an
   * action to view a job and was redirected to a different website for job.
   */
  public const TYPE_VIEW_REDIRECT = 'VIEW_REDIRECT';
  /**
   * The job seeker or other entity interacting with the service began the
   * process or demonstrated the intention of applying for a job.
   */
  public const TYPE_APPLICATION_START = 'APPLICATION_START';
  /**
   * The job seeker or other entity interacting with the service submitted an
   * application for a job.
   */
  public const TYPE_APPLICATION_FINISH = 'APPLICATION_FINISH';
  /**
   * The job seeker or other entity interacting with the service submitted an
   * application for a job with a single click without entering information. If
   * a job seeker performs this action, send only this event to the service. Do
   * not also send JobEventType.APPLICATION_START or
   * JobEventType.APPLICATION_FINISH events.
   */
  public const TYPE_APPLICATION_QUICK_SUBMISSION = 'APPLICATION_QUICK_SUBMISSION';
  /**
   * The job seeker or other entity interacting with the service performed an
   * action to apply to a job and was redirected to a different website to
   * complete the application.
   */
  public const TYPE_APPLICATION_REDIRECT = 'APPLICATION_REDIRECT';
  /**
   * The job seeker or other entity interacting with the service began the
   * process or demonstrated the intention of applying for a job from the search
   * results page without viewing the details of the job posting. If sending
   * this event, JobEventType.VIEW event shouldn't be sent.
   */
  public const TYPE_APPLICATION_START_FROM_SEARCH = 'APPLICATION_START_FROM_SEARCH';
  /**
   * The job seeker, or other entity interacting with the service, performs an
   * action with a single click from the search results page to apply to a job
   * (without viewing the details of the job posting), and is redirected to a
   * different website to complete the application. If a candidate performs this
   * action, send only this event to the service. Do not also send
   * JobEventType.APPLICATION_START, JobEventType.APPLICATION_FINISH or
   * JobEventType.VIEW events.
   */
  public const TYPE_APPLICATION_REDIRECT_FROM_SEARCH = 'APPLICATION_REDIRECT_FROM_SEARCH';
  /**
   * This event should be used when a company submits an application on behalf
   * of a job seeker. This event is intended for use by staffing agencies
   * attempting to place candidates.
   */
  public const TYPE_APPLICATION_COMPANY_SUBMIT = 'APPLICATION_COMPANY_SUBMIT';
  /**
   * The job seeker or other entity interacting with the service demonstrated an
   * interest in a job by bookmarking or saving it.
   */
  public const TYPE_BOOKMARK = 'BOOKMARK';
  /**
   * The job seeker or other entity interacting with the service was sent a
   * notification, such as an email alert or device notification, containing one
   * or more jobs listings generated by the service.
   */
  public const TYPE_NOTIFICATION = 'NOTIFICATION';
  /**
   * The job seeker or other entity interacting with the service was employed by
   * the hiring entity (employer). Send this event only if the job seeker was
   * hired through an application that was initiated by a search conducted
   * through the Cloud Talent Solution service.
   */
  public const TYPE_HIRED = 'HIRED';
  /**
   * A recruiter or staffing agency submitted an application on behalf of the
   * candidate after interacting with the service to identify a suitable job
   * posting.
   */
  public const TYPE_SENT_CV = 'SENT_CV';
  /**
   * The entity interacting with the service (for example, the job seeker), was
   * granted an initial interview by the hiring entity (employer). This event
   * should only be sent if the job seeker was granted an interview as part of
   * an application that was initiated by a search conducted through /
   * recommendation provided by the Cloud Talent Solution service.
   */
  public const TYPE_INTERVIEW_GRANTED = 'INTERVIEW_GRANTED';
  protected $collection_key = 'jobs';
  /**
   * Required. The job name(s) associated with this event. For example, if this
   * is an impression event, this field contains the identifiers of all jobs
   * shown to the job seeker. If this was a view event, this field contains the
   * identifier of the viewed job. The format is
   * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}", for example,
   * "projects/foo/tenants/bar/jobs/baz".
   *
   * @var string[]
   */
  public $jobs;
  /**
   * Required. The type of the event (see JobEventType).
   *
   * @var string
   */
  public $type;

  /**
   * Required. The job name(s) associated with this event. For example, if this
   * is an impression event, this field contains the identifiers of all jobs
   * shown to the job seeker. If this was a view event, this field contains the
   * identifier of the viewed job. The format is
   * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}", for example,
   * "projects/foo/tenants/bar/jobs/baz".
   *
   * @param string[] $jobs
   */
  public function setJobs($jobs)
  {
    $this->jobs = $jobs;
  }
  /**
   * @return string[]
   */
  public function getJobs()
  {
    return $this->jobs;
  }
  /**
   * Required. The type of the event (see JobEventType).
   *
   * Accepted values: JOB_EVENT_TYPE_UNSPECIFIED, IMPRESSION, VIEW,
   * VIEW_REDIRECT, APPLICATION_START, APPLICATION_FINISH,
   * APPLICATION_QUICK_SUBMISSION, APPLICATION_REDIRECT,
   * APPLICATION_START_FROM_SEARCH, APPLICATION_REDIRECT_FROM_SEARCH,
   * APPLICATION_COMPANY_SUBMIT, BOOKMARK, NOTIFICATION, HIRED, SENT_CV,
   * INTERVIEW_GRANTED
   *
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(JobEvent::class, 'Google_Service_CloudTalentSolution_JobEvent');
