<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly extends \Google\Model
{
  /**
   * If it's OBJECTIVE_UNSPECIFIED, monitoring_stats will be empty.
   */
  public const OBJECTIVE_OBJECTIVE_UNSPECIFIED = 'OBJECTIVE_UNSPECIFIED';
  /**
   * Stats are generated by Import Feature Analysis.
   */
  public const OBJECTIVE_IMPORT_FEATURE_ANALYSIS = 'IMPORT_FEATURE_ANALYSIS';
  /**
   * Stats are generated by Snapshot Analysis.
   */
  public const OBJECTIVE_SNAPSHOT_ANALYSIS = 'SNAPSHOT_ANALYSIS';
  protected $featureStatsAnomalyType = GoogleCloudAiplatformV1FeatureStatsAnomaly::class;
  protected $featureStatsAnomalyDataType = '';
  /**
   * Output only. The objective for each stats.
   *
   * @var string
   */
  public $objective;

  /**
   * Output only. The stats and anomalies generated at specific timestamp.
   *
   * @param GoogleCloudAiplatformV1FeatureStatsAnomaly $featureStatsAnomaly
   */
  public function setFeatureStatsAnomaly(GoogleCloudAiplatformV1FeatureStatsAnomaly $featureStatsAnomaly)
  {
    $this->featureStatsAnomaly = $featureStatsAnomaly;
  }
  /**
   * @return GoogleCloudAiplatformV1FeatureStatsAnomaly
   */
  public function getFeatureStatsAnomaly()
  {
    return $this->featureStatsAnomaly;
  }
  /**
   * Output only. The objective for each stats.
   *
   * Accepted values: OBJECTIVE_UNSPECIFIED, IMPORT_FEATURE_ANALYSIS,
   * SNAPSHOT_ANALYSIS
   *
   * @param self::OBJECTIVE_* $objective
   */
  public function setObjective($objective)
  {
    $this->objective = $objective;
  }
  /**
   * @return self::OBJECTIVE_*
   */
  public function getObjective()
  {
    return $this->objective;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly::class, 'Google_Service_Aiplatform_GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly');
