<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Monitoring;

class CreateCollectdTimeSeriesResponse extends \Google\Collection
{
  protected $collection_key = 'payloadErrors';
  protected $payloadErrorsType = CollectdPayloadError::class;
  protected $payloadErrorsDataType = 'array';
  protected $summaryType = CreateTimeSeriesSummary::class;
  protected $summaryDataType = '';

  /**
   * Records the error status for points that were not written due to an error
   * in the request.Failed requests for which nothing is written will return an
   * error response instead. Requests where data points were rejected by the
   * backend will set summary instead.
   *
   * @param CollectdPayloadError[] $payloadErrors
   */
  public function setPayloadErrors($payloadErrors)
  {
    $this->payloadErrors = $payloadErrors;
  }
  /**
   * @return CollectdPayloadError[]
   */
  public function getPayloadErrors()
  {
    return $this->payloadErrors;
  }
  /**
   * Aggregate statistics from writing the payloads. This field is omitted if
   * all points were successfully written, so that the response is empty. This
   * is for backwards compatibility with clients that log errors on any non-
   * empty response.
   *
   * @param CreateTimeSeriesSummary $summary
   */
  public function setSummary(CreateTimeSeriesSummary $summary)
  {
    $this->summary = $summary;
  }
  /**
   * @return CreateTimeSeriesSummary
   */
  public function getSummary()
  {
    return $this->summary;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CreateCollectdTimeSeriesResponse::class, 'Google_Service_Monitoring_CreateCollectdTimeSeriesResponse');
