<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Docs;

class ListProperties extends \Google\Collection
{
  protected $collection_key = 'nestingLevels';
  protected $nestingLevelsType = NestingLevel::class;
  protected $nestingLevelsDataType = 'array';

  /**
   * Describes the properties of the bullets at the associated level. A list has
   * at most 9 levels of nesting with nesting level 0 corresponding to the top-
   * most level and nesting level 8 corresponding to the most nested level. The
   * nesting levels are returned in ascending order with the least nested
   * returned first.
   *
   * @param NestingLevel[] $nestingLevels
   */
  public function setNestingLevels($nestingLevels)
  {
    $this->nestingLevels = $nestingLevels;
  }
  /**
   * @return NestingLevel[]
   */
  public function getNestingLevels()
  {
    return $this->nestingLevels;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListProperties::class, 'Google_Service_Docs_ListProperties');
