<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\OnDemandScanning;

class VulnerabilityOccurrence extends \Google\Collection
{
  public const CVSS_VERSION_CVSS_VERSION_UNSPECIFIED = 'CVSS_VERSION_UNSPECIFIED';
  public const CVSS_VERSION_CVSS_VERSION_2 = 'CVSS_VERSION_2';
  public const CVSS_VERSION_CVSS_VERSION_3 = 'CVSS_VERSION_3';
  /**
   * Unknown.
   */
  public const EFFECTIVE_SEVERITY_SEVERITY_UNSPECIFIED = 'SEVERITY_UNSPECIFIED';
  /**
   * Minimal severity.
   */
  public const EFFECTIVE_SEVERITY_MINIMAL = 'MINIMAL';
  /**
   * Low severity.
   */
  public const EFFECTIVE_SEVERITY_LOW = 'LOW';
  /**
   * Medium severity.
   */
  public const EFFECTIVE_SEVERITY_MEDIUM = 'MEDIUM';
  /**
   * High severity.
   */
  public const EFFECTIVE_SEVERITY_HIGH = 'HIGH';
  /**
   * Critical severity.
   */
  public const EFFECTIVE_SEVERITY_CRITICAL = 'CRITICAL';
  /**
   * Unknown.
   */
  public const SEVERITY_SEVERITY_UNSPECIFIED = 'SEVERITY_UNSPECIFIED';
  /**
   * Minimal severity.
   */
  public const SEVERITY_MINIMAL = 'MINIMAL';
  /**
   * Low severity.
   */
  public const SEVERITY_LOW = 'LOW';
  /**
   * Medium severity.
   */
  public const SEVERITY_MEDIUM = 'MEDIUM';
  /**
   * High severity.
   */
  public const SEVERITY_HIGH = 'HIGH';
  /**
   * Critical severity.
   */
  public const SEVERITY_CRITICAL = 'CRITICAL';
  protected $collection_key = 'relatedUrls';
  /**
   * Output only. The CVSS score of this vulnerability. CVSS score is on a scale
   * of 0 - 10 where 0 indicates low severity and 10 indicates high severity.
   *
   * @var float
   */
  public $cvssScore;
  protected $cvssV2Type = CVSS::class;
  protected $cvssV2DataType = '';
  /**
   * Output only. CVSS version used to populate cvss_score and severity.
   *
   * @var string
   */
  public $cvssVersion;
  protected $cvssv3Type = CVSS::class;
  protected $cvssv3DataType = '';
  /**
   * The distro assigned severity for this vulnerability when it is available,
   * otherwise this is the note provider assigned severity. When there are
   * multiple PackageIssues for this vulnerability, they can have different
   * effective severities because some might be provided by the distro while
   * others are provided by the language ecosystem for a language pack. For this
   * reason, it is advised to use the effective severity on the PackageIssue
   * level. In the case where multiple PackageIssues have differing effective
   * severities, this field should be the highest severity for any of the
   * PackageIssues.
   *
   * @var string
   */
  public $effectiveSeverity;
  /**
   * Occurrence-specific extra details about the vulnerability.
   *
   * @var string
   */
  public $extraDetails;
  /**
   * Output only. Whether at least one of the affected packages has a fix
   * available.
   *
   * @var bool
   */
  public $fixAvailable;
  /**
   * Output only. A detailed description of this vulnerability.
   *
   * @var string
   */
  public $longDescription;
  protected $packageIssueType = PackageIssue::class;
  protected $packageIssueDataType = 'array';
  protected $relatedUrlsType = RelatedUrl::class;
  protected $relatedUrlsDataType = 'array';
  protected $riskType = Risk::class;
  protected $riskDataType = '';
  /**
   * Output only. The note provider assigned severity of this vulnerability.
   *
   * @var string
   */
  public $severity;
  /**
   * Output only. A one sentence description of this vulnerability.
   *
   * @var string
   */
  public $shortDescription;
  /**
   * The type of package; whether native or non native (e.g., ruby gems, node.js
   * packages, etc.).
   *
   * @var string
   */
  public $type;
  protected $vexAssessmentType = VexAssessment::class;
  protected $vexAssessmentDataType = '';

  /**
   * Output only. The CVSS score of this vulnerability. CVSS score is on a scale
   * of 0 - 10 where 0 indicates low severity and 10 indicates high severity.
   *
   * @param float $cvssScore
   */
  public function setCvssScore($cvssScore)
  {
    $this->cvssScore = $cvssScore;
  }
  /**
   * @return float
   */
  public function getCvssScore()
  {
    return $this->cvssScore;
  }
  /**
   * The cvss v2 score for the vulnerability.
   *
   * @param CVSS $cvssV2
   */
  public function setCvssV2(CVSS $cvssV2)
  {
    $this->cvssV2 = $cvssV2;
  }
  /**
   * @return CVSS
   */
  public function getCvssV2()
  {
    return $this->cvssV2;
  }
  /**
   * Output only. CVSS version used to populate cvss_score and severity.
   *
   * Accepted values: CVSS_VERSION_UNSPECIFIED, CVSS_VERSION_2, CVSS_VERSION_3
   *
   * @param self::CVSS_VERSION_* $cvssVersion
   */
  public function setCvssVersion($cvssVersion)
  {
    $this->cvssVersion = $cvssVersion;
  }
  /**
   * @return self::CVSS_VERSION_*
   */
  public function getCvssVersion()
  {
    return $this->cvssVersion;
  }
  /**
   * The cvss v3 score for the vulnerability.
   *
   * @param CVSS $cvssv3
   */
  public function setCvssv3(CVSS $cvssv3)
  {
    $this->cvssv3 = $cvssv3;
  }
  /**
   * @return CVSS
   */
  public function getCvssv3()
  {
    return $this->cvssv3;
  }
  /**
   * The distro assigned severity for this vulnerability when it is available,
   * otherwise this is the note provider assigned severity. When there are
   * multiple PackageIssues for this vulnerability, they can have different
   * effective severities because some might be provided by the distro while
   * others are provided by the language ecosystem for a language pack. For this
   * reason, it is advised to use the effective severity on the PackageIssue
   * level. In the case where multiple PackageIssues have differing effective
   * severities, this field should be the highest severity for any of the
   * PackageIssues.
   *
   * Accepted values: SEVERITY_UNSPECIFIED, MINIMAL, LOW, MEDIUM, HIGH, CRITICAL
   *
   * @param self::EFFECTIVE_SEVERITY_* $effectiveSeverity
   */
  public function setEffectiveSeverity($effectiveSeverity)
  {
    $this->effectiveSeverity = $effectiveSeverity;
  }
  /**
   * @return self::EFFECTIVE_SEVERITY_*
   */
  public function getEffectiveSeverity()
  {
    return $this->effectiveSeverity;
  }
  /**
   * Occurrence-specific extra details about the vulnerability.
   *
   * @param string $extraDetails
   */
  public function setExtraDetails($extraDetails)
  {
    $this->extraDetails = $extraDetails;
  }
  /**
   * @return string
   */
  public function getExtraDetails()
  {
    return $this->extraDetails;
  }
  /**
   * Output only. Whether at least one of the affected packages has a fix
   * available.
   *
   * @param bool $fixAvailable
   */
  public function setFixAvailable($fixAvailable)
  {
    $this->fixAvailable = $fixAvailable;
  }
  /**
   * @return bool
   */
  public function getFixAvailable()
  {
    return $this->fixAvailable;
  }
  /**
   * Output only. A detailed description of this vulnerability.
   *
   * @param string $longDescription
   */
  public function setLongDescription($longDescription)
  {
    $this->longDescription = $longDescription;
  }
  /**
   * @return string
   */
  public function getLongDescription()
  {
    return $this->longDescription;
  }
  /**
   * Required. The set of affected locations and their fixes (if available)
   * within the associated resource.
   *
   * @param PackageIssue[] $packageIssue
   */
  public function setPackageIssue($packageIssue)
  {
    $this->packageIssue = $packageIssue;
  }
  /**
   * @return PackageIssue[]
   */
  public function getPackageIssue()
  {
    return $this->packageIssue;
  }
  /**
   * Output only. URLs related to this vulnerability.
   *
   * @param RelatedUrl[] $relatedUrls
   */
  public function setRelatedUrls($relatedUrls)
  {
    $this->relatedUrls = $relatedUrls;
  }
  /**
   * @return RelatedUrl[]
   */
  public function getRelatedUrls()
  {
    return $this->relatedUrls;
  }
  /**
   * Risk information about the vulnerability, such as CISA, EPSS, etc.
   *
   * @param Risk $risk
   */
  public function setRisk(Risk $risk)
  {
    $this->risk = $risk;
  }
  /**
   * @return Risk
   */
  public function getRisk()
  {
    return $this->risk;
  }
  /**
   * Output only. The note provider assigned severity of this vulnerability.
   *
   * Accepted values: SEVERITY_UNSPECIFIED, MINIMAL, LOW, MEDIUM, HIGH, CRITICAL
   *
   * @param self::SEVERITY_* $severity
   */
  public function setSeverity($severity)
  {
    $this->severity = $severity;
  }
  /**
   * @return self::SEVERITY_*
   */
  public function getSeverity()
  {
    return $this->severity;
  }
  /**
   * Output only. A one sentence description of this vulnerability.
   *
   * @param string $shortDescription
   */
  public function setShortDescription($shortDescription)
  {
    $this->shortDescription = $shortDescription;
  }
  /**
   * @return string
   */
  public function getShortDescription()
  {
    return $this->shortDescription;
  }
  /**
   * The type of package; whether native or non native (e.g., ruby gems, node.js
   * packages, etc.).
   *
   * @param string $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * @param VexAssessment $vexAssessment
   */
  public function setVexAssessment(VexAssessment $vexAssessment)
  {
    $this->vexAssessment = $vexAssessment;
  }
  /**
   * @return VexAssessment
   */
  public function getVexAssessment()
  {
    return $this->vexAssessment;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VulnerabilityOccurrence::class, 'Google_Service_OnDemandScanning_VulnerabilityOccurrence');
