<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DisplayVideo;

class GeoRegionSearchTerms extends \Google\Model
{
  /**
   * The search query for the desired geo region. The query can be a prefix,
   * e.g. "New Yor", "Seattle", "USA", etc.
   *
   * @var string
   */
  public $geoRegionQuery;

  /**
   * The search query for the desired geo region. The query can be a prefix,
   * e.g. "New Yor", "Seattle", "USA", etc.
   *
   * @param string $geoRegionQuery
   */
  public function setGeoRegionQuery($geoRegionQuery)
  {
    $this->geoRegionQuery = $geoRegionQuery;
  }
  /**
   * @return string
   */
  public function getGeoRegionQuery()
  {
    return $this->geoRegionQuery;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GeoRegionSearchTerms::class, 'Google_Service_DisplayVideo_GeoRegionSearchTerms');
