<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudSearch;

class SafeUrlProto extends \Google\Model
{
  /**
   * IMPORTANT: Never set or read this field, even from tests, it is private.
   * See documentation at the top of .proto file for programming language
   * packages with which to create or read this message.
   *
   * @var string
   */
  public $privateDoNotAccessOrElseSafeUrlWrappedValue;

  /**
   * IMPORTANT: Never set or read this field, even from tests, it is private.
   * See documentation at the top of .proto file for programming language
   * packages with which to create or read this message.
   *
   * @param string $privateDoNotAccessOrElseSafeUrlWrappedValue
   */
  public function setPrivateDoNotAccessOrElseSafeUrlWrappedValue($privateDoNotAccessOrElseSafeUrlWrappedValue)
  {
    $this->privateDoNotAccessOrElseSafeUrlWrappedValue = $privateDoNotAccessOrElseSafeUrlWrappedValue;
  }
  /**
   * @return string
   */
  public function getPrivateDoNotAccessOrElseSafeUrlWrappedValue()
  {
    return $this->privateDoNotAccessOrElseSafeUrlWrappedValue;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SafeUrlProto::class, 'Google_Service_CloudSearch_SafeUrlProto');
