<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRedis;

class ResourceMaintenanceInfo extends \Google\Collection
{
  /**
   * Unspecified state.
   */
  public const MAINTENANCE_STATE_MAINTENANCE_STATE_UNSPECIFIED = 'MAINTENANCE_STATE_UNSPECIFIED';
  /**
   * Database resource is being created.
   */
  public const MAINTENANCE_STATE_CREATING = 'CREATING';
  /**
   * Database resource has been created and is ready to use.
   */
  public const MAINTENANCE_STATE_READY = 'READY';
  /**
   * Database resource is being updated.
   */
  public const MAINTENANCE_STATE_UPDATING = 'UPDATING';
  /**
   * Database resource is unheathy and under repair.
   */
  public const MAINTENANCE_STATE_REPAIRING = 'REPAIRING';
  /**
   * Database resource is being deleted.
   */
  public const MAINTENANCE_STATE_DELETING = 'DELETING';
  /**
   * Database resource encountered an error and is in indeterministic state.
   */
  public const MAINTENANCE_STATE_ERROR = 'ERROR';
  protected $collection_key = 'denyMaintenanceSchedules';
  protected $denyMaintenanceSchedulesType = ResourceMaintenanceDenySchedule::class;
  protected $denyMaintenanceSchedulesDataType = 'array';
  /**
   * Optional. Whether the instance is in stopped state. This information is
   * temporarily being captured in maintenanceInfo, till STOPPED state is
   * supported by DB Center.
   *
   * @var bool
   */
  public $isInstanceStopped;
  protected $maintenanceScheduleType = ResourceMaintenanceSchedule::class;
  protected $maintenanceScheduleDataType = '';
  /**
   * Output only. Current state of maintenance on the database resource.
   *
   * @var string
   */
  public $maintenanceState;
  /**
   * Optional. Current Maintenance version of the database resource. Example:
   * "MYSQL_8_0_41.R20250531.01_15"
   *
   * @var string
   */
  public $maintenanceVersion;
  protected $upcomingMaintenanceType = UpcomingMaintenance::class;
  protected $upcomingMaintenanceDataType = '';
  /**
   * Optional. This field will contain the date when the last version update was
   * applied to the database resource. This will be used to calculate the age of
   * the maintenance version.
   *
   * @var string
   */
  public $versionUpdateTime;

  /**
   * Optional. List of Deny maintenance period for the database resource.
   *
   * @param ResourceMaintenanceDenySchedule[] $denyMaintenanceSchedules
   */
  public function setDenyMaintenanceSchedules($denyMaintenanceSchedules)
  {
    $this->denyMaintenanceSchedules = $denyMaintenanceSchedules;
  }
  /**
   * @return ResourceMaintenanceDenySchedule[]
   */
  public function getDenyMaintenanceSchedules()
  {
    return $this->denyMaintenanceSchedules;
  }
  /**
   * Optional. Whether the instance is in stopped state. This information is
   * temporarily being captured in maintenanceInfo, till STOPPED state is
   * supported by DB Center.
   *
   * @param bool $isInstanceStopped
   */
  public function setIsInstanceStopped($isInstanceStopped)
  {
    $this->isInstanceStopped = $isInstanceStopped;
  }
  /**
   * @return bool
   */
  public function getIsInstanceStopped()
  {
    return $this->isInstanceStopped;
  }
  /**
   * Optional. Maintenance window for the database resource.
   *
   * @param ResourceMaintenanceSchedule $maintenanceSchedule
   */
  public function setMaintenanceSchedule(ResourceMaintenanceSchedule $maintenanceSchedule)
  {
    $this->maintenanceSchedule = $maintenanceSchedule;
  }
  /**
   * @return ResourceMaintenanceSchedule
   */
  public function getMaintenanceSchedule()
  {
    return $this->maintenanceSchedule;
  }
  /**
   * Output only. Current state of maintenance on the database resource.
   *
   * Accepted values: MAINTENANCE_STATE_UNSPECIFIED, CREATING, READY, UPDATING,
   * REPAIRING, DELETING, ERROR
   *
   * @param self::MAINTENANCE_STATE_* $maintenanceState
   */
  public function setMaintenanceState($maintenanceState)
  {
    $this->maintenanceState = $maintenanceState;
  }
  /**
   * @return self::MAINTENANCE_STATE_*
   */
  public function getMaintenanceState()
  {
    return $this->maintenanceState;
  }
  /**
   * Optional. Current Maintenance version of the database resource. Example:
   * "MYSQL_8_0_41.R20250531.01_15"
   *
   * @param string $maintenanceVersion
   */
  public function setMaintenanceVersion($maintenanceVersion)
  {
    $this->maintenanceVersion = $maintenanceVersion;
  }
  /**
   * @return string
   */
  public function getMaintenanceVersion()
  {
    return $this->maintenanceVersion;
  }
  /**
   * Optional. Upcoming maintenance for the database resource. This field is
   * populated once SLM generates and publishes upcoming maintenance window.
   *
   * @param UpcomingMaintenance $upcomingMaintenance
   */
  public function setUpcomingMaintenance(UpcomingMaintenance $upcomingMaintenance)
  {
    $this->upcomingMaintenance = $upcomingMaintenance;
  }
  /**
   * @return UpcomingMaintenance
   */
  public function getUpcomingMaintenance()
  {
    return $this->upcomingMaintenance;
  }
  /**
   * Optional. This field will contain the date when the last version update was
   * applied to the database resource. This will be used to calculate the age of
   * the maintenance version.
   *
   * @param string $versionUpdateTime
   */
  public function setVersionUpdateTime($versionUpdateTime)
  {
    $this->versionUpdateTime = $versionUpdateTime;
  }
  /**
   * @return string
   */
  public function getVersionUpdateTime()
  {
    return $this->versionUpdateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ResourceMaintenanceInfo::class, 'Google_Service_CloudRedis_ResourceMaintenanceInfo');
