<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidPublisher;

class BatchUpdateOneTimeProductsRequest extends \Google\Collection
{
  protected $collection_key = 'requests';
  protected $requestsType = UpdateOneTimeProductRequest::class;
  protected $requestsDataType = 'array';

  /**
   * Required. A list of update requests of up to 100 elements. All requests
   * must update different one-time products.
   *
   * @param UpdateOneTimeProductRequest[] $requests
   */
  public function setRequests($requests)
  {
    $this->requests = $requests;
  }
  /**
   * @return UpdateOneTimeProductRequest[]
   */
  public function getRequests()
  {
    return $this->requests;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BatchUpdateOneTimeProductsRequest::class, 'Google_Service_AndroidPublisher_BatchUpdateOneTimeProductsRequest');
