<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DLP;

class GooglePrivacyDlpV2RecordSuppression extends \Google\Model
{
  protected $conditionType = GooglePrivacyDlpV2RecordCondition::class;
  protected $conditionDataType = '';

  /**
   * A condition that when it evaluates to true will result in the record being
   * evaluated to be suppressed from the transformed content.
   *
   * @param GooglePrivacyDlpV2RecordCondition $condition
   */
  public function setCondition(GooglePrivacyDlpV2RecordCondition $condition)
  {
    $this->condition = $condition;
  }
  /**
   * @return GooglePrivacyDlpV2RecordCondition
   */
  public function getCondition()
  {
    return $this->condition;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GooglePrivacyDlpV2RecordSuppression::class, 'Google_Service_DLP_GooglePrivacyDlpV2RecordSuppression');
