<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DLP;

class GooglePrivacyDlpV2InspectionRule extends \Google\Model
{
  protected $exclusionRuleType = GooglePrivacyDlpV2ExclusionRule::class;
  protected $exclusionRuleDataType = '';
  protected $hotwordRuleType = GooglePrivacyDlpV2HotwordRule::class;
  protected $hotwordRuleDataType = '';

  /**
   * Exclusion rule.
   *
   * @param GooglePrivacyDlpV2ExclusionRule $exclusionRule
   */
  public function setExclusionRule(GooglePrivacyDlpV2ExclusionRule $exclusionRule)
  {
    $this->exclusionRule = $exclusionRule;
  }
  /**
   * @return GooglePrivacyDlpV2ExclusionRule
   */
  public function getExclusionRule()
  {
    return $this->exclusionRule;
  }
  /**
   * Hotword-based detection rule.
   *
   * @param GooglePrivacyDlpV2HotwordRule $hotwordRule
   */
  public function setHotwordRule(GooglePrivacyDlpV2HotwordRule $hotwordRule)
  {
    $this->hotwordRule = $hotwordRule;
  }
  /**
   * @return GooglePrivacyDlpV2HotwordRule
   */
  public function getHotwordRule()
  {
    return $this->hotwordRule;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GooglePrivacyDlpV2InspectionRule::class, 'Google_Service_DLP_GooglePrivacyDlpV2InspectionRule');
