<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CertificateAuthorityService;

class PublicKey extends \Google\Model
{
  /**
   * Default unspecified value.
   */
  public const FORMAT_KEY_FORMAT_UNSPECIFIED = 'KEY_FORMAT_UNSPECIFIED';
  /**
   * The key is PEM-encoded as defined in [RFC
   * 7468](https://tools.ietf.org/html/rfc7468). It can be any of the following:
   * a PEM-encoded PKCS#1/RFC 3447 RSAPublicKey structure, an RFC 5280
   * [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#section-4.1) or
   * a PEM-encoded X.509 certificate signing request (CSR). If a
   * [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#section-4.1) is
   * specified, it can contain a A PEM-encoded PKCS#1/RFC 3447 RSAPublicKey or a
   * NIST P-256/secp256r1/prime256v1 or P-384 key. If a CSR is specified, it
   * will used solely for the purpose of extracting the public key. When
   * generated by the service, it will always be an RFC 5280
   * [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#section-4.1)
   * structure containing an algorithm identifier and a key.
   */
  public const FORMAT_PEM = 'PEM';
  /**
   * Required. The format of the public key.
   *
   * @var string
   */
  public $format;
  /**
   * Required. A public key. The padding and encoding must match with the
   * `KeyFormat` value specified for the `format` field.
   *
   * @var string
   */
  public $key;

  /**
   * Required. The format of the public key.
   *
   * Accepted values: KEY_FORMAT_UNSPECIFIED, PEM
   *
   * @param self::FORMAT_* $format
   */
  public function setFormat($format)
  {
    $this->format = $format;
  }
  /**
   * @return self::FORMAT_*
   */
  public function getFormat()
  {
    return $this->format;
  }
  /**
   * Required. A public key. The padding and encoding must match with the
   * `KeyFormat` value specified for the `format` field.
   *
   * @param string $key
   */
  public function setKey($key)
  {
    $this->key = $key;
  }
  /**
   * @return string
   */
  public function getKey()
  {
    return $this->key;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PublicKey::class, 'Google_Service_CertificateAuthorityService_PublicKey');
