<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Appengine;

class UrlDispatchRule extends \Google\Model
{
  /**
   * Domain name to match against. The wildcard "*" is supported if specified
   * before a period: "*.".Defaults to matching all domains: "*".
   *
   * @var string
   */
  public $domain;
  /**
   * Pathname within the host. Must start with a "/". A single "*" can be
   * included at the end of the path.The sum of the lengths of the domain and
   * path may not exceed 100 characters.
   *
   * @var string
   */
  public $path;
  /**
   * Resource ID of a service in this application that should serve the matched
   * request. The service must already exist. Example: default.
   *
   * @var string
   */
  public $service;

  /**
   * Domain name to match against. The wildcard "*" is supported if specified
   * before a period: "*.".Defaults to matching all domains: "*".
   *
   * @param string $domain
   */
  public function setDomain($domain)
  {
    $this->domain = $domain;
  }
  /**
   * @return string
   */
  public function getDomain()
  {
    return $this->domain;
  }
  /**
   * Pathname within the host. Must start with a "/". A single "*" can be
   * included at the end of the path.The sum of the lengths of the domain and
   * path may not exceed 100 characters.
   *
   * @param string $path
   */
  public function setPath($path)
  {
    $this->path = $path;
  }
  /**
   * @return string
   */
  public function getPath()
  {
    return $this->path;
  }
  /**
   * Resource ID of a service in this application that should serve the matched
   * request. The service must already exist. Example: default.
   *
   * @param string $service
   */
  public function setService($service)
  {
    $this->service = $service;
  }
  /**
   * @return string
   */
  public function getService()
  {
    return $this->service;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UrlDispatchRule::class, 'Google_Service_Appengine_UrlDispatchRule');
