<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Analytics;

class McfDataRows extends \Google\Collection
{
  protected $collection_key = 'conversionPathValue';
  protected $conversionPathValueType = McfDataRowsConversionPathValue::class;
  protected $conversionPathValueDataType = 'array';
  /**
   * A primitive dimension value. A primitive metric value.
   *
   * @var string
   */
  public $primitiveValue;

  /**
   * A conversion path dimension value, containing a list of interactions with
   * their attributes.
   *
   * @param McfDataRowsConversionPathValue[] $conversionPathValue
   */
  public function setConversionPathValue($conversionPathValue)
  {
    $this->conversionPathValue = $conversionPathValue;
  }
  /**
   * @return McfDataRowsConversionPathValue[]
   */
  public function getConversionPathValue()
  {
    return $this->conversionPathValue;
  }
  /**
   * A primitive dimension value. A primitive metric value.
   *
   * @param string $primitiveValue
   */
  public function setPrimitiveValue($primitiveValue)
  {
    $this->primitiveValue = $primitiveValue;
  }
  /**
   * @return string
   */
  public function getPrimitiveValue()
  {
    return $this->primitiveValue;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(McfDataRows::class, 'Google_Service_Analytics_McfDataRows');
