<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudAsset;

class ConditionContext extends \Google\Model
{
  /**
   * The hypothetical access timestamp to evaluate IAM conditions. Note that
   * this value must not be earlier than the current time; otherwise, an
   * INVALID_ARGUMENT error will be returned.
   *
   * @var string
   */
  public $accessTime;

  /**
   * The hypothetical access timestamp to evaluate IAM conditions. Note that
   * this value must not be earlier than the current time; otherwise, an
   * INVALID_ARGUMENT error will be returned.
   *
   * @param string $accessTime
   */
  public function setAccessTime($accessTime)
  {
    $this->accessTime = $accessTime;
  }
  /**
   * @return string
   */
  public function getAccessTime()
  {
    return $this->accessTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ConditionContext::class, 'Google_Service_CloudAsset_ConditionContext');
