<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Container;

class MaintenanceExclusionOptions extends \Google\Model
{
  /**
   * @var string
   */
  public $endTimeBehavior;
  /**
   * @var string
   */
  public $scope;

  /**
   * @param string
   */
  public function setEndTimeBehavior($endTimeBehavior)
  {
    $this->endTimeBehavior = $endTimeBehavior;
  }
  /**
   * @return string
   */
  public function getEndTimeBehavior()
  {
    return $this->endTimeBehavior;
  }
  /**
   * @param string
   */
  public function setScope($scope)
  {
    $this->scope = $scope;
  }
  /**
   * @return string
   */
  public function getScope()
  {
    return $this->scope;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(MaintenanceExclusionOptions::class, 'Google_Service_Container_MaintenanceExclusionOptions');
