<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_CloudAsset_Inventory extends Google_Model
{
  protected $itemsType = 'Google_Service_CloudAsset_Item';
  protected $itemsDataType = 'map';
  protected $osInfoType = 'Google_Service_CloudAsset_OsInfo';
  protected $osInfoDataType = '';

  /**
   * @param Google_Service_CloudAsset_Item
   */
  public function setItems($items)
  {
    $this->items = $items;
  }
  /**
   * @return Google_Service_CloudAsset_Item
   */
  public function getItems()
  {
    return $this->items;
  }
  /**
   * @param Google_Service_CloudAsset_OsInfo
   */
  public function setOsInfo(Google_Service_CloudAsset_OsInfo $osInfo)
  {
    $this->osInfo = $osInfo;
  }
  /**
   * @return Google_Service_CloudAsset_OsInfo
   */
  public function getOsInfo()
  {
    return $this->osInfo;
  }
}
